/*
 * Decompiled with CFR 0.152.
 */
package fang2.core;

import fang2.attributes.Location2D;
import fang2.attributes.Palette;
import fang2.core.GameRedirection;
import fang2.core.Player;
import fang2.core.Sprite;
import fang2.ui.PlayerNameInput;
import java.awt.Color;
import java.awt.Dimension;
import java.net.URL;
import java.util.Random;

public class Game
extends GameRedirection {
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.BLACK;
    public static final Dimension DEFAULT_GAME_DIMENSIONS = new Dimension(400, 400);

    public Game() {
        this(DEFAULT_GAME_DIMENSIONS, DEFAULT_BACKGROUND_COLOR);
    }

    public Game(Color color) {
        this(DEFAULT_GAME_DIMENSIONS, color);
    }

    public Game(Dimension dimension) {
        this(dimension, DEFAULT_BACKGROUND_COLOR);
    }

    public Game(int n, int n2) {
        this(new Dimension(n, n2), DEFAULT_BACKGROUND_COLOR);
    }

    public Game(int n, int n2, Color color) {
        this(new Dimension(n, n2), color);
    }

    public Game(Dimension dimension, Color color) {
        super(dimension, color);
    }

    public void initializePlayerNames() {
        for (int i = 0; i < this.getNumberOfPlayers(); ++i) {
            if (this.getPlayerName(i).equals(Player.getDefaultName(i))) continue;
            return;
        }
        this.addedGames.add(0, new PlayerNameInput());
        this.addedGames.add(1, this);
        this.finishGame();
    }

    public Location2D getMouse2D(int n) {
        return this.getPlayer(n).getMouse().getLocation();
    }

    public double getMouseX(int n) {
        return this.getMouse2D((int)n).x;
    }

    public double getMouseY(int n) {
        return this.getMouse2D((int)n).y;
    }

    public Location2D getMouse2D() {
        return this.getMouse2D(0);
    }

    public double getMouseX() {
        return this.getMouseX(0);
    }

    public double getMouseY() {
        return this.getMouseY(0);
    }

    public Location2D getClick2D(int n) {
        return this.getPlayer(n).getMouse().getClickLocation();
    }

    public double getClickX(int n) {
        if (this.getClick2D(n) == null) {
            return Double.NaN;
        }
        return this.getClick2D((int)n).x;
    }

    public double getClickY(int n) {
        if (this.getClick2D(n) == null) {
            return Double.NaN;
        }
        return this.getClick2D((int)n).y;
    }

    public Location2D getClick2D() {
        return this.getClick2D(0);
    }

    public double getClickX() {
        return this.getClickX(0);
    }

    public double getClickY() {
        return this.getClickY(0);
    }

    public Location2D getLeftClick2D(int n) {
        return this.getPlayer(n).getMouse().getLeftClickLocation();
    }

    public double getLeftClickX(int n) {
        if (this.getLeftClick2D(n) == null) {
            return Double.NaN;
        }
        return this.getLeftClick2D((int)n).x;
    }

    public double getLeftClickY(int n) {
        if (this.getLeftClick2D(n) == null) {
            return Double.NaN;
        }
        return this.getLeftClick2D((int)n).y;
    }

    public Location2D getLeftClick2D() {
        return this.getLeftClick2D(0);
    }

    public double getLeftClickX() {
        return this.getLeftClickX(0);
    }

    public double getLeftClickY() {
        return this.getLeftClickY(0);
    }

    public Location2D getMiddleClick2D(int n) {
        return this.getPlayer(n).getMouse().getMiddleClickLocation();
    }

    public double getMiddleClickX(int n) {
        if (this.getMiddleClick2D(n) == null) {
            return Double.NaN;
        }
        return this.getMiddleClick2D((int)n).x;
    }

    public double getMiddleClickY(int n) {
        if (this.getMiddleClick2D(n) == null) {
            return Double.NaN;
        }
        return this.getMiddleClick2D((int)n).y;
    }

    public Location2D getMiddleClick2D() {
        return this.getMiddleClick2D(0);
    }

    public double getMiddleClickX() {
        return this.getMiddleClickX(0);
    }

    public double getMiddleClickY() {
        return this.getMiddleClickY(0);
    }

    public Location2D getRightClick2D(int n) {
        return this.getPlayer(n).getMouse().getRightClickLocation();
    }

    public double getRightClickX(int n) {
        if (this.getRightClick2D(n) == null) {
            return Double.NaN;
        }
        return this.getRightClick2D((int)n).x;
    }

    public double getRightClickY(int n) {
        if (this.getRightClick2D(n) == null) {
            return Double.NaN;
        }
        return this.getRightClick2D((int)n).y;
    }

    public Location2D getRightClick2D() {
        return this.getRightClick2D(0);
    }

    public double getRightClickX() {
        return this.getRightClickX(0);
    }

    public double getRightClickY() {
        return this.getRightClickY(0);
    }

    public boolean mousePressed(int n) {
        return this.getPlayer(n).getMouse().buttonPressed();
    }

    public boolean mousePressed() {
        return this.mousePressed(0);
    }

    public boolean mouseLeftPressed(int n) {
        return this.getPlayer(n).getMouse().leftPressed();
    }

    public boolean mouseLeftPressed() {
        return this.mouseLeftPressed(0);
    }

    public boolean mouseMiddlePressed(int n) {
        return this.getPlayer(n).getMouse().middlePressed();
    }

    public boolean mouseMiddlePressed() {
        return this.mouseMiddlePressed(0);
    }

    public boolean mouseRightPressed(int n) {
        return this.getPlayer(n).getMouse().rightPressed();
    }

    public boolean mouseRightPressed() {
        return this.mouseRightPressed(0);
    }

    public char getKeyPressed(int n) {
        return this.getPlayer(n).getKeyboard().getLastKey();
    }

    public char getKeyPressed() {
        return this.getKeyPressed(0);
    }

    public char getLowerCaseKeyPressed(int n) {
        return Character.toLowerCase(this.getKeyPressed(n));
    }

    public char getLowerCaseKeyPressed() {
        return this.getLowerCaseKeyPressed(0);
    }

    public char getUpperCaseKeyPressed(int n) {
        return Character.toUpperCase(this.getKeyPressed(n));
    }

    public char getUpperCaseKeyPressed() {
        return this.getUpperCaseKeyPressed(0);
    }

    public boolean upPressed(int n) {
        return this.getPlayer(n).getKeyboard().upPressed();
    }

    public boolean upPressed() {
        return this.upPressed(0);
    }

    public boolean downPressed(int n) {
        return this.getPlayer(n).getKeyboard().downPressed();
    }

    public boolean downPressed() {
        return this.downPressed(0);
    }

    public boolean rightPressed(int n) {
        return this.getPlayer(n).getKeyboard().rightPressed();
    }

    public boolean rightPressed() {
        return this.rightPressed(0);
    }

    public boolean leftPressed(int n) {
        return this.getPlayer(n).getKeyboard().leftPressed();
    }

    public boolean leftPressed() {
        return this.leftPressed(0);
    }

    public boolean keyPressed(int n) {
        return this.getPlayer(n).getKeyboard().keyPressed();
    }

    public boolean keyPressed() {
        return this.keyPressed(0);
    }

    public void setAspect(double d) {
        this.getCanvas().setAspect(d);
    }

    public void restoreCursor() {
        this.getCanvas().restoreCursor();
    }

    public void removeCursor() {
        this.getCanvas().removeCursor();
    }

    public void setCursor(URL uRL) {
        this.getCanvas().setCursor(uRL);
    }

    public double getMaxX() {
        return this.getCanvas().getMaxX();
    }

    public double getMaxY() {
        return this.getCanvas().getMaxY();
    }

    public void addSprite(Sprite ... spriteArray) {
        this.getCanvas().addSprite(spriteArray);
    }

    public void addSprite(double d, Sprite ... spriteArray) {
        this.getCanvas().addSprite(d, spriteArray);
    }

    public double getLayer(Sprite sprite) {
        return this.getCanvas().getLayer(sprite);
    }

    public Sprite[] getLayer(double d) {
        return this.getCanvas().getLayer(d);
    }

    public void flattenLayers() {
        this.getCanvas().flattenLayers();
    }

    public void removeSprite(Sprite ... spriteArray) {
        this.getCanvas().removeSprite(spriteArray);
    }

    public void removeAllSprites() {
        this.getCanvas().removeAllSprites();
    }

    public boolean containsSprite(Sprite sprite) {
        return this.getCanvas().containsSprite(sprite);
    }

    public Sprite[] getAllSprites() {
        return this.getCanvas().getAllSprites();
    }

    public void addBottom(Sprite ... spriteArray) {
        this.getCanvas().addBottom(spriteArray);
    }

    public double getAspect() {
        return this.getCanvas().getAspect();
    }

    public static Color getColor(int n, int n2, int n3) {
        return Palette.getColor(n, n2, n3);
    }

    public static Color getColor(int n, int n2, int n3, int n4) {
        return Palette.getColor(n, n2, n3, n4);
    }

    public static Color getColor(String string) {
        return Palette.getColor(string);
    }

    public static Color getColor(String string, int n) {
        return Palette.getColor(string, n);
    }

    public static String getColorName(int n, int n2, int n3) {
        return Palette.getColorName(n, n2, n3);
    }

    public static String getColorName(String string) {
        return Palette.getColorName(string);
    }

    public static String getColorName(Color color) {
        return Palette.getColorName(color);
    }

    public static Color getColorFromRGB(String string) {
        return Palette.getColorFromRGB(string);
    }

    public static Color getColorFromRGBA(String string) {
        return Palette.getColorFromRGBA(string);
    }

    public static Color getColorFromRGB(String string, int n) {
        return Palette.getColorFromRGB(string, n);
    }

    public static void addColor(String string, Color color) {
        Palette.addColor(string, color);
    }

    public static void addColor(String string, String string2) {
        Palette.addColor(string, string2);
    }

    public Color randomColor() {
        return Palette.getRandomColor(Game.getCurrentGame() != null ? Game.getCurrentGame().getRandom() : new Random());
    }

    public Random getRandom() {
        return this.random;
    }

    public boolean randomBoolean() {
        return this.getRandom().nextBoolean();
    }

    public double randomDouble() {
        return this.getRandom().nextDouble();
    }

    public double randomDouble(double d) {
        return this.getRandom().nextDouble() * d;
    }

    public double randomDouble(double d, double d2) {
        return this.getRandom().nextDouble() * (d2 - d) + d;
    }

    public int randomInt() {
        return this.getRandom().nextInt();
    }

    public int randomInt(int n) {
        return this.getRandom().nextInt(n);
    }

    public int randomInt(int n, int n2) {
        return this.getRandom().nextInt(n2 - n) + n;
    }

    public int getLives(int n) {
        return this.getPlayer(n).getLives();
    }

    public int getLives() {
        return this.getLives(0);
    }

    public void setLives(int n, int n2) {
        this.getPlayer(n2).setLives(n);
    }

    public void setLives(int n) {
        this.setLives(n, 0);
    }

    public String getPlayerName(int n) {
        return this.getPlayer(n).getName();
    }

    public String getPlayerName() {
        return this.getPlayerName(0);
    }

    public void setPlayerName(String string, int n) {
        this.getPlayer(n).setName(string);
    }

    public void setPlayerName(String string) {
        this.setPlayerName(string, 0);
    }

    public int getScore(int n) {
        return this.getPlayer(n).getScore();
    }

    public int getScore() {
        return this.getScore(0);
    }

    public void setScore(int n, int n2) {
        this.getPlayer(n2).setScore(n);
    }

    public void setScore(int n) {
        this.setScore(n, 0);
    }

    public int getPlayerID() {
        return this.getID();
    }

    public boolean hasMessage(int n) {
        return this.getPlayer(n).hasMessage();
    }

    public boolean hasMessage() {
        return this.hasMessage(0);
    }

    public Object getMessage(int n) {
        return this.getPlayer(n).getMessage();
    }

    public Object getMessage() {
        return this.getMessage(0);
    }

    public void setup() {
    }

    public void advance() {
    }

    public void advance(double d) {
        this.advance();
    }
}

