/*
 * Decompiled with CFR 0.152.
 */
package fang2.core;

import fang2.core.Sprite;
import fang2.core.Transformer;
import fang2.ui.ErrorConsole;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;

public class AnimationCanvas
extends JComponent {
    private static final long serialVersionUID = 1L;
    protected static final Color DEFAULT_BACKGROUND = Color.BLACK;
    protected static final Dimension DEFAULT_SIZE = new Dimension(400, 400);
    private double aspect = 1.0;
    boolean allTransformersDirty = true;
    private final Set<Transformer> allTransformers = new LinkedHashSet<Transformer>();
    private List<DeferredSpriteAddElement> deferredAdd = null;
    private final List<DeferredSpriteAddElement> holder = new ArrayList<DeferredSpriteAddElement>();
    private final HashMap<Sprite, Double> reverseSprites;
    private final TreeMap<Double, LinkedHashSet<Sprite>> sprites;

    public AnimationCanvas() {
        this(DEFAULT_SIZE);
    }

    public AnimationCanvas(Dimension dimension) {
        this(dimension, DEFAULT_BACKGROUND);
    }

    public AnimationCanvas(Dimension dimension, Color color) {
        this.aspect = dimension.getWidth() / dimension.getHeight();
        this.setSize(dimension);
        this.sprites = new TreeMap();
        this.reverseSprites = new HashMap();
        this.setFocusable(true);
        this.setOpaque(true);
        this.setBackground(color);
        this.setIgnoreRepaint(true);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(this);
        this.addMouseMotionListener(new FocusGrabber());
    }

    public void addBottom(Sprite ... spriteArray) {
        double d = 0.0;
        if (this.sprites.size() > 0) {
            d = this.sprites.firstKey() - 1.0;
        }
        this.addSprite(d, spriteArray);
    }

    public void addSprite(double d, Sprite ... spriteArray) {
        int n = 0;
        for (Sprite sprite : spriteArray) {
            if (this.deferredAdd != null) {
                this.deferredAdd.add(new DeferredSpriteAddElement(sprite, d));
                continue;
            }
            if (sprite == null) {
                NullPointerException nullPointerException = new NullPointerException("Cannot add null Sprite to AnimationCanvas");
                this.reportNullSprite(ErrorConsole.getErrorFile(nullPointerException), ErrorConsole.getErrorLineNumber(nullPointerException), ErrorConsole.getErrorMethod(nullPointerException), n);
                throw nullPointerException;
            }
            this.addSingleSprite(d, sprite);
            ++n;
            this.allTransformersDirty = true;
        }
    }

    public void addSprite(Sprite ... spriteArray) {
        double d = 0.0;
        if (this.sprites.size() > 0) {
            d = this.sprites.lastKey() + 1.0;
        }
        this.addSprite(d, spriteArray);
    }

    public boolean containsSprite(Sprite sprite) {
        return this.reverseSprites.containsKey(sprite);
    }

    public void flattenLayers() {
        Sprite[] spriteArray = this.getAllSprites();
        this.sprites.clear();
        for (int i = 0; i < spriteArray.length; ++i) {
            LinkedHashSet<Sprite> linkedHashSet = new LinkedHashSet<Sprite>();
            linkedHashSet.add(spriteArray[i]);
            this.sprites.put(Double.valueOf(i), linkedHashSet);
        }
    }

    public Sprite[] getAllSprites() {
        Sprite[] spriteArray = new Sprite[this.reverseSprites.size()];
        int n = 0;
        for (LinkedHashSet<Sprite> linkedHashSet : this.sprites.values()) {
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                Sprite sprite;
                spriteArray[n] = sprite = (Sprite)iterator.next();
                ++n;
            }
        }
        return spriteArray;
    }

    public double getAspect() {
        return this.aspect;
    }

    public int getHeight() {
        if ((double)this.getSize().width / (double)this.getSize().height > this.aspect) {
            return this.getSize().height;
        }
        return (int)((double)this.getSize().width / this.aspect);
    }

    public Sprite[] getLayer(double d) {
        if (!this.sprites.containsKey(d)) {
            return new Sprite[0];
        }
        return this.sprites.get(d).toArray(new Sprite[0]);
    }

    public double getLayer(Sprite sprite) {
        if (this.reverseSprites.containsKey(sprite)) {
            return this.reverseSprites.get(sprite);
        }
        return Double.NaN;
    }

    public double getMaxX() {
        if (this.aspect > 1.0) {
            return this.aspect;
        }
        return 1.0;
    }

    public double getMaxY() {
        if (this.aspect < 1.0) {
            return 1.0 / this.aspect;
        }
        return 1.0;
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public int getWidth() {
        if ((double)this.getSize().width / (double)this.getSize().height > this.aspect) {
            return (int)(this.aspect * (double)this.getSize().height);
        }
        return this.getSize().width;
    }

    public void paintImmediately() {
        this.paintImmediately(0, 0, this.getSize().width, this.getSize().height);
    }

    public void removeAllSprites() {
        this.sprites.clear();
        this.reverseSprites.clear();
        this.allTransformersDirty = true;
    }

    public void removeCursor() {
        Toolkit toolkit = this.getToolkit();
        Image image = toolkit.createImage(new byte[0]);
        this.setCursor(this.getToolkit().createCustomCursor(image, new Point(), "none"));
    }

    public void removeSprite(Sprite ... spriteArray) {
        if (spriteArray == null) {
            return;
        }
        for (Sprite sprite : spriteArray) {
            if (sprite == null || !this.reverseSprites.containsKey(sprite)) continue;
            this.removeSingleSprite(sprite);
            this.allTransformersDirty = true;
        }
    }

    public void restoreCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void setAspect(double d) {
        this.aspect = d;
        Container container = this.getParent();
        if (container != null) {
            container.repaint();
        }
    }

    public void setCursor(URL uRL) {
        Toolkit toolkit = this.getToolkit();
        Image image = toolkit.createImage(uRL);
        this.setCursor(this.getToolkit().createCustomCursor(image, new Point(), "none"));
    }

    private void gatherTransfomers() {
        this.allTransformers.clear();
        for (LinkedHashSet<Sprite> linkedHashSet : this.sprites.values()) {
            for (Sprite sprite : linkedHashSet) {
                sprite.reportTransformers(this.allTransformers);
            }
        }
    }

    public void updateSprites(double d) {
        this.beginSpritesTraversal();
        if (this.allTransformersDirty) {
            this.gatherTransfomers();
        }
        for (Transformer arrayList2 : this.allTransformers) {
            arrayList2.nonMaskableAdvance(d);
            arrayList2.advance(d);
        }
        for (LinkedHashSet linkedHashSet : this.sprites.values()) {
            for (Sprite sprite : linkedHashSet) {
                sprite.applyTransformerNG();
                sprite.update();
            }
        }
        this.endSpritesTraversal();
        ArrayList arrayList3 = new ArrayList();
        ArrayList<Sprite> arrayList = new ArrayList<Sprite>();
        for (LinkedHashSet<Sprite> linkedHashSet : this.sprites.values()) {
            arrayList.clear();
            double d2 = Double.NaN;
            for (Sprite sprite : linkedHashSet) {
                if (!sprite.isDestroyed()) continue;
                arrayList.add(sprite);
                d2 = this.reverseSprites.get(sprite);
                this.reverseSprites.remove(sprite);
            }
            linkedHashSet.removeAll(arrayList);
            if (linkedHashSet.size() != 0) continue;
            arrayList3.add(d2);
        }
        Iterator<LinkedHashSet<Sprite>> iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            Double d3 = (Double)((Object)iterator.next());
            this.sprites.remove(d3);
        }
    }

    private void addSingleSprite(double d, Sprite sprite) {
        LinkedHashSet<Object> linkedHashSet = this.sprites.containsKey(d) ? this.sprites.get(d) : new LinkedHashSet();
        this.removeSingleSprite(sprite);
        linkedHashSet.add(sprite);
        this.reverseSprites.put(sprite, d);
        this.sprites.put(d, linkedHashSet);
    }

    private void beginSpritesTraversal() {
        this.deferredAdd = this.holder;
    }

    private void clearBackground(Graphics2D graphics2D) {
        RenderingHints renderingHints = new RenderingHints(null);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.addRenderingHints(renderingHints);
        graphics2D.setBackground(this.getBackground());
        graphics2D.clearRect(0, 0, 1000, 1000);
    }

    private void endSpritesTraversal() {
        this.deferredAdd = null;
        if (!this.holder.isEmpty()) {
            for (DeferredSpriteAddElement deferredSpriteAddElement : this.holder) {
                this.addSprite(deferredSpriteAddElement.layer, deferredSpriteAddElement.sprite);
            }
            this.holder.clear();
        }
    }

    private void paintSprites(Graphics2D graphics2D) {
        for (LinkedHashSet<Sprite> linkedHashSet : this.sprites.values()) {
            for (Sprite sprite : linkedHashSet) {
                sprite.paintInternal(graphics2D);
            }
        }
    }

    private void removeSingleSprite(Sprite sprite) {
        if (sprite == null || !this.reverseSprites.containsKey(sprite)) {
            return;
        }
        double d = this.reverseSprites.get(sprite);
        LinkedHashSet<Sprite> linkedHashSet = this.sprites.get(d);
        linkedHashSet.remove(sprite);
        if (linkedHashSet.size() == 0) {
            this.sprites.remove(d);
        }
        this.reverseSprites.remove(sprite);
    }

    private void reportNullSprite(String string, int n, String string2, int n2) {
        String string3 = ErrorConsole.getLine(string, n);
        String string4 = "";
        String string5 = "You are trying to add a null Sprite to the canvas on line " + n + " of the file<br>" + ErrorConsole.indent(ErrorConsole.fixedWidth(string)) + "This line is<br>" + ErrorConsole.fixedWidth(ErrorConsole.fixHTML(string3)) + "<br>";
        String string6 = "";
        string3 = string3.substring(string3.indexOf("addSprite") + 9);
        String string7 = string3 = string3.substring(string3.indexOf(40) + 1);
        int n3 = 1;
        int n4 = 0;
        while (n3 > 0) {
            if (string7.charAt(n4) == '(') {
                ++n3;
            } else if (string7.charAt(n4) == ')') {
                --n3;
            }
            ++n4;
        }
        string6 = string6 + string7.substring(0, n4 - 1);
        int n5 = 0;
        int n6 = 0;
        String string8 = null;
        int n7 = 0;
        for (n4 = 0; n4 < string6.length(); ++n4) {
            if (string6.charAt(n4) == '(') {
                ++n5;
            } else if (string6.charAt(n4) == ')') {
                --n5;
            }
            if (n5 != 0 || n4 != string6.length() - 1 && string6.charAt(n4) != ',') continue;
            if (n6 == n2) {
                if (n4 == string6.length() - 1) {
                    ++n4;
                }
                string8 = string6.substring(n7, n4);
                break;
            }
            ++n6;
            n7 = n4 + 1;
        }
        if (string8.indexOf(40) < 0) {
            string5 = string5 + "The variable " + ErrorConsole.fixedWidth(string8) + " is null. " + "The most likely cause is that " + ErrorConsole.fixedWidth(string8) + " has not been initialized.";
            string4 = string4 + "In the file " + ErrorConsole.fixedWidth(string) + " look for a line that starts with<br>" + ErrorConsole.indent(ErrorConsole.fixedWidth(string8 + " = ")) + "If you cannot find this line, then this is your problem. " + "You need a line that starts with<br>" + ErrorConsole.indent(ErrorConsole.fixedWidth(string8 + " = ")) + "Typically, this initialization statement " + "should be in the method " + ErrorConsole.fixedWidth(string2) + ", " + "in the " + ErrorConsole.fixedWidth("makeSprites") + " method, or in a " + "method called from " + ErrorConsole.fixedWidth("makeSprites") + ", " + ErrorConsole.fixedWidth("startGame") + ", " + "or " + ErrorConsole.fixedWidth("startLevel") + ".  " + "If you have a " + ErrorConsole.fixedWidth("makeSprites") + " method " + "be sure to call it from the " + ErrorConsole.fixedWidth("startGame") + " or " + ErrorConsole.fixedWidth("startLevel") + " method.";
        } else {
            string5 = string5 + "The method " + ErrorConsole.fixedWidth(ErrorConsole.fixHTML(string8.trim())) + " is returning a null value.";
            string4 = string4 + "Check the method " + ErrorConsole.fixedWidth(ErrorConsole.fixHTML(string8.trim())) + " to make sure a valid sprite is " + "being returned in all cases since null sprites " + "cannot be added to the canvas.";
        }
        ErrorConsole.addError(string5, string4, new NullPointerException());
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Double double_ = (double)this.getSize().width / (double)this.getSize().height > this.aspect ? new Point2D.Double(this.aspect * (double)this.getSize().height, this.getSize().height) : new Point2D.Double(this.getSize().width, (double)this.getSize().width / this.aspect);
        double d = Math.min(double_.x, double_.y);
        graphics2D.transform(AffineTransform.getScaleInstance(d, d));
        graphics2D.clip(new Rectangle(0, 0, (int)double_.x, (int)double_.y));
        this.clearBackground(graphics2D);
        this.paintSprites(graphics2D);
    }

    class FocusGrabber
    extends MouseMotionAdapter {
        FocusGrabber() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!AnimationCanvas.this.isFocusOwner()) {
                AnimationCanvas.this.requestFocus();
            }
        }
    }

    private class DeferredSpriteAddElement {
        public double layer;
        public Sprite sprite;

        public DeferredSpriteAddElement(Sprite sprite, double d) {
            this.sprite = sprite;
            this.layer = d;
        }
    }
}

