/*
 * Decompiled with CFR 0.152.
 */
package fang2.attributes;

import fang2.attributes.Location2D;
import fang2.core.Game;

public class Vector2D {
    private double degrees;
    private double magnitude;

    public Vector2D() {
        this(0.0, 0.0);
    }

    public Vector2D(double d, double d2) {
        if (d2 >= 0.0) {
            this.setDegrees(d);
            this.setMagnitude(d2);
        } else {
            this.setDegrees(d + 180.0);
            this.setMagnitude(-d2);
        }
    }

    public Vector2D(Location2D location2D) {
        this();
        this.setXYChange(location2D.getX(), location2D.getY());
    }

    public Vector2D(Location2D location2D, Location2D location2D2) {
        this();
        this.setXYChange(location2D2.getX() - location2D.getX(), location2D2.getY() - location2D.getY());
    }

    public Vector2D(Vector2D vector2D) {
        this(vector2D.getDegrees(), vector2D.getMagnitude());
    }

    public static final Vector2D randomVector() {
        return Vector2D.randomVector(Game.getCurrentGame());
    }

    public static final Vector2D randomVector(double d, double d2) {
        return Vector2D.randomVector(Game.getCurrentGame(), d, d2);
    }

    public static final Vector2D randomVector(Game game) {
        return Vector2D.randomVector(game, 0.0, 1.0);
    }

    public static final Vector2D randomVector(Game game, double d, double d2) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 < d) {
            d2 = d;
        }
        return new Vector2D(game.randomDouble(0.0, 360.0), game.randomDouble(d, d2));
    }

    public Vector2D accelerate(double d) {
        this.setMagnitude(this.getMagnitude() + d);
        return this;
    }

    public Vector2D add(Vector2D vector2D) {
        Vector2D vector2D2 = new Vector2D(this);
        vector2D2.addTo(vector2D);
        return vector2D2.simplify();
    }

    public Vector2D addTo(Vector2D vector2D) {
        this.setXYChange(this.getX() + vector2D.getX(), this.getY() + vector2D.getY());
        return this;
    }

    public Location2D apply(Location2D location2D) {
        return new Location2D(location2D.getX() + this.getX(), location2D.getY() + this.getY());
    }

    public Vector2D difference(Vector2D vector2D) {
        this.setXYChange(this.getX() - vector2D.getX(), this.getY() - vector2D.getY());
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Vector2D vector2D = (Vector2D)object;
        return this.getDegrees() == vector2D.getDegrees() && this.getMagnitude() == vector2D.getMagnitude();
    }

    public double getDegrees() {
        double d = this.degrees < 0.0 ? 1.0 : -1.0;
        return (this.degrees + d * 0.001) % 360.0 - d * 0.001;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public Vector2D getNormal() {
        return new Vector2D(this.getDegrees() + 90.0, 1.0);
    }

    public double getRadians() {
        return this.getDegrees() * Math.PI / 180.0;
    }

    public double getRevolutions() {
        return this.getDegrees() / 360.0;
    }

    public double getX() {
        return this.getMagnitude() * Math.cos(-Math.toRadians(this.getDegrees()));
    }

    public double getY() {
        return this.getMagnitude() * Math.sin(-Math.toRadians(this.getDegrees()));
    }

    public Vector2D multiply(double d) {
        return new Vector2D(this.degrees, this.magnitude * d).simplify();
    }

    public Vector2D normalize() {
        if (this.magnitude < 0.0) {
            this.reverse();
        }
        this.magnitude = 1.0;
        return this;
    }

    public Vector2D reverse() {
        return new Vector2D(this.getDegrees() + 180.0, this.getMagnitude());
    }

    public void setDegrees(double d) {
        while (d < 0.0) {
            d += 360.0;
        }
        while (d > 360.0) {
            d -= 360.0;
        }
        this.degrees = d;
    }

    public void setMagnitude(double d) {
        this.magnitude = d;
    }

    public void setRadians(double d) {
        this.setDegrees(d / Math.PI * 180.0);
    }

    public void setRevolutions(double d) {
        this.setDegrees(d * 360.0);
    }

    public Vector2D setXYChange(double d, double d2) {
        this.setDegrees(Math.toDegrees(Math.atan2(-d2, d)));
        this.setMagnitude(Math.sqrt(d * d + d2 * d2));
        return this;
    }

    public Vector2D simplify() {
        if (this.magnitude < 0.0) {
            this.reverse();
            this.magnitude *= -1.0;
        }
        return this;
    }

    public Vector2D subtract(Vector2D vector2D) {
        Vector2D vector2D2 = new Vector2D(this);
        vector2D2.addTo(vector2D.multiply(-1.0));
        return vector2D2.simplify();
    }

    public String toString() {
        return this.getClass().getName() + "[dir=" + this.getDegrees() + ", speed=" + this.getMagnitude() + "]";
    }

    public void turnDegrees(double d) {
        this.setDegrees(this.getDegrees() + d);
    }

    public void turnRadians(double d) {
        this.turnDegrees(d / Math.PI * 180.0);
    }

    public void turnRevolutions(double d) {
        this.turnDegrees(d * 360.0);
    }
}

