/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.plugins.bluej;

import bluej.extensions.PreferenceGenerator;
import com.puppycrawl.tools.checkstyle.plugins.bluej.BlueJManager;
import com.puppycrawl.tools.checkstyle.plugins.bluej.CheckstyleExtension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Preferences
implements PreferenceGenerator {
    private String mBeforeConfigFileName;
    private String mBeforePropsFileName;
    private JPanel mPanel = new JPanel();
    private JTextField mConfigFileTextField;
    private JButton mConfigFileButton;
    private JTextField mPropsFileTextField;
    private JButton mPropsFileButton;
    private static final int ROWS = 2;
    private static final int FIELD_WIDTH = 40;
    public static final String CONFIG_FILE_KEY = "checkstyle.ConfigFile";
    public static final String PROPS_FILE_KEY = "checkstyle.PropsFile";

    public Preferences() {
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(2, 1));
        labelPanel.add(new JLabel("Configuration File"));
        labelPanel.add(new JLabel("Properties File"));
        this.mPanel.add(labelPanel);
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new GridLayout(2, 1));
        this.mConfigFileTextField = new JTextField(40);
        fieldPanel.add(this.mConfigFileTextField);
        this.mPropsFileTextField = new JTextField(40);
        fieldPanel.add(this.mPropsFileTextField);
        this.mPanel.add(fieldPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(2, 1));
        this.mConfigFileButton = new JButton("Select");
        this.mConfigFileButton.addActionListener(new ButtonListener());
        buttonPanel.add(this.mConfigFileButton);
        this.mPropsFileButton = new JButton("Select");
        this.mPropsFileButton.addActionListener(new ButtonListener());
        buttonPanel.add(this.mPropsFileButton);
        this.mPanel.add(buttonPanel);
        this.loadValues();
    }

    public void saveValues() {
        BlueJManager manager = BlueJManager.getInstance();
        String afterConfigFileName = this.mConfigFileTextField.getText();
        manager.saveConfigFileName(afterConfigFileName);
        String afterPropsFileName = this.mPropsFileTextField.getText();
        manager.savePropsFileName(afterPropsFileName);
        if (!this.mBeforeConfigFileName.equals(afterConfigFileName) || !this.mBeforePropsFileName.equals(afterPropsFileName)) {
            CheckstyleExtension.getInstance().refreshView();
        }
    }

    public void loadValues() {
        BlueJManager manager = BlueJManager.getInstance();
        this.mBeforeConfigFileName = manager.getConfigFileName();
        this.mBeforePropsFileName = manager.getPropsFileName();
        this.mConfigFileTextField.setText(this.mBeforeConfigFileName);
        this.mPropsFileTextField.setText(this.mBeforePropsFileName);
    }

    public JPanel getPanel() {
        return this.mPanel;
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent aEvent) {
            JFileChooser chooser = new JFileChooser();
            if (chooser.showOpenDialog(null) != 0) {
                return;
            }
            File selectedFile = chooser.getSelectedFile();
            String fileName = selectedFile.toString();
            if (aEvent.getSource() == Preferences.this.mConfigFileButton) {
                Preferences.this.mConfigFileTextField.setText(fileName);
            } else {
                Preferences.this.mPropsFileTextField.setText(fileName);
            }
        }
    }
}

