/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.plugins.bluej;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.plugins.bluej.Auditor;
import com.puppycrawl.tools.checkstyle.plugins.bluej.BlueJManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public class BlueJChecker {
    public Auditor processAllFiles() throws CheckstyleException {
        Set<File> files;
        try {
            files = BlueJManager.getInstance().getFiles();
        }
        catch (Exception e) {
            throw new CheckstyleException(e.getMessage());
        }
        return this.process(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Auditor process(Set<File> files) throws CheckstyleException {
        Properties props = new Properties(BlueJManager.getInstance().properties());
        try {
            InputStream propStream = BlueJManager.getInstance().getPropertyStream();
            if (propStream != null) {
                props.load(propStream);
            }
        }
        catch (IOException ex) {
            throw new CheckstyleException(ex.getMessage());
        }
        Checker c = new Checker();
        c.setModuleClassLoader(BlueJChecker.class.getClassLoader());
        Configuration config = ConfigurationLoader.loadConfiguration(BlueJManager.getInstance().getConfigStream(), (PropertyResolver)new PropertiesExpander(props), true);
        c.configure(config);
        Auditor auditor = new Auditor();
        c.addListener(auditor);
        Class<TreeWalker> clazz = TreeWalker.class;
        synchronized (TreeWalker.class) {
            c.process(new ArrayList<File>(files));
            // ** MonitorExit[var6_7] (shouldn't be in output)
            c.destroy();
            return auditor;
        }
    }
}

