/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.plugins.bluej;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.plugins.bluej.Auditor;
import com.puppycrawl.tools.checkstyle.plugins.bluej.ErrorTableModel;
import com.puppycrawl.tools.checkstyle.plugins.bluej.FileAuditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;

public class AuditFrame
extends JFrame {
    private static final int LINE_WIDTH = 50;
    private static final int COL_WIDTH = 50;
    private static final int ERROR_WIDTH = 300;
    private static final int TABLE_HEIGHT = 300;
    private final ErrorTableModel mModel = new ErrorTableModel();
    private final JList mFileList = new JList();
    private final DefaultListCellRenderer mDefaultListCellRenderer = new DefaultListCellRenderer();
    private final FileCellRenderer mFileCellRenderer = new FileCellRenderer();

    public AuditFrame() {
        this.setTitle("Checkstyle");
        JScrollPane listScrollPane = new JScrollPane(this.mFileList);
        this.mFileList.addListSelectionListener(new ListListener());
        this.mFileList.setCellRenderer(new FileCellRenderer());
        JTable table = new JTable(this.mModel);
        TableColumnModel columnMode = table.getColumnModel();
        columnMode.getColumn(0).setPreferredWidth(50);
        columnMode.getColumn(1).setPreferredWidth(50);
        columnMode.getColumn(2).setPreferredWidth(300);
        table.setPreferredScrollableViewportSize(new Dimension(400, 300));
        JScrollPane errorsScrollPane = new JScrollPane(table);
        JSplitPane splitPane = new JSplitPane(1, listScrollPane, errorsScrollPane);
        splitPane.setOneTouchExpandable(true);
        this.getContentPane().add(splitPane);
    }

    public synchronized void setAuditor(Auditor aAuditor) {
        boolean useSelection = false;
        Object[] auditors = aAuditor.getFileAuditors().toArray();
        if (auditors.length == 0) {
            this.mFileList.setCellRenderer(this.mDefaultListCellRenderer);
            this.mFileList.setListData(new String[]{"(No files)"});
        } else {
            int index;
            Object oldSelection = this.mFileList.getSelectedValue();
            this.mFileList.setCellRenderer(this.mFileCellRenderer);
            Arrays.sort(auditors);
            this.mFileList.setListData(auditors);
            if (oldSelection != null && (index = Arrays.binarySearch(auditors, oldSelection)) >= 0) {
                useSelection = true;
                this.mFileList.setSelectedIndex(index);
            }
        }
        if (!useSelection) {
            this.mModel.setEvents(new AuditEvent[0]);
        }
    }

    private class FileCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public FileCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList aList, Object aValue, int aIndex, boolean aIsSelected, boolean aCellHasFocus) {
            FileAuditor auditor = (FileAuditor)aValue;
            String text = auditor.getBaseClassName();
            if (auditor.getEvents().size() > 0) {
                text = text + "*";
            }
            this.setText(text);
            this.setForeground(aList.getForeground());
            if (aIsSelected) {
                this.setBackground(aList.getSelectionBackground());
            } else if (auditor.getEvents().size() == 0) {
                this.setBackground(Color.WHITE);
            } else {
                this.setBackground(Color.YELLOW);
            }
            return this;
        }
    }

    private class ListListener
    implements ListSelectionListener {
        private ListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent aEvent) {
            if (aEvent.getValueIsAdjusting()) {
                return;
            }
            JList theList = (JList)aEvent.getSource();
            if (!theList.isSelectionEmpty()) {
                FileAuditor fileAuditor = (FileAuditor)theList.getSelectedValue();
                AuditEvent[] events = new AuditEvent[fileAuditor.getEvents().size()];
                for (int i = fileAuditor.getEvents().size() - 1; i >= 0; --i) {
                    events[i] = fileAuditor.getEvents().get(i);
                }
                AuditFrame.this.mModel.setEvents(events);
            }
        }
    }
}

