/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import javalib.colors.IColor;
import javalib.worldcanvas.CanvasPanel;
import javalib.worldimages.ColoredImage;
import javalib.worldimages.Mode;
import javalib.worldimages.TextStyle;

class TextImage
extends ColoredImage {
    private String text;
    private float size;
    static final float defaultSize = 13.0f;
    private TextStyle style;
    private int width;
    private int height;
    private int ascent;
    private static CanvasPanel c = new CanvasPanel(600, 600);
    private static Graphics2D g = c.getBufferGraphics();
    private static Font font = g.getFont();

    private TextImage(String text, float size, TextStyle style, Color color) {
        super(color, Mode.FILLED);
        if (text == null || text.equals("")) {
            text = " ";
        }
        this.text = text;
        this.size = size;
        this.style = style;
        this.setWidthHeight();
    }

    static TextImage make(String text, float size, TextStyle style, Color color) {
        return new TextImage(text, size, style, color);
    }

    static TextImage make(String text, float size, TextStyle style, IColor color) {
        return new TextImage(text, size, style, color.thisColor());
    }

    static TextImage make(String text, float size, TextStyle style) {
        return new TextImage(text, size, style, Color.black);
    }

    static TextImage make(String text, float size, Color color) {
        return new TextImage(text, size, TextStyle.REGULAR, color);
    }

    static TextImage make(String text, float size, IColor color) {
        return new TextImage(text, size, TextStyle.REGULAR, color.thisColor());
    }

    static TextImage make(String text, float size) {
        return new TextImage(text, size, TextStyle.REGULAR, Color.black);
    }

    static TextImage make(String text, TextStyle style, Color color) {
        return new TextImage(text, 13.0f, style, color);
    }

    static TextImage make(String text, TextStyle style, IColor color) {
        return new TextImage(text, 13.0f, style, color.thisColor());
    }

    static TextImage make(String text, TextStyle style) {
        return new TextImage(text, 13.0f, style, Color.black);
    }

    static TextImage make(String text, Color color) {
        return new TextImage(text, 13.0f, TextStyle.REGULAR, color);
    }

    static TextImage make(String text, IColor color) {
        return new TextImage(text, 13.0f, TextStyle.REGULAR, color.thisColor());
    }

    static TextImage make(String text) {
        return new TextImage(text, 13.0f, TextStyle.REGULAR, Color.black);
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.text == null) {
            this.text = "";
        }
        Paint oldPaint = g.getPaint();
        Font oldFont = g.getFont();
        g.setFont(oldFont.deriveFont(this.style.toInt(), this.size));
        g.setPaint(this.getColor());
        g.drawString(this.text, 0, this.ascent);
        g.setPaint(oldPaint);
        g.setFont(oldFont);
    }

    protected void setWidthHeight() {
        g.setFont(font.deriveFont(this.style.toInt(), this.size));
        Font newFont = g.getFont();
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout(this.text, newFont, frc);
        g.setFont(font);
        Rectangle bounds = layout.getBounds().getBounds();
        this.ascent = -bounds.y;
        this.height = bounds.height;
        this.width = bounds.width;
    }

    @Override
    public int getRight() {
        return this.width;
    }

    @Override
    public int getBottom() {
        return this.height;
    }

    @Override
    public String toIndentedString(String indent) {
        String newIndent = indent + "  ";
        return "new TextImage(this.text = \"" + this.text + "\",\n" + newIndent + "this.style = " + (Object)((Object)this.style) + ",\n" + newIndent + "this.size = " + this.size + ",\n" + newIndent + "this.color = " + this.getColor() + ",\n" + newIndent + this.cornerString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            TextImage that = (TextImage)o;
            return this.size == that.size && this.style == that.style && this.text.equals(that.text);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.getColor().hashCode() + (int)this.size + this.style.hashCode() + this.text.hashCode();
    }

    @Override
    ColoredImage replaceColor(Color color) {
        return new TextImage(this.text, this.size, this.style, color);
    }

    @Override
    ColoredImage replaceMode(Mode newMode) {
        return this;
    }
}

