/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import javalib.worldimages.AImage;
import javalib.worldimages.Mode;
import javalib.worldimages.Posn;
import javalib.worldimages.SampleImages;
import javalib.worldimages.WorldImage;
import junit.framework.TestCase;
import tester.Tester;

public class TestAImage
extends TestCase {
    private WorldImage redRect = AImage.makeRectangle(50, 30, Color.red, Mode.FILLED);
    private WorldImage cal = SampleImages.calendar;

    public static void testEverything() {
        TestAImage it = new TestAImage();
        boolean worked = Tester.run((Object)((Object)it));
        TestCase.assertTrue((boolean)worked);
    }

    public void testSame(Tester t) {
        t.checkExpect((Object)this.redRect, (Object)this.redRect, "comparing red rect with itself");
        WorldImage doubleRedRect = this.redRect.above(this.redRect);
        t.checkExpect((Object)doubleRedRect, (Object)AImage.makeRectangle(50, 60, Color.red, Mode.FILLED), "comparing redRect.above(redRect) with a double-height rect");
        t.checkExpect((Object)WorldImage.LOOKS_SAME.equivalent((Object)doubleRedRect, (Object)AImage.makeRectangle(50, 60, Color.red, Mode.FILLED)), (Object)true, "comparing redRect.above(redRect) with a double-height rect, using equivalent()");
        WorldImage blah = AImage.makeCenteredCircle(new Posn(10, 10), 5, Color.blue).overlayCentered(this.redRect);
        t.checkExpect((Object)blah, (Object)this.redRect, "comparing redRect overlaid on small disk with redRect itself");
        WorldImage blerg = this.redRect.overlayCentered(AImage.makeCenteredCircle(new Posn(10, 10), 5, Color.blue));
        t.checkFail((Object)blerg, (Object)this.redRect, "comparing redRect under a small disk with redRect itself");
        WorldImage blueCirc = AImage.makeCircle(30, Color.blue, Mode.OUTLINED);
        t.checkExpect((Object)blueCirc, (Object)blueCirc.rotatedInPlace(90), "comparing circle with circle rotated 90 degrees");
    }

    public void testGetPixelColor(Tester t) {
        WorldImage rect = AImage.makeRectangle(5, 3, Color.yellow, Mode.FILLED);
        Color transparent = new Color(0, 0, 0, 0);
        t.checkExpect((Object)rect.getPixelColor(-1, 0), (Object)transparent);
        t.checkExpect((Object)rect.getPixelColor(0, -2), (Object)transparent);
        t.checkExpect((Object)rect.getPixelColor(5, 2), (Object)transparent);
        t.checkExpect((Object)rect.getPixelColor(1, 4), (Object)transparent);
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 3; ++y) {
                t.checkExpect((Object)rect.getPixelColor(x, y), (Object)Color.yellow);
            }
        }
        WorldImage circ = AImage.makeCircle(5, Color.blue, Mode.FILLED);
        t.checkExpect((Object)circ.getPixelColor(5, 5), (Object)Color.blue);
        t.checkExpect((Object)circ.getPixelColor(1, 9), (Object)transparent);
        t.checkExpect((Object)circ.getPixelColor(2, 8), (Object)Color.blue);
    }
}

