/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import javalib.colors.IColor;
import javalib.worldimages.ColoredImage;
import javalib.worldimages.Mode;

abstract class RectangularImage
extends ColoredImage {
    private int width;
    private int height;

    RectangularImage(int width, int height, Color color, Mode mode) {
        super(color, mode);
        this.width = width;
        this.height = height;
    }

    RectangularImage(int width, int height, IColor color, Mode mode) {
        super(color, mode);
        this.width = width;
        this.height = height;
    }

    @Override
    public int getRight() {
        return this.width;
    }

    @Override
    public int getBottom() {
        return this.height;
    }

    abstract RectangularImage replaceDimensions(int var1, int var2);

    RectangularImage replaceWidth(int width) {
        return this.replaceDimensions(width, this.height);
    }

    RectangularImage replaceHeight(int height) {
        return this.replaceDimensions(this.width, height);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.width == ((RectangularImage)other).getWidth() && this.height == ((RectangularImage)other).getHeight();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + RectangularImage.rotate(this.width, 16) + this.height;
    }
}

