/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import javalib.colors.IColor;
import javalib.worldimages.ColoredImage;
import javalib.worldimages.Mode;
import javalib.worldimages.RectangularImage;

class RectangleImage
extends RectangularImage {
    protected RectangleImage(int width, int height, Color color, Mode mode) {
        super(width, height, color, mode);
    }

    static RectangleImage make(int width, int height, Color color, Mode mode) {
        return new RectangleImage(width, height, color, mode);
    }

    static RectangleImage make(int width, int height, IColor color, Mode mode) {
        return new RectangleImage(width, height, color.thisColor(), mode);
    }

    static RectangleImage make(int width, int height, Mode mode) {
        return new RectangleImage(width, height, Color.black, mode);
    }

    static RectangleImage make(int width, int height, Color color) {
        return new RectangleImage(width, height, color, Mode.OUTLINED);
    }

    static RectangleImage make(int width, int height, IColor color) {
        return new RectangleImage(width, height, color.thisColor(), Mode.OUTLINED);
    }

    static RectangleImage make(int width, int height) {
        return new RectangleImage(width, height, Color.black, Mode.OUTLINED);
    }

    @Override
    RectangularImage replaceDimensions(int width, int height) {
        return new RectangleImage(this.getWidth(), this.getHeight(), this.getColor(), this.getMode());
    }

    @Override
    ColoredImage replaceColor(Color newColor) {
        return new RectangleImage(this.getWidth(), this.getHeight(), newColor, this.getMode());
    }

    @Override
    ColoredImage replaceMode(Mode newMode) {
        return new RectangleImage(this.getWidth(), this.getHeight(), this.getColor(), newMode);
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.getWidth() <= 0) {
            return;
        }
        if (this.getHeight() <= 0) {
            return;
        }
        Paint oldPaint = g.getPaint();
        g.setPaint(this.getColor());
        Rectangle2D.Double rect = new Rectangle2D.Double(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        if (this.getMode() == Mode.FILLED) {
            g.fill(rect);
        } else if (this.getMode() == Mode.OUTLINED) {
            g.draw(rect);
        }
        g.setPaint(oldPaint);
    }

    @Override
    public String toIndentedString(String indent) {
        String newIndent = indent + "  ";
        return "new RectangleImage(this.width = " + this.getWidth() + ", this.height = " + this.getHeight() + ",\n" + newIndent + "this.color = " + this.getColor() + ",\n" + newIndent + this.cornerString() + ")";
    }
}

