/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javalib.worldimages.AImage;
import javalib.worldimages.ImageBuilder;
import javalib.worldimages.ImageMap;
import javalib.worldimages.LooksTheSame;
import javalib.worldimages.WorldImage;
import javax.imageio.ImageIO;

public class RasterImage
extends AImage {
    protected BufferedImage rendering;
    public static final AffineTransform id = AffineTransform.getTranslateInstance(0.0, 0.0);
    static final Color transparent = new Color(0, 0, 0, 0);

    protected RasterImage(BufferedImage rendering) {
        this.rendering = rendering;
    }

    protected RasterImage() {
        this.rendering = null;
    }

    static RasterImage make(BufferedImage rendering) {
        return new RasterImage(rendering);
    }

    protected void setRendering(BufferedImage rendering) {
        this.rendering = rendering;
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.rendering == null) {
            System.err.println("This shouldn't happen: drawing a null RasterImage.");
        } else {
            g.drawRenderedImage(this.rendering, id);
        }
    }

    @Override
    public String toIndentedString(String indent) {
        String newIndent = indent + "  ";
        return "new RasterImage(hashCode = " + this.rendering.hashCode() + ",\n" + newIndent + this.cornerString() + ")";
    }

    @Override
    public RasterImage frozen() {
        return this;
    }

    protected void renderIfNecessary() {
        if (this.rendering == null) {
            throw new RuntimeException("This shouldn't happen: RasterImage has null rendering but isn't a FreezeImage.");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            this.renderIfNecessary();
            RasterImage otherR = (RasterImage)other;
            otherR.renderIfNecessary();
            return LooksTheSame.equalBufferedImages(this.rendering, otherR.rendering);
        }
        return false;
    }

    @Override
    public int hashCode() {
        this.renderIfNecessary();
        return super.hashCode() + this.rendering.hashCode();
    }

    @Override
    public int getRight() {
        this.renderIfNecessary();
        return this.rendering.getWidth();
    }

    @Override
    public int getBottom() {
        this.renderIfNecessary();
        return this.rendering.getHeight();
    }

    @Override
    public boolean save(String filename) {
        this.renderIfNecessary();
        try {
            File outputfile = new File(filename);
            boolean created = outputfile.createNewFile();
            return outputfile.canWrite() && ImageIO.write((RenderedImage)this.rendering, "png", outputfile);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static void colorToIntArray(Color c, int[] components) {
        components[0] = c.getRed();
        components[1] = c.getGreen();
        components[2] = c.getBlue();
        components[3] = c.getAlpha();
    }

    private static Color intArrayToColor(int[] components) {
        return new Color(components[0], components[1], components[2], components[3]);
    }

    public static WorldImage build(int width, int height, ImageBuilder b, Object extra) {
        BufferedImage buffer = new BufferedImage(width, height, 2);
        WritableRaster raster = buffer.getRaster();
        int[] colorComponents = new int[4];
        for (int col = 0; col < width; ++col) {
            for (int row = 0; row < height; ++row) {
                Color c = b.pixelColor(col, row, extra);
                RasterImage.colorToIntArray(c, colorComponents);
                raster.setPixel(col, row, colorComponents);
            }
        }
        return new RasterImage(buffer);
    }

    @Override
    public WorldImage map(ImageMap b, Object extra) {
        int width = this.getWidth();
        int height = this.getHeight();
        Raster srcRaster = this.rendering.getData();
        boolean hasAlpha = this.rendering.getColorModel().hasAlpha();
        BufferedImage buffer = new BufferedImage(width, height, 2);
        WritableRaster dstRaster = buffer.getRaster();
        int[] colorComponents = new int[4];
        if (!hasAlpha) {
            colorComponents[3] = 255;
        }
        for (int col = 0; col < width; ++col) {
            for (int row = 0; row < height; ++row) {
                srcRaster.getPixel(col, row, colorComponents);
                Color srcColor = RasterImage.intArrayToColor(colorComponents);
                Color dstColor = b.pixelColor(col, row, srcColor, extra);
                RasterImage.colorToIntArray(dstColor, colorComponents);
                dstRaster.setPixel(col, row, colorComponents);
            }
        }
        return new RasterImage(buffer);
    }

    @Override
    public Color getPixelColor(int x, int y) {
        this.renderIfNecessary();
        int width = this.getWidth();
        int height = this.getHeight();
        if (x < 0 || y < 0 || x >= width || y >= height) {
            return transparent;
        }
        Raster srcRaster = this.rendering.getData();
        boolean hasAlpha = this.rendering.getColorModel().hasAlpha();
        int[] colorComponents = new int[4];
        if (!hasAlpha) {
            colorComponents[3] = 255;
        }
        srcRaster.getPixel(x, y, colorComponents);
        return RasterImage.intArrayToColor(colorComponents);
    }
}

