/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.util.Arrays;
import javalib.colors.IColor;
import javalib.worldimages.ColoredImage;
import javalib.worldimages.Mode;
import javalib.worldimages.Posn;

class PolygonImage
extends ColoredImage {
    protected Polygon poly;
    protected int[] xcoord;
    protected int[] ycoord;
    private int left;
    private int top;
    private int right;
    private int bottom;

    protected PolygonImage(Color color, Mode mode, Posn ... points) {
        super(color, mode);
        this.xcoord = new int[points.length];
        this.ycoord = new int[points.length];
        for (int ii = 0; ii < points.length; ++ii) {
            this.xcoord[ii] = points[ii].getX();
            this.ycoord[ii] = points[ii].getY();
        }
        this.poly = new Polygon(this.xcoord, this.ycoord, points.length);
        this.computeBounds();
    }

    static PolygonImage make(Color color, Mode mode, Posn ... points) {
        return new PolygonImage(color, mode, points);
    }

    static PolygonImage make(IColor color, Mode mode, Posn ... points) {
        return new PolygonImage(color.thisColor(), mode, points);
    }

    static PolygonImage make(Mode mode, Posn ... points) {
        return new PolygonImage(Color.black, mode, points);
    }

    static PolygonImage make(Color color, Posn ... points) {
        return new PolygonImage(color, Mode.OUTLINED, points);
    }

    static PolygonImage make(IColor color, Posn ... points) {
        return new PolygonImage(color.thisColor(), Mode.OUTLINED, points);
    }

    static PolygonImage make(Posn ... points) {
        return new PolygonImage(Color.black, Mode.OUTLINED, points);
    }

    private void computeBounds() {
        this.left = Integer.MAX_VALUE;
        this.right = Integer.MIN_VALUE;
        for (int coord : this.xcoord) {
            this.left = Math.min(this.left, coord);
            this.right = Math.max(this.right, coord);
        }
        this.top = Integer.MAX_VALUE;
        this.bottom = Integer.MIN_VALUE;
        for (int coord : this.ycoord) {
            this.top = Math.min(this.top, coord);
            this.bottom = Math.max(this.bottom, coord);
        }
    }

    protected PolygonImage(Color color, Mode mode, int[] xcoord, int[] ycoord) {
        super(color, mode);
        this.xcoord = xcoord;
        this.ycoord = ycoord;
        this.poly = new Polygon(xcoord, ycoord, xcoord.length);
    }

    @Override
    public int getLeft() {
        return this.left;
    }

    @Override
    public int getRight() {
        return this.right;
    }

    @Override
    public int getTop() {
        return this.top;
    }

    @Override
    public int getBottom() {
        return this.bottom;
    }

    @Override
    public void draw(Graphics2D g) {
        Paint oldPaint = g.getPaint();
        g.setPaint(this.getColor());
        if (this.getMode() == Mode.FILLED) {
            g.fill(this.poly);
        } else if (this.getMode() == Mode.OUTLINED) {
            g.draw(this.poly);
        }
        g.setPaint(oldPaint);
    }

    @Override
    public ColoredImage replaceColor(Color newColor) {
        return new PolygonImage(newColor, this.getMode(), this.xcoord, this.ycoord);
    }

    @Override
    public ColoredImage replaceMode(Mode newMode) {
        return new PolygonImage(this.getColor(), newMode, this.xcoord, this.ycoord);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Arrays.equals(this.xcoord, ((PolygonImage)o).xcoord) && Arrays.equals(this.ycoord, ((PolygonImage)o).ycoord);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        for (int ii = 0; ii < this.xcoord.length; ++ii) {
            result = PolygonImage.rotate(result, 2) + PolygonImage.rotate(this.xcoord[ii], 1) + this.ycoord[ii];
        }
        return result;
    }

    @Override
    public String toIndentedString(String indent) {
        String newIndent = indent + "  ";
        return "new PolygonImage(this.color = " + this.getColor() + ",\n" + newIndent + "this.mode = " + (Object)((Object)this.getMode()) + ",\n" + newIndent + "this.xcoord = " + this.xcoord + ",\n" + newIndent + "this.ycoord = " + this.ycoord + ",\n" + newIndent + this.cornerString() + ")";
    }
}

