/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Graphics2D;
import javalib.worldimages.AImage;
import javalib.worldimages.WorldImage;

public class OverlayImage
extends AImage {
    private WorldImage back;
    private WorldImage front;

    private OverlayImage(WorldImage back, WorldImage front) {
        this.back = back;
        this.front = front;
    }

    static OverlayImage make(WorldImage back, WorldImage front) {
        return new OverlayImage(back, front);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && ((Object)this.back).equals(((OverlayImage)other).back) && ((Object)this.front).equals(((OverlayImage)other).front);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + OverlayImage.rotate(((Object)this.back).hashCode(), 16) + ((Object)this.front).hashCode();
    }

    public WorldImage getBack() {
        return this.back;
    }

    public WorldImage getFront() {
        return this.front;
    }

    @Override
    public int getTop() {
        return Math.min(this.back.getTop(), this.front.getTop());
    }

    @Override
    public int getBottom() {
        return Math.max(this.back.getBottom(), this.front.getBottom());
    }

    @Override
    public int getLeft() {
        return Math.min(this.back.getLeft(), this.front.getLeft());
    }

    @Override
    public int getRight() {
        return Math.max(this.back.getRight(), this.front.getRight());
    }

    @Override
    public int getWidth() {
        return this.getRight() - this.getLeft();
    }

    @Override
    public int getHeight() {
        return this.getBottom() - this.getTop();
    }

    @Override
    public String toIndentedString(String indent) {
        String newIndent = indent + "  ";
        return "new OverlayImage(\n" + newIndent + "this.back = " + this.back.toIndentedString(newIndent) + ",\n" + newIndent + "this.front = " + this.front.toIndentedString(newIndent) + ",\n" + newIndent + this.cornerString() + ")";
    }

    @Override
    public void draw(Graphics2D g) {
        this.back.draw(g);
        this.front.draw(g);
    }
}

