/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import javalib.worldimages.RasterImage;
import javalib.worldimages.WorldImage;
import tester.Equivalence;

public class LooksTheSame
implements Equivalence<WorldImage> {
    public static final LooksTheSame it = new LooksTheSame();

    private LooksTheSame() {
    }

    public boolean equivalent(WorldImage t1, WorldImage t2) {
        if (((Object)t1).equals(t2)) {
            return true;
        }
        RasterImage ft1 = t1 instanceof RasterImage ? (RasterImage)t1 : t1.frozen();
        RasterImage ft2 = t2 instanceof RasterImage ? (RasterImage)t2 : t2.frozen();
        ft1.renderIfNecessary();
        ft2.renderIfNecessary();
        boolean answer = LooksTheSame.equalBufferedImages(ft1.rendering, ft2.rendering);
        return answer;
    }

    static boolean equalBufferedImages(BufferedImage b1, BufferedImage b2) {
        int size2;
        int banks2;
        DataBuffer db2;
        Raster r2;
        if (b1 == b2) {
            return true;
        }
        Raster r1 = b1.getData();
        if (r1 == (r2 = b2.getData())) {
            return true;
        }
        DataBuffer db1 = r1.getDataBuffer();
        if (db1 == (db2 = r2.getDataBuffer())) {
            return true;
        }
        int banks1 = db1.getNumBanks();
        if (banks1 != (banks2 = db2.getNumBanks())) {
            return false;
        }
        int size1 = db1.getSize();
        if (size1 != (size2 = db2.getSize())) {
            return false;
        }
        for (int bank = 0; bank < banks1; ++bank) {
            for (int ii = 0; ii < size1; ++ii) {
                if (db1.getElem(bank, ii) == db2.getElem(bank, ii)) continue;
                return false;
            }
        }
        return true;
    }
}

