/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javalib.worldimages.AImage;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

public class LinearImage
extends AImage {
    private WorldImage base;
    private AffineTransform transform;
    private int top;
    private int left;
    private int bottom;
    private int right;

    LinearImage(AffineTransform transform, WorldImage base) {
        this.base = base;
        this.transform = transform;
        this.setBBox();
    }

    static WorldImage make(AffineTransform transform, WorldImage base) {
        if (base instanceof LinearImage) {
            LinearImage theBase = (LinearImage)base;
            AffineTransform temp = new AffineTransform(transform);
            temp.concatenate(theBase.transform);
            if (temp.isIdentity()) {
                return theBase.base;
            }
            return new LinearImage(temp, theBase.base);
        }
        return new LinearImage(transform, base);
    }

    private void setBBox() {
        Point2D.Float topLeft = new Point2D.Float(this.base.getLeft(), this.base.getTop());
        Point2D.Float topRight = new Point2D.Float(this.base.getRight(), this.base.getTop());
        Point2D.Float botLeft = new Point2D.Float(this.base.getLeft(), this.base.getBottom());
        Point2D.Float botRight = new Point2D.Float(this.base.getRight(), this.base.getBottom());
        Point2D rtl = this.transform.transform(topLeft, null);
        Point2D rtr = this.transform.transform(topRight, null);
        Point2D rbl = this.transform.transform(botLeft, null);
        Point2D rbr = this.transform.transform(botRight, null);
        this.top = (int)Math.min(Math.min(rtl.getY(), rtr.getY()), Math.min(rbl.getY(), rbr.getY()));
        this.left = (int)Math.min(Math.min(rtl.getX(), rtr.getX()), Math.min(rbl.getX(), rbr.getX()));
        this.bottom = (int)Math.max(Math.max(rtl.getY(), rtr.getY()), Math.max(rbl.getY(), rbr.getY()));
        this.right = (int)Math.max(Math.max(rtl.getX(), rtr.getX()), Math.max(rbl.getX(), rbr.getX()));
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            LinearImage otherLI = (LinearImage)other;
            return ((Object)this.base).equals(otherLI.base) && this.transform.equals(otherLI.transform);
        }
        return false;
    }

    public Posn getTranslation() {
        return new Posn(this.getX(), this.getY());
    }

    public int getX() {
        return (int)Math.round(this.transform.getTranslateX());
    }

    public int getY() {
        return (int)Math.round(this.transform.getTranslateY());
    }

    @Override
    public int getTop() {
        return this.top;
    }

    @Override
    public int getLeft() {
        return this.left;
    }

    @Override
    public int getRight() {
        return this.right;
    }

    @Override
    public int getBottom() {
        return this.bottom;
    }

    @Override
    public int getWidth() {
        return this.right - this.left;
    }

    @Override
    public int getHeight() {
        return this.bottom - this.top;
    }

    @Override
    public void draw(Graphics2D g) {
        AffineTransform oldTransform = g.getTransform();
        g.transform(this.transform);
        this.base.draw(g);
        g.setTransform(oldTransform);
    }

    @Override
    public String toIndentedString(String indent) {
        String newIndent = indent + "  ";
        return "new LinearImage(this.base = \n" + newIndent + this.base.toIndentedString(newIndent) + ",\n" + newIndent + "this.transform = " + this.transform.toString() + ",\n" + newIndent + this.cornerString() + ")";
    }
}

