/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javalib.worldimages.LoadedImages;
import javalib.worldimages.RasterImage;
import javalib.worldimages.WorldImage;
import javax.imageio.ImageIO;

public class FromURLImage
extends RasterImage {
    private String urlString;
    private URL url;

    static WorldImage make(String urlString) {
        try {
            URI uri = new URI(urlString);
            URL url = uri.toURL();
            return new FromURLImage(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    FromURLImage(URL url) throws IOException {
        if (url == null) {
            return;
        }
        this.url = url;
        this.urlString = url.toString();
        if (LoadedImages.table.containsKey(this.urlString)) {
            this.setRendering(LoadedImages.table.get(this.urlString));
        } else {
            BufferedImage img = ImageIO.read(this.url);
            LoadedImages.table.put(this.urlString, img);
            this.setRendering(img);
        }
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.urlString.equals(((FromURLImage)other).urlString);
    }

    @Override
    public String toIndentedString(String indent) {
        String newIndent = indent + "  ";
        return "new FromURLImage(this.url = \"" + this.urlString + "\",\n" + newIndent + this.cornerString() + ")";
    }
}

