/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javalib.worldimages.FromURLImage;
import javalib.worldimages.LoadedImages;
import javalib.worldimages.RasterImage;
import javalib.worldimages.WorldImage;
import javax.imageio.ImageIO;

public class FromFileImage
extends RasterImage {
    private static boolean isApplet = false;
    private String fileName;
    private File inputFile;

    static void setIsApplet(boolean flag) {
        isApplet = flag;
    }

    static WorldImage make(String fileName) {
        try {
            if (isApplet) {
                return new FromURLImage(FromFileImage.class.getResource("/" + fileName));
            }
            return new FromFileImage(new File(fileName));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.fileName.equals(((FromFileImage)other).fileName);
    }

    private FromFileImage(File inputFile) throws IOException {
        this.inputFile = inputFile;
        this.fileName = inputFile.getCanonicalPath();
        if (LoadedImages.table.containsKey(this.fileName)) {
            this.setRendering(LoadedImages.table.get(this.fileName));
        } else {
            BufferedImage img = ImageIO.read(this.inputFile);
            LoadedImages.table.put(this.fileName, img);
            this.setRendering(img);
        }
    }

    @Override
    public String toIndentedString(String indent) {
        String newIndent = indent + "  ";
        return "new FromFileImage(this.fileName = \"" + this.fileName + "\",\n" + newIndent + this.cornerString() + ")";
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.fileName.hashCode();
    }
}

