/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javalib.worldimages.RasterImage;
import javalib.worldimages.WorldImage;

public class FreezeImage
extends RasterImage {
    private WorldImage base;

    private FreezeImage(WorldImage base) {
        this.base = base;
    }

    static RasterImage make(WorldImage base) {
        if (base instanceof RasterImage) {
            return (RasterImage)base;
        }
        return new FreezeImage(base);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && ((Object)this.base).equals(((FreezeImage)other).base);
    }

    @Override
    protected void renderIfNecessary() {
        if (this.rendering == null) {
            BufferedImage buffer = new BufferedImage(this.base.getWidth(), this.base.getHeight(), 2);
            Graphics2D bufferG = buffer.createGraphics();
            this.base.draw(bufferG);
            this.setRendering(buffer);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        this.renderIfNecessary();
        super.draw(g);
    }

    @Override
    public int getRight() {
        this.renderIfNecessary();
        return super.getRight();
    }

    @Override
    public int getBottom() {
        this.renderIfNecessary();
        return super.getBottom();
    }
}

