/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import javalib.colors.IColor;
import javalib.worldimages.ColoredImage;
import javalib.worldimages.Mode;
import javalib.worldimages.RectangularImage;

class EllipseImage
extends RectangularImage {
    protected EllipseImage(int width, int height, Color color, Mode mode) {
        super(width, height, color, mode);
    }

    static EllipseImage make(int width, int height, Color color, Mode mode) {
        return new EllipseImage(width, height, color, mode);
    }

    static EllipseImage make(int width, int height, IColor color, Mode mode) {
        return new EllipseImage(width, height, color.thisColor(), mode);
    }

    static EllipseImage make(int width, int height, Mode mode) {
        return new EllipseImage(width, height, Color.black, mode);
    }

    static EllipseImage make(int width, int height, Color color) {
        return new EllipseImage(width, height, color, Mode.OUTLINED);
    }

    static EllipseImage make(int width, int height, IColor color) {
        return new EllipseImage(width, height, color.thisColor(), Mode.OUTLINED);
    }

    static EllipseImage make(int width, int height) {
        return new EllipseImage(width, height, Color.black, Mode.OUTLINED);
    }

    @Override
    RectangularImage replaceDimensions(int width, int height) {
        return new EllipseImage(width, height, this.getColor(), this.getMode());
    }

    @Override
    ColoredImage replaceColor(Color color) {
        return new EllipseImage(this.getWidth(), this.getHeight(), color, this.getMode());
    }

    @Override
    ColoredImage replaceMode(Mode mode) {
        return new EllipseImage(this.getWidth(), this.getHeight(), this.getColor(), mode);
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.getWidth() <= 0) {
            return;
        }
        if (this.getHeight() <= 0) {
            return;
        }
        Paint oldPaint = g.getPaint();
        g.setPaint(this.getColor());
        Ellipse2D.Double shape = new Ellipse2D.Double(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        if (this.getMode() == Mode.FILLED) {
            g.fill(shape);
        } else if (this.getMode() == Mode.OUTLINED) {
            g.draw(shape);
        }
        g.setPaint(oldPaint);
    }

    @Override
    public String toIndentedString(String indent) {
        String newIndent = indent + "  ";
        return "new EllipseImage(this.width = " + this.getWidth() + ", this.height = " + this.getHeight() + ",\n" + newIndent + "this.color = " + this.getColor() + ",\n" + newIndent + this.cornerString() + ")";
    }
}

