/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import javalib.colors.Black;
import javalib.colors.Blue;
import javalib.colors.Green;
import javalib.colors.Red;
import javalib.colors.Yellow;
import javalib.worldimages.AImage;
import javalib.worldimages.ImageBuilder;
import javalib.worldimages.ImageMap;
import javalib.worldimages.Mode;
import javalib.worldimages.PolygonImage;
import javalib.worldimages.Posn;
import javalib.worldimages.RasterImage;
import javalib.worldimages.SampleImages;
import javalib.worldimages.TextImage;
import javalib.worldimages.TextStyle;
import javalib.worldimages.WorldImage;
import junit.framework.TestCase;
import tester.Tester;

public class DrawTest
extends TestCase {
    public static void testEverything() {
        TestCase.assertTrue((boolean)Tester.run((Object)((Object)new DrawTest())));
    }

    public void testOtherStuff(Tester t) {
    }

    public void testPrimitives(Tester t) {
        AImage.makeRectangle(30, 50, new Black(), Mode.FILLED).show();
        AImage.makeRectangle(40, 40, Color.blue, Mode.OUTLINED).show();
        AImage.makeRectangle(50, 20, new Green(), Mode.FILLED).moved(100, 50).show();
        AImage.makeRectangle(80, 60, new Red(), Mode.OUTLINED).moved(50, 100).show();
        AImage.makeEllipse(50, 30, new Yellow(), Mode.FILLED).moved(50, 30).show();
        AImage.makeEllipse(20, 80, new Blue(), Mode.OUTLINED).moved(80, 20).show();
        AImage.makeCircle(30, new Red(), Mode.FILLED).moved(new Posn(50, 30)).show();
        AImage.makeCenteredCircle(new Posn(50, 30), 30, new Blue(), Mode.OUTLINED).show();
        AImage.makeCenteredCircle(new Posn(50, 30), 30, new Green(), Mode.FILLED).show();
        WorldImage tri = AImage.makeTriangle(new Posn(100, 30), new Posn(80, 100), new Posn(120, 110), Color.green, Mode.FILLED);
        tri.show();
        AImage.makeTriangle(new Posn(30, 100), new Posn(100, 80), new Posn(110, 120), Color.blue, Mode.OUTLINED).show();
        PolygonImage pent1 = new PolygonImage(Color.pink, Mode.FILLED, new Posn(100, 20), new Posn(160, 50), new Posn(150, 90), new Posn(50, 90), new Posn(40, 50));
        pent1.show();
        PolygonImage pent2 = new PolygonImage(Color.blue, Mode.OUTLINED, new Posn(100, 20), new Posn(160, 50), new Posn(150, 90), new Posn(50, 90), new Posn(40, 50));
        pent2.show();
        TextImage hello = TextImage.make("hello there", Color.blue);
        hello.show();
        AImage.makeLine(new Posn(100, 15), new Posn(50, 100), new Green()).show();
        SampleImages.greenFish.show();
        SampleImages.pinkFish.moved(200, 250).show();
        SampleImages.shark.moved(350, 400).show();
    }

    public void testOperators(Tester t) {
        WorldImage redDiskOnBlue = AImage.makeRectangle(100, 100, new Blue(), Mode.FILLED).overlay(AImage.makeCenteredCircle(new Posn(50, 50), 30, new Red(), Mode.FILLED));
        redDiskOnBlue.show();
        AImage.makeRectangle(100, 50, new Blue(), Mode.FILLED).moved(50, 0).overlay(AImage.makeEllipse(100, 50, new Red(), Mode.FILLED)).show();
        AImage.makeRectangle(100, 50, new Blue(), Mode.FILLED).moved(50, 0).aboveCentered(AImage.makeEllipse(50, 100, new Red(), Mode.FILLED).moved(400, 100)).show();
        AImage.makeRectangle(100, 300, new Blue(), Mode.FILLED).besideCentered(AImage.makeCircle(50, new Red(), Mode.FILLED).aboveCentered(AImage.makeCircle(100, new Green(), Mode.FILLED))).show();
        TextImage label = TextImage.make("A snowman:", 18.0f, TextStyle.ITALIC, Color.black);
        WorldImage snowman = AImage.makeCircle(10, new Black(), Mode.OUTLINED).aboveCentered(AImage.makeCircle(20, new Black(), Mode.OUTLINED), AImage.makeCircle(30, new Black(), Mode.OUTLINED));
        WorldImage labelledSnowman = label.aboveCentered(snowman);
        labelledSnowman.show();
        snowman.cropped(20, 40, 20, 200).show();
        labelledSnowman.cropped(10, 40, 10, 200).show();
        labelledSnowman.scaled(1.3).show();
        labelledSnowman.scaled(0.5, 0.8).show();
        WorldImage tri = AImage.makeTriangle(new Posn(100, 30), new Posn(80, 100), new Posn(120, 110), Color.green, Mode.FILLED);
        WorldImage labelledTri = AImage.makeText("A green triangle:", 18.0f, TextStyle.ITALIC, Color.blue).aboveCentered(tri);
        labelledTri.show();
        WorldImage croppedTri = labelledTri.cropped(10, 90, 10, 90);
        croppedTri.show();
        WorldImage xTri = labelledTri.xReflected();
        xTri.show();
        WorldImage yTri = labelledTri.yReflected();
        yTri.show();
        WorldImage backwardSnowman = labelledSnowman.xReflected();
        backwardSnowman.show();
        WorldImage invertedSnowman = labelledSnowman.yReflected();
        invertedSnowman.show();
        labelledSnowman.rotated(35).show();
        labelledSnowman.rotated(35).normalized().show();
        labelledSnowman.rotatedInPlace(35).show();
        snowman.rotated(-90).show();
        snowman.rotated(-90).normalized().show();
        snowman.rotatedInPlace(-90).show();
        WorldImage bloch = AImage.makeFromURL("http://picturingprograms.com/pictures/bloch.jpg");
        bloch.show();
        bloch.rotatedInPlace(45).show();
        bloch.xReflected().show();
        bloch.yReflected().show();
        WorldImage twoBlochs = bloch.beside(bloch);
        twoBlochs.show();
        RasterImage threeBlochs = bloch.aboveCentered(twoBlochs).frozen();
        threeBlochs.show();
        System.out.println("Saving threeBlochs: " + threeBlochs.save("threeblochs.png"));
        AImage.makeFromFile("threeblochs.png").yReflected().show();
        AImage.makeRectangle(89, 55, new Blue(), Mode.FILLED).place(SampleImages.shark, 0, 0).show();
        WorldImage gradient1 = AImage.build(100, 100, new ImageBuilder<Posn>(){

            @Override
            public Color pixelColor(int x, int y, Posn dimensions) {
                return new Color(255 * x / dimensions.x, 255 * y / dimensions.y, 0, 255);
            }
        }, new Posn(100, 100));
        gradient1.show();
        ImageMap killRed = new ImageMap(){

            public Color pixelColor(int x, int y, Color oldColor, Object other) {
                return new Color(0, oldColor.getGreen(), oldColor.getBlue(), oldColor.getAlpha());
            }
        };
        bloch.map(killRed).show();
        redDiskOnBlue.map(killRed).show();
        ImageMap<Color> replaceWithWhite = new ImageMap<Color>(){

            @Override
            public Color pixelColor(int x, int y, Color oldColor, Color target) {
                return oldColor.equals(target) ? Color.white : oldColor;
            }
        };
        redDiskOnBlue.map(replaceWithWhite, Color.blue).show();
        redDiskOnBlue.map(replaceWithWhite, Color.red).show();
        redDiskOnBlue.map(replaceWithWhite, Color.yellow).show();
        try {
            redDiskOnBlue.map(replaceWithWhite, new Posn(3, 4)).show();
            t.checkExpect((Object)true, (Object)false, "map (replaceWithWhite, new Posn) should have failed");
        }
        catch (ClassCastException e) {
            System.out.println("Got a ClassCastException, as expected.");
        }
    }
}

