/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Graphics2D;
import java.awt.Shape;
import javalib.worldimages.AImage;
import javalib.worldimages.WorldImage;

public class Crop
extends AImage {
    private WorldImage base;
    private int left;
    private int right;
    private int top;
    private int bottom;

    static WorldImage make(WorldImage base, int left, int right, int top, int bottom) {
        if (left <= base.getLeft() && right >= base.getRight() && top <= base.getTop() && bottom >= base.getBottom()) {
            return base;
        }
        return new Crop(base, left, right, top, bottom);
    }

    Crop(WorldImage base, int left, int right, int top, int bottom) {
        this.base = base;
        this.left = Math.max(base.getLeft(), left);
        this.right = Math.min(base.getRight(), right);
        this.top = Math.max(base.getTop(), top);
        this.bottom = Math.min(base.getBottom(), bottom);
    }

    @Override
    public void draw(Graphics2D g) {
        Shape oldClip = g.getClip();
        g.clipRect(this.left, this.top, this.getWidth(), this.getHeight());
        this.base.draw(g);
        g.setClip(oldClip);
    }

    @Override
    public String toIndentedString(String indent) {
        String newIndent = indent + "  ";
        return "new Crop(this.base = \n" + newIndent + this.base.toIndentedString(newIndent) + ",\n" + newIndent + this.cornerString() + ")";
    }

    @Override
    public int getLeft() {
        return this.left;
    }

    @Override
    public int getTop() {
        return this.top;
    }

    @Override
    public int getRight() {
        return this.right;
    }

    @Override
    public int getBottom() {
        return this.bottom;
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            Crop otherCrop = (Crop)other;
            return ((Object)this.base).equals(otherCrop.base) && this.left == otherCrop.left && this.right == otherCrop.right && this.top == otherCrop.top && this.bottom == otherCrop.bottom;
        }
        return false;
    }
}

