/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import javalib.colors.IColor;
import javalib.worldimages.AImage;
import javalib.worldimages.Mode;

abstract class ColoredImage
extends AImage {
    private Color color;
    private Mode mode;
    public static final Color defaultColor = new Color(0, 0, 0);

    ColoredImage(Color color, Mode mode) {
        this.color = ColoredImage.correctColor(color);
        this.mode = mode;
    }

    ColoredImage(IColor color, Mode mode) {
        this(color.thisColor(), mode);
    }

    ColoredImage(Mode mode) {
        this(defaultColor, mode);
    }

    public Color getColor() {
        return this.color;
    }

    public Mode getMode() {
        return this.mode;
    }

    abstract ColoredImage replaceColor(Color var1);

    ColoredImage replaceColor(IColor newColor) {
        return this.replaceColor(newColor.thisColor());
    }

    abstract ColoredImage replaceMode(Mode var1);

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.getColor().equals(((ColoredImage)other).getColor()) && this.getMode().equals((Object)((ColoredImage)other).getMode());
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.color.hashCode() + this.mode.hashCode();
    }

    private static Color correctColor(Color c) {
        if (c == null) {
            return defaultColor;
        }
        return c;
    }
}

