/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import javalib.colors.IColor;
import javalib.worldimages.ColoredImage;
import javalib.worldimages.EllipseImage;
import javalib.worldimages.Mode;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

class CircleImage
extends EllipseImage {
    private int radius;

    private CircleImage(int radius, Color color, Mode mode) {
        super(2 * radius, 2 * radius, color, mode);
        this.radius = radius;
    }

    static CircleImage make(int radius, Color color, Mode mode) {
        return new CircleImage(radius, color, mode);
    }

    static CircleImage make(int radius, IColor color, Mode mode) {
        return new CircleImage(radius, color.thisColor(), mode);
    }

    static CircleImage make(int radius, Mode mode) {
        return new CircleImage(radius, Color.black, mode);
    }

    static CircleImage make(int radius, Color color) {
        return new CircleImage(radius, color, Mode.OUTLINED);
    }

    static CircleImage make(int radius, IColor color) {
        return new CircleImage(radius, color.thisColor(), Mode.OUTLINED);
    }

    static CircleImage make(int radius) {
        return new CircleImage(radius, Color.black, Mode.OUTLINED);
    }

    static WorldImage makeCentered(Posn center, int radius, Color color, Mode mode) {
        return new CircleImage(radius, color, mode).moved(center.getX() - radius, center.getY() - radius);
    }

    static WorldImage makeCentered(Posn center, int radius, IColor color, Mode mode) {
        return CircleImage.makeCentered(center, radius, color.thisColor(), mode);
    }

    static WorldImage makeCentered(Posn center, int radius, Mode mode) {
        return CircleImage.makeCentered(center, radius, Color.black, mode);
    }

    static WorldImage makeCentered(Posn center, int radius, Color color) {
        return CircleImage.makeCentered(center, radius, color, Mode.OUTLINED);
    }

    static WorldImage makeCentered(Posn center, int radius, IColor color) {
        return CircleImage.makeCentered(center, radius, color.thisColor(), Mode.OUTLINED);
    }

    static WorldImage makeCentered(Posn center, int radius) {
        return CircleImage.makeCentered(center, radius, Color.black, Mode.OUTLINED);
    }

    CircleImage replaceRadius(int newRadius) {
        return new CircleImage(newRadius, this.getColor(), this.getMode());
    }

    @Override
    ColoredImage replaceColor(Color newColor) {
        return new CircleImage(this.getRadius(), newColor, this.getMode());
    }

    @Override
    ColoredImage replaceMode(Mode newMode) {
        return new CircleImage(this.getRadius(), this.getColor(), newMode);
    }

    @Override
    public int getRight() {
        return Math.round(2 * this.radius);
    }

    @Override
    public int getBottom() {
        return Math.round(2 * this.radius);
    }

    public int getRadius() {
        return this.radius;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.radius == ((CircleImage)other).getRadius();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.radius;
    }

    @Override
    public String toIndentedString(String indent) {
        String newIndent = indent + "  ";
        return "new CircleImage(this.radius = " + this.getRadius() + ",\n" + newIndent + "this.color = " + this.getColor() + ",\n" + newIndent + "this.mode = " + (Object)((Object)this.getMode()) + ",\n" + newIndent + this.cornerString() + ")";
    }
}

