/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import javalib.colors.IColor;
import javalib.worldcanvas.WorldCanvas;
import javalib.worldimages.CircleImage;
import javalib.worldimages.Crop;
import javalib.worldimages.EllipseImage;
import javalib.worldimages.FreezeImage;
import javalib.worldimages.FromFileImage;
import javalib.worldimages.FromURLImage;
import javalib.worldimages.ImageBuilder;
import javalib.worldimages.ImageMap;
import javalib.worldimages.LinearImage;
import javalib.worldimages.Mode;
import javalib.worldimages.OverlayImage;
import javalib.worldimages.PolygonImage;
import javalib.worldimages.Posn;
import javalib.worldimages.RasterImage;
import javalib.worldimages.RectangleImage;
import javalib.worldimages.TextImage;
import javalib.worldimages.TextStyle;
import javalib.worldimages.WorldImage;

public abstract class AImage
implements WorldImage {
    private static final double SIN60DEG = Math.sqrt(3.0) / 2.0;

    @Override
    public void show() {
        int height;
        int MINWIDTH = 50;
        int MINHEIGHT = 50;
        int MAXWIDTH = 1000;
        boolean XPAD = true;
        boolean YPAD = true;
        int MAXHEIGHT = 800;
        int width = Math.min(1000, Math.max(50, this.getRight() + 1));
        WorldCanvas c = new WorldCanvas(width, height = Math.min(800, Math.max(50, this.getBottom() + 1)));
        boolean drawn = c.drawImage(this) && c.show();
    }

    @Override
    public Posn getCenter() {
        int x = (this.getRight() + this.getLeft()) / 2;
        int y = (this.getTop() + this.getBottom()) / 2;
        return new Posn(x, y);
    }

    @Override
    public int getWidth() {
        return this.getRight() - this.getLeft();
    }

    @Override
    public int getHeight() {
        return this.getBottom() - this.getTop();
    }

    protected String cornerString() {
        return "left=" + this.getLeft() + ", top=" + this.getTop() + ", right=" + this.getRight() + ", bottom=" + this.getBottom();
    }

    @Override
    public String toString() {
        return this.toIndentedString("");
    }

    @Override
    public WorldImage makeImage() {
        return this;
    }

    public boolean sameClass(Object other) {
        return this.getClass().equals(other.getClass());
    }

    @Override
    public int getTop() {
        return 0;
    }

    @Override
    public int getLeft() {
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClass(other);
    }

    @Override
    public boolean same(WorldImage other) {
        return this.equals(other) || WorldImage.LOOKS_SAME.equivalent((Object)this, (Object)other);
    }

    protected static int rotate(int x, int bits) {
        return x << bits + x >>> 32 - bits;
    }

    public static WorldImage makeRectangle(int width, int height, Color color, Mode mode) {
        return RectangleImage.make(width, height, color, mode);
    }

    public static WorldImage makeRectangle(int width, int height, IColor color, Mode mode) {
        return RectangleImage.make(width, height, color, mode);
    }

    public static WorldImage makeRectangle(int width, int height, Mode mode) {
        return RectangleImage.make(width, height, mode);
    }

    public static WorldImage makeRectangle(int width, int height, Color color) {
        return RectangleImage.make(width, height, color);
    }

    public static WorldImage makeRectangle(int width, int height, IColor color) {
        return RectangleImage.make(width, height, color);
    }

    public static WorldImage makeRectangle(int width, int height) {
        return RectangleImage.make(width, height);
    }

    public static WorldImage makeEllipse(int width, int height, Color color, Mode mode) {
        return EllipseImage.make(width, height, color, mode);
    }

    public static WorldImage makeEllipse(int width, int height, IColor color, Mode mode) {
        return EllipseImage.make(width, height, color, mode);
    }

    public static WorldImage makeEllipse(int width, int height, Mode mode) {
        return EllipseImage.make(width, height, mode);
    }

    public static WorldImage makeEllipse(int width, int height, Color color) {
        return EllipseImage.make(width, height, color);
    }

    public static WorldImage makeEllipse(int width, int height, IColor color) {
        return EllipseImage.make(width, height, color);
    }

    public static WorldImage makeEllipse(int width, int height) {
        return EllipseImage.make(width, height);
    }

    public static WorldImage makeCircle(int radius, Color color, Mode mode) {
        return CircleImage.make(radius, color, mode);
    }

    public static WorldImage makeCircle(int radius, IColor color, Mode mode) {
        return CircleImage.make(radius, color.thisColor(), mode);
    }

    public static WorldImage makeCircle(int radius, Mode mode) {
        return CircleImage.make(radius, Color.black, mode);
    }

    public static WorldImage makeCircle(int radius, Color color) {
        return CircleImage.make(radius, color, Mode.OUTLINED);
    }

    public static WorldImage makeCircle(int radius, IColor color) {
        return CircleImage.make(radius, color.thisColor(), Mode.OUTLINED);
    }

    public static WorldImage makeCircle(int radius) {
        return CircleImage.make(radius, Color.black, Mode.OUTLINED);
    }

    public static WorldImage makeCenteredCircle(Posn center, int radius, Color color, Mode mode) {
        return CircleImage.makeCentered(center, radius, color, mode);
    }

    public static WorldImage makeCenteredCircle(Posn center, int radius, IColor color, Mode mode) {
        return CircleImage.makeCentered(center, radius, color.thisColor(), mode);
    }

    public static WorldImage makeCenteredCircle(Posn center, int radius, Mode mode) {
        return CircleImage.makeCentered(center, radius, Color.black, mode);
    }

    public static WorldImage makeCenteredCircle(Posn center, int radius, Color color) {
        return CircleImage.makeCentered(center, radius, color, Mode.OUTLINED);
    }

    public static WorldImage makeCenteredCircle(Posn center, int radius, IColor color) {
        return CircleImage.makeCentered(center, radius, color.thisColor(), Mode.OUTLINED);
    }

    public static WorldImage makeCenteredCircle(Posn center, int radius) {
        return CircleImage.makeCentered(center, radius, Color.black, Mode.OUTLINED);
    }

    public static WorldImage makeText(String text, float size, TextStyle style, Color color) {
        return TextImage.make(text, size, style, color);
    }

    public static WorldImage makeText(String text, float size, TextStyle style, IColor color) {
        return TextImage.make(text, size, style, color.thisColor());
    }

    public static WorldImage makeText(String text, float size, TextStyle style) {
        return TextImage.make(text, size, style, Color.black);
    }

    public static WorldImage makeText(String text, float size, Color color) {
        return TextImage.make(text, size, TextStyle.REGULAR, color);
    }

    public static WorldImage makeText(String text, float size, IColor color) {
        return TextImage.make(text, size, TextStyle.REGULAR, color.thisColor());
    }

    public static WorldImage makeText(String text, float size) {
        return TextImage.make(text, size, TextStyle.REGULAR, Color.black);
    }

    public static WorldImage makeText(String text, TextStyle style, Color color) {
        return TextImage.make(text, 13.0f, style, color);
    }

    public static WorldImage makeText(String text, TextStyle style, IColor color) {
        return TextImage.make(text, 13.0f, style, color.thisColor());
    }

    public static WorldImage makeText(String text, TextStyle style) {
        return TextImage.make(text, 13.0f, style, Color.black);
    }

    public static WorldImage makeText(String text, Color color) {
        return TextImage.make(text, 13.0f, TextStyle.REGULAR, color);
    }

    public static WorldImage makeText(String text, IColor color) {
        return TextImage.make(text, 13.0f, TextStyle.REGULAR, color.thisColor());
    }

    public static WorldImage makeText(String text) {
        return TextImage.make(text, 13.0f, TextStyle.REGULAR, Color.black);
    }

    public static WorldImage makeTriangle(double side, Color color, Mode mode) {
        int height = (int)Math.round(side * SIN60DEG);
        return AImage.makeTriangle(new Posn((int)Math.round(side / 2.0), 0), new Posn(0, height), new Posn((int)Math.round(side), height), color, mode);
    }

    public static WorldImage makeTriangle(double side, IColor color, Mode mode) {
        return AImage.makeTriangle(side, color.thisColor(), mode);
    }

    public static WorldImage makeTriangle(double side, Mode mode) {
        return AImage.makeTriangle(side, Color.black, mode);
    }

    public static WorldImage makeTriangle(double side, Color color) {
        return AImage.makeTriangle(side, color, Mode.OUTLINED);
    }

    public static WorldImage makeTriangle(double side, IColor color) {
        return AImage.makeTriangle(side, color.thisColor(), Mode.OUTLINED);
    }

    public static WorldImage makeTriangle(double side) {
        return AImage.makeTriangle(side, Color.black, Mode.OUTLINED);
    }

    public static WorldImage makeTriangle(Posn p1, Posn p2, Posn p3, Color color, Mode mode) {
        return new PolygonImage(color, mode, p1, p2, p3);
    }

    public static WorldImage makeTriangle(Posn p1, Posn p2, Posn p3, IColor color, Mode mode) {
        return new PolygonImage(color.thisColor(), mode, p1, p2, p3);
    }

    public static WorldImage makeTriangle(Posn p1, Posn p2, Posn p3, Mode mode) {
        return new PolygonImage(Color.black, mode, p1, p2, p3);
    }

    public static WorldImage makeTriangle(Posn p1, Posn p2, Posn p3, Color color) {
        return new PolygonImage(color, Mode.OUTLINED, p1, p2, p3);
    }

    public static WorldImage makeTriangle(Posn p1, Posn p2, Posn p3, IColor color) {
        return new PolygonImage(color.thisColor(), Mode.OUTLINED, p1, p2, p3);
    }

    public static WorldImage makeTriangle(Posn p1, Posn p2, Posn p3) {
        return new PolygonImage(Color.black, Mode.OUTLINED, p1, p2, p3);
    }

    public static WorldImage makePolygon(Color color, Mode mode, Posn ... points) {
        return PolygonImage.make(color, mode, points);
    }

    public static WorldImage makePolygon(IColor color, Mode mode, Posn ... points) {
        return PolygonImage.make(color, mode, points);
    }

    public static WorldImage makePolygon(Mode mode, Posn ... points) {
        return PolygonImage.make(mode, points);
    }

    public static WorldImage makePolygon(Color color, Posn ... points) {
        return PolygonImage.make(color, points);
    }

    public static WorldImage makePolygon(IColor color, Posn ... points) {
        return PolygonImage.make(color, points);
    }

    public static WorldImage makePolygon(Posn ... points) {
        return PolygonImage.make(points);
    }

    public static WorldImage makeLine(Posn p1, Posn p2, Color color) {
        return new PolygonImage(color, Mode.OUTLINED, p1, p2);
    }

    public static WorldImage makeLine(Posn p1, Posn p2, IColor color) {
        return new PolygonImage(color.thisColor(), Mode.OUTLINED, p1, p2);
    }

    public static WorldImage makeLine(Posn p1, Posn p2) {
        return new PolygonImage(Color.black, Mode.OUTLINED, p1, p2);
    }

    public static WorldImage makeFromFile(String filename) {
        return FromFileImage.make(filename);
    }

    public static WorldImage makeFromURL(String urlString) {
        return FromURLImage.make(urlString);
    }

    @Override
    public WorldImage moved(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return this;
        }
        return LinearImage.make(AffineTransform.getTranslateInstance(dx, dy), this);
    }

    @Override
    public WorldImage moved(Posn dxdy) {
        return this.moved(dxdy.getX(), dxdy.getY());
    }

    @Override
    public WorldImage centerMoved(int x, int y) {
        Posn center = this.getCenter();
        return this.moved(x - center.x, y - center.y);
    }

    @Override
    public WorldImage centerMoved(Posn xy) {
        return this.moved(xy.minus(this.getCenter()));
    }

    @Override
    public WorldImage normalized() {
        return this.moved(-this.getLeft(), -this.getTop());
    }

    private int normalizeDegrees(int degrees) {
        int answer;
        for (answer = degrees; answer < 0; answer += 360) {
        }
        while (answer >= 360) {
            answer -= 360;
        }
        return answer;
    }

    @Override
    public WorldImage rotated(int degrees) {
        if ((degrees = this.normalizeDegrees(degrees)) == 0) {
            return this;
        }
        if (degrees % 90 == 0) {
            return LinearImage.make(AffineTransform.getQuadrantRotateInstance(degrees / 90), this);
        }
        return LinearImage.make(AffineTransform.getRotateInstance(Math.PI * (double)degrees / 180.0), this);
    }

    @Override
    public WorldImage rotated(double degrees) {
        return LinearImage.make(AffineTransform.getRotateInstance(Math.PI * degrees / 180.0), this);
    }

    @Override
    public WorldImage rotatedAround(int degrees, Posn anchor) {
        if ((degrees = this.normalizeDegrees(degrees)) == 0) {
            return this;
        }
        if (degrees % 90 == 0) {
            return LinearImage.make(AffineTransform.getQuadrantRotateInstance(degrees / 90, anchor.x, anchor.y), this);
        }
        return LinearImage.make(AffineTransform.getRotateInstance(Math.PI * (double)degrees / 180.0, anchor.x, anchor.y), this);
    }

    @Override
    public WorldImage rotatedAround(double degrees, Posn anchor) {
        return LinearImage.make(AffineTransform.getRotateInstance(Math.PI * degrees / 180.0, anchor.x, anchor.y), this);
    }

    @Override
    public WorldImage rotatedInPlace(int degrees) {
        return this.rotatedAround(degrees, this.getCenter());
    }

    @Override
    public WorldImage rotatedInPlace(double degrees) {
        return this.rotatedAround(degrees, this.getCenter());
    }

    @Override
    public WorldImage scaled(double factor) {
        return this.scaled(factor, factor);
    }

    @Override
    public WorldImage scaled(double xFactor, double yFactor) {
        return LinearImage.make(AffineTransform.getScaleInstance(xFactor, yFactor), this);
    }

    @Override
    public WorldImage xReflected() {
        int oldLeft = this.getLeft();
        int oldRight = this.getRight();
        return this.scaled(-1.0, 1.0).moved(oldLeft + oldRight, 0);
    }

    @Override
    public WorldImage yReflected() {
        int oldTop = this.getTop();
        int oldBottom = this.getBottom();
        return this.scaled(1.0, -1.0).moved(0, oldTop + oldBottom);
    }

    @Override
    public WorldImage overlay(WorldImage ... others) {
        AImage result = this;
        for (WorldImage other : others) {
            result = OverlayImage.make(result, other);
        }
        return result;
    }

    public static WorldImage overlayImages(WorldImage ... others) {
        WorldImage result = null;
        for (WorldImage other : others) {
            result = result == null ? other : OverlayImage.make(result, other);
        }
        return result;
    }

    @Override
    public WorldImage overlayCentered(WorldImage ... others) {
        int width = this.getWidth();
        int height = this.getHeight();
        for (WorldImage other : others) {
            width = Math.max(width, other.getWidth());
            height = Math.max(height, other.getHeight());
        }
        WorldImage result = this.normalized().moved((width - this.getWidth()) / 2, (height - this.getHeight()) / 2);
        for (WorldImage other : others) {
            result = OverlayImage.make(result, other.normalized().moved((width - other.getWidth()) / 2, (height - other.getHeight()) / 2));
        }
        return result;
    }

    @Override
    public WorldImage overlayXY(WorldImage front, int dx, int dy) {
        return OverlayImage.make(this, front.moved(dx, dy));
    }

    @Override
    public WorldImage place(WorldImage front, int x, int y) {
        int left = this.getLeft();
        int right = this.getRight();
        int top = this.getTop();
        int bottom = this.getBottom();
        int cx = (front.getRight() + front.getLeft()) / 2;
        int cy = (front.getTop() + front.getBottom()) / 2;
        return this.overlayXY(front, x - cx, y - cy).cropped(left, right, top, bottom);
    }

    @Override
    public WorldImage above(WorldImage ... others) {
        AImage result = this;
        for (WorldImage other : others) {
            result = OverlayImage.make(result, other.moved(0, result.getBottom() - other.getTop()));
        }
        return result;
    }

    @Override
    public WorldImage aboveCentered(WorldImage ... others) {
        int width = this.getWidth();
        int height = this.getHeight();
        for (WorldImage other : others) {
            width = Math.max(width, other.getWidth());
            height += other.getHeight();
        }
        WorldImage result = this.normalized().moved((width - this.getWidth()) / 2, 0);
        for (WorldImage other : others) {
            result = OverlayImage.make(result, other.normalized().moved((width - other.getWidth()) / 2, result.getHeight()));
        }
        return result;
    }

    @Override
    public WorldImage beside(WorldImage ... others) {
        AImage result = this;
        for (WorldImage other : others) {
            result = OverlayImage.make(result, other.moved(result.getRight() - other.getLeft(), 0));
        }
        return result;
    }

    @Override
    public WorldImage besideCentered(WorldImage ... others) {
        int width = this.getWidth();
        int height = this.getHeight();
        for (WorldImage other : others) {
            width += other.getWidth();
            height = Math.max(height, other.getHeight());
        }
        WorldImage result = this.normalized().moved(0, (height - this.getHeight()) / 2);
        for (WorldImage other : others) {
            result = OverlayImage.make(result, other.normalized().moved(result.getWidth(), (height - other.getHeight()) / 2));
        }
        return result;
    }

    @Override
    public WorldImage cropped(int left, int right, int top, int bottom) {
        return Crop.make(this, left, right, top, bottom);
    }

    @Override
    public RasterImage frozen() {
        return FreezeImage.make(this);
    }

    @Override
    public boolean save(String filename) {
        return this.frozen().save(filename);
    }

    public static WorldImage build(int width, int height, ImageBuilder builder, Object extra) {
        return RasterImage.build(width, height, builder, extra);
    }

    public static WorldImage build(int width, int height, ImageBuilder builder) {
        return AImage.build(width, height, builder, null);
    }

    @Override
    public WorldImage map(ImageMap map, Object extra) {
        return this.frozen().map(map, extra);
    }

    @Override
    public WorldImage map(ImageMap map) {
        return this.map(map, null);
    }

    @Override
    public Color getPixelColor(int x, int y) {
        return this.frozen().getPixelColor(x, y);
    }

    public static void isApplet(boolean flag) {
        FromFileImage.setIsApplet(flag);
    }
}

