/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldcanvas;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.util.Hashtable;
import javalib.colors.White;
import javalib.worldimages.ImageMaker;
import javalib.worldimages.WorldImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class CanvasPanel
extends JPanel {
    protected transient BufferedImage buffer = null;
    protected transient Painter painter = null;
    protected int WIDTH;
    protected int HEIGHT;

    public CanvasPanel(int width, int height) {
        super(new BorderLayout());
        this.setBufferSize(width, height);
        this.makePainterPanelIfNeeded();
        this.add(this.painter);
        ImageMaker.canvasColorModel = this.buffer.getColorModel();
    }

    private void makePainterPanelIfNeeded() {
        if (this.painter == null) {
            this.painter = new Painter(this);
        }
    }

    public final Graphics2D getBufferGraphics() {
        return this.buffer.createGraphics();
    }

    public synchronized void setBufferSize(int width, int height) {
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        BufferedImage oldBuffer = this.buffer;
        this.buffer = new BufferedImage(width, height, 1);
        this.clearPanel();
        if (oldBuffer != null) {
            Graphics2D g2 = this.getBufferGraphics();
            g2.drawImage((Image)oldBuffer, 0, 0, this);
        }
        Refresh.packParentWindow(this);
    }

    public final synchronized int getBufferWidth() {
        return this.buffer.getWidth();
    }

    public final synchronized int getBufferHeight() {
        return this.buffer.getHeight();
    }

    public final BufferedImage getBuffer() {
        return this.buffer;
    }

    public final JPanel getInnerPanel() {
        this.makePainterPanelIfNeeded();
        return this.painter;
    }

    public final void clearPanel() {
        Graphics2D g2 = this.getBufferGraphics();
        g2.setPaint(new White().thisColor());
        g2.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
    }

    public void drawImage(String fileName, int x, int y) {
        ImageMaker imread = new ImageMaker(fileName);
        Graphics2D g = this.getBufferGraphics();
        ColorConvertOp colorOp = new ColorConvertOp(imread.cmodel.getColorSpace(), this.buffer.getColorModel().getColorSpace(), null);
        g.drawImage(imread.image, colorOp, x, y);
        this.repaint();
    }

    public void drawImage(ImageMaker imread, int x, int y) {
        Graphics2D g = this.getBufferGraphics();
        ColorConvertOp colorOp = new ColorConvertOp(imread.cmodel.getColorSpace(), this.buffer.getColorModel().getColorSpace(), null);
        g.drawImage(imread.image, colorOp, x, y);
        this.repaint();
    }

    public void drawImagePixels(ImageMaker imread, int x, int y) {
        Graphics2D g = this.getBufferGraphics();
        Paint oldPaint = g.getPaint();
        for (int col = 0; col < imread.width; ++col) {
            for (int row = 0; row < imread.height; ++row) {
                Color c = imread.getColorPixel(col, row);
                if (this.isWhite(c)) continue;
                g.setPaint(c);
                g.fillRect(x + col, y + row, 1, 1);
            }
        }
        g.setPaint(oldPaint);
        this.repaint();
    }

    protected boolean isWhite(Color c) {
        return c.getRed() == 255 && c.getBlue() == 255 && c.getGreen() == 255;
    }

    public void drawImage(WorldImage image) {
        Graphics2D g = this.getBufferGraphics();
        image.draw(g);
        this.repaint();
    }

    public void getFonts() {
        Graphics2D g = this.getBufferGraphics();
        Font f = g.getFont();
        System.out.println("Font is: " + f.getName() + " style = " + f.getStyle() + " size = " + f.getSize());
    }

    @Override
    public final void setFocusable(boolean focusable) {
        this.getInnerPanel().setFocusable(focusable);
    }

    @Override
    public final boolean isFocusable() {
        return this.getInnerPanel().isFocusable();
    }

    @Override
    public final boolean isRequestFocusEnabled() {
        return this.getInnerPanel().isRequestFocusEnabled();
    }

    @Override
    public final void requestFocus() {
        this.getInnerPanel().requestFocus();
    }

    @Override
    public final boolean requestFocusInWindow() {
        return this.getInnerPanel().requestFocusInWindow();
    }

    public void paintOver(Graphics2D g2) {
    }

    public static class Refresh {
        private static Hashtable windowHashtable = new Hashtable();

        private Refresh() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void packParentWindow(JComponent component) {
            Container parent;
            if (component == null) {
                return;
            }
            component.revalidate();
            JRootPane pane = component.getRootPane();
            if (pane != null && (parent = pane.getParent()) instanceof Window) {
                Hashtable hashtable = windowHashtable;
                synchronized (hashtable) {
                    Window window = (Window)parent;
                    if (!windowHashtable.containsKey(window)) {
                        windowHashtable.put(window, window);
                        window.setVisible(false);
                        window.pack();
                        window.setVisible(true);
                        windowHashtable.remove(window);
                    }
                }
            }
            component.repaint();
        }
    }

    protected static class Painter
    extends JPanel {
        protected CanvasPanel panel = null;

        protected Painter(CanvasPanel panel) {
            this.panel = panel;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.panel.getBufferWidth(), this.panel.getBufferHeight());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            CanvasPanel canvasPanel = this.panel;
            synchronized (canvasPanel) {
                Insets in = this.getInsets();
                int x = in.left;
                int y = in.top;
                g.drawImage(this.panel.getBuffer(), x, y, this);
                g.translate(x, y);
                g.translate(-x, -y);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            CanvasPanel canvasPanel = this.panel;
            synchronized (canvasPanel) {
                super.paint(g);
                Graphics2D g2 = (Graphics2D)g;
                Insets in = this.getInsets();
                int x = in.left;
                int y = in.top;
                g2.translate(x, y);
                this.panel.paintOver(g2);
                g2.translate(-x, -y);
            }
        }
    }
}

