/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldcanvas;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.util.Hashtable;
import javalib.worldimages.ImageMaker;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class AppletCanvas
extends JPanel {
    protected BufferedImage buffer = null;
    public Painter painter = null;
    protected int WIDTH;
    protected int HEIGHT;
    public static AppletCanvas theCanvas;

    public AppletCanvas(int width, int height) {
        super(true);
        this.setBufferSize(width, height);
        this.painter = new Painter(this);
        this.add(this.painter);
        this.setPreferredSize(new Dimension(width, height));
        this.addNotify();
        this.setVisible(true);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    private void makePainterPanelIfNeeded() {
        if (this.painter == null) {
            this.painter = new Painter(this);
        }
    }

    public final Graphics2D getBufferGraphics() {
        return this.buffer.createGraphics();
    }

    public void setBufferSize(int width, int height) {
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        BufferedImage oldBuffer = this.buffer;
        this.buffer = new BufferedImage(width, height, 1);
        this.clearPanel();
        if (oldBuffer != null) {
            Graphics2D g2 = this.getBufferGraphics();
            g2.drawImage((Image)oldBuffer, 0, 0, this);
        }
    }

    public final int getBufferWidth() {
        return this.buffer.getWidth();
    }

    public final int getBufferHeight() {
        return this.buffer.getHeight();
    }

    public final BufferedImage getBuffer() {
        return this.buffer;
    }

    public final JPanel getInnerPanel() {
        this.makePainterPanelIfNeeded();
        return this.painter;
    }

    public final void clearPanel() {
        Graphics2D g2 = this.getBufferGraphics();
        g2.setPaint(Color.lightGray);
        g2.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
    }

    public final void clear() {
        Graphics2D g2 = this.getBufferGraphics();
        g2.setPaint(Color.lightGray);
        g2.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
    }

    public void drawImage(String fileName, Posn nw) {
        ImageMaker imread = new ImageMaker(fileName);
        Graphics2D g = this.getBufferGraphics();
        ColorConvertOp colorOp = new ColorConvertOp(imread.cmodel.getColorSpace(), this.buffer.getColorModel().getColorSpace(), null);
        g.drawImage(imread.image, colorOp, nw.getX(), nw.getY());
        this.repaint();
    }

    public void drawImage(ImageMaker imread, int x, int y) {
        Graphics2D g = this.getBufferGraphics();
        ColorConvertOp colorOp = new ColorConvertOp(imread.cmodel.getColorSpace(), this.buffer.getColorModel().getColorSpace(), null);
        g.drawImage(imread.image, colorOp, x, y);
        this.repaint();
    }

    protected boolean isWhite(Color c) {
        return c.getRed() == 255 && c.getBlue() == 255 && c.getGreen() == 255;
    }

    public void drawImage(WorldImage image) {
        Graphics2D g = this.getBufferGraphics();
        image.draw(g);
        this.repaint();
    }

    @Override
    public String toString() {
        return "new AppletCanvas(" + this.getBufferWidth() + ", " + this.getBufferHeight() + ")";
    }

    public String toIndentedString(String indent) {
        return "new AppletCanvas(" + this.getBufferWidth() + ", " + this.getBufferHeight() + ")";
    }

    @Override
    public final void setFocusable(boolean focusable) {
        this.getInnerPanel().setFocusable(focusable);
    }

    @Override
    public final boolean isRequestFocusEnabled() {
        return this.getInnerPanel().isRequestFocusEnabled();
    }

    @Override
    public final void requestFocus() {
        this.getInnerPanel().requestFocus();
    }

    @Override
    public final boolean requestFocusInWindow() {
        return this.getInnerPanel().requestFocusInWindow();
    }

    public void paintOver(Graphics2D g2) {
    }

    public static class Refresh {
        private static Hashtable<Window, Window> windowHashtable = new Hashtable();

        private Refresh() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void packParentWindow(JComponent component) {
            Container parent;
            if (component == null) {
                return;
            }
            component.revalidate();
            JRootPane pane = component.getRootPane();
            if (pane != null && (parent = pane.getParent()) instanceof Window) {
                Hashtable<Window, Window> hashtable = windowHashtable;
                synchronized (hashtable) {
                    Window window = (Window)parent;
                    if (!windowHashtable.containsKey(window)) {
                        windowHashtable.put(window, window);
                        window.setVisible(false);
                        window.pack();
                        window.setVisible(true);
                        windowHashtable.remove(window);
                    }
                }
            }
            component.repaint();
        }
    }

    public static class Painter
    extends JPanel {
        protected AppletCanvas panel = null;

        protected Painter(AppletCanvas panel) {
            this.panel = panel;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.panel.getBufferWidth(), this.panel.getBufferHeight());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            AppletCanvas appletCanvas = this.panel;
            synchronized (appletCanvas) {
                Insets in = this.getInsets();
                int x = in.left;
                int y = in.top;
                g.drawImage(this.panel.getBuffer(), x, y, this);
                g.translate(x, y);
                g.translate(-x, -y);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            AppletCanvas appletCanvas = this.panel;
            synchronized (appletCanvas) {
                super.paint(g);
                Graphics2D g2 = (Graphics2D)g;
                Insets in = this.getInsets();
                int x = in.left;
                int y = in.top;
                g2.translate(x, y);
                this.panel.paintOver(g2);
                g2.translate(-x, -y);
            }
        }
    }
}

