/*
 * Decompiled with CFR 0.152.
 */
package javalib.tunes;

public class Note {
    public int pitch;
    public int duration;
    public char noteName;
    public char modifier;
    public int octave;
    public String snote;
    private static int[] noteMap = new int[]{0, 2, 3, 5, 7, 8, 10};
    private static Character[] noteNameMap = new Character[]{Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('f'), Character.valueOf('G'), Character.valueOf('g'), Character.valueOf('A'), Character.valueOf('a'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('c'), Character.valueOf('D'), Character.valueOf('d')};
    private static int charA = Character.getNumericValue('A');

    public Note(int pitch, int duration) {
        this.pitch = this.adjustPitch(pitch);
        this.duration = this.adjustDuration(duration);
        this.initNote(this.pitch, this.duration);
    }

    public Note(int pitch) {
        this.initNote(pitch);
    }

    private int adjustPitch(int pitch) {
        if (pitch < 12) {
            return 0;
        }
        if (pitch > 128) {
            return 128;
        }
        return pitch;
    }

    private int adjustDuration(int duration) {
        if (duration < 0) {
            return 0;
        }
        if (duration > 16) {
            return 16;
        }
        return duration;
    }

    public Note(String snote) {
        this.initNote(snote);
    }

    private void initNote(String snote) {
        this.snote = snote;
        this.noteName = this.adjustNoteName(snote.charAt(0)).charValue();
        this.modifier = this.adjustModifier(snote.charAt(2)).charValue();
        this.octave = this.adjustOctave(Character.digit(snote.charAt(1), 10));
        this.duration = Character.digit(snote.charAt(3), 10);
        if (snote.length() == 5) {
            this.duration = 10 * this.duration + Character.digit(snote.charAt(4), 10);
        }
        this.pitch = this.computePitch(Character.valueOf(this.noteName), this.octave, Character.valueOf(this.modifier));
    }

    private Character adjustNoteName(char noteName) {
        if (noteName == 'A' || noteName == 'B' || noteName == 'C' || noteName == 'D' || noteName == 'E' || noteName == 'F' || noteName == 'G') {
            return Character.valueOf(noteName);
        }
        return Character.valueOf('A');
    }

    private Character adjustModifier(char mod) {
        if (mod == 'n' || mod == 's' || mod == 'f') {
            return Character.valueOf(mod);
        }
        return Character.valueOf('n');
    }

    private int adjustOctave(int oct) {
        if (oct < 0 || oct > 8) {
            return 0;
        }
        return oct;
    }

    public int computePitch(Character noteName, int octave, Character modifier) {
        int base = noteMap[Character.getNumericValue(noteName.charValue()) - charA];
        int note = base + 12 * octave + 9;
        if (modifier.charValue() == 's') {
            return note + 1;
        }
        if (modifier.charValue() == 'f') {
            return note - 1;
        }
        return note;
    }

    void initNote(int pitch, int duration) {
        if (pitch == 0) {
            this.duration = duration;
            this.pitch = pitch;
            this.octave = 0;
            this.noteName = '\u0000';
            this.modifier = (char)110;
            this.snote = "A0n0";
        } else {
            this.duration = duration;
            this.pitch = pitch;
            this.octave = this.pitchToOctave(pitch);
            this.noteName = noteNameMap[(pitch + 8) % 12].charValue();
            if (Character.isLowerCase(this.noteName)) {
                this.modifier = (char)115;
                this.noteName = Character.toUpperCase(this.noteName);
            } else {
                this.modifier = (char)110;
            }
            this.snote = "" + this.noteName + this.octave + this.modifier + this.duration;
        }
    }

    int pitchToOctave(int pitch) {
        if (pitch == 0) {
            return 0;
        }
        return (pitch - 8) / 12;
    }

    void initNote(int pitch) {
        if (pitch == 0) {
            this.initNote(0, 0);
        } else {
            this.initNote(pitch, 1);
        }
    }

    public boolean sameNote(Note that) {
        return this.pitch == that.pitch && this.duration == that.duration;
    }

    public boolean isSilent() {
        return this.duration == 0;
    }

    public void nextBeat() {
        this.duration = this.duration > 0 ? --this.duration : 0;
        this.snote = "" + this.noteName + this.octave + this.modifier + this.duration;
    }

    public void skipBeat() {
        ++this.duration;
        this.snote = "" + this.noteName + this.octave + this.modifier + this.duration;
    }

    public String toString() {
        return this.toIndentedString("");
    }

    public String toIndentedString(String indent) {
        return "new Note(\n" + indent + "this.pitch = " + this.pitch + "," + "\n" + indent + "this.duration = " + this.duration + "," + "\n" + indent + "this.noteName = " + this.noteName + "," + "\n" + indent + "this.modifier = " + this.modifier + "," + "\n" + indent + "this.octave = " + this.octave + "," + "\n" + indent + "this.snote = " + this.snote + ")\n";
    }

    public boolean equals(Object o) {
        if (o instanceof Note) {
            Note that = (Note)o;
            return this.pitch == that.pitch && this.duration == that.duration && this.noteName == that.noteName && this.octave == that.octave;
        }
        return false;
    }

    public int hashCode() {
        return this.pitch * this.duration + this.noteName + this.octave;
    }
}

