/*
 * Decompiled with CFR 0.152.
 */
package javalib.tunes;

import java.lang.reflect.Array;
import java.util.ArrayList;
import javalib.tunes.Chord;
import javalib.tunes.Melody;
import javalib.tunes.Note;
import javalib.tunes.SoundConstants;
import javalib.tunes.Tune;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;

public class MusicBox
implements SoundConstants {
    private Synthesizer synth;
    private MidiChannel[] channels;
    protected int[] program = new int[16];
    public static boolean SYNTH_READY = false;

    public MusicBox() {
        this.initMusic();
        this.initChannels();
    }

    public MusicBox(int[] instruments) {
        this.initMusic();
        this.initChannels(instruments);
    }

    public void initMusic() {
        try {
            this.synth = MidiSystem.getSynthesizer();
            this.synth.open();
            this.synth.loadAllInstruments(this.synth.getDefaultSoundbank());
            this.channels = this.synth.getChannels();
            this.initChannels();
            SYNTH_READY = true;
        }
        catch (MidiUnavailableException e) {
            System.out.println("MidiUnavailableException " + e.getMessage());
        }
        catch (RuntimeException e) {
            System.out.println("Unable to set up MIDI: \n" + e.getMessage());
        }
    }

    public void initChannels() {
        if (SYNTH_READY) {
            for (int i = 0; i < Array.getLength(this.channels); ++i) {
                if (this.channels[i] != null) {
                    this.channels[i].programChange(instruments[i]);
                }
                this.program[i] = instruments[i];
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                this.program[i] = instruments[i];
            }
        }
    }

    public void initChannels(int[] myInstruments) {
        if (SYNTH_READY) {
            for (int i = 0; i < Array.getLength(this.channels); ++i) {
                if (this.channels[i] != null) {
                    this.channels[i].programChange(myInstruments[i]);
                }
                this.program[i] = myInstruments[i];
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                this.program[i] = myInstruments[i];
            }
        }
    }

    public int getProgram(int channel) {
        if (SYNTH_READY && this.channels[channel] != null) {
            return this.channels[channel].getProgram();
        }
        return this.program[channel];
    }

    public void playOn(ArrayList<Tune> tunes) {
        for (Tune tune : tunes) {
            this.playTune(tune);
        }
    }

    public void playTune(Tune tune) {
        for (Note n : tune.chord.notes) {
            if (n.isSilent()) continue;
            if (SYNTH_READY && this.channels[tune.channel] != null) {
                this.channels[tune.channel].noteOn(n.pitch, 60);
            }
            n.nextBeat();
        }
        tune.removeSilent();
    }

    public void playOff(ArrayList<Tune> tunes) {
        for (Tune tune : tunes) {
            this.stopTune(tune);
        }
    }

    public void sleepSome(int miliseconds) {
        long start = System.currentTimeMillis();
        long tmp = System.currentTimeMillis();
        while (tmp - start < (long)miliseconds) {
            tmp = System.currentTimeMillis();
        }
    }

    public void stopTune(Tune tune) {
        for (Note n : tune.chord.notes) {
            if (!SYNTH_READY || this.channels[tune.channel] == null) continue;
            this.channels[tune.channel].noteOff(n.pitch, 60);
        }
    }

    public boolean ready() {
        return SYNTH_READY;
    }

    public boolean same(MusicBox that) {
        for (int i = 0; i < 16; ++i) {
            if (this.program[i] == that.program[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toIndentedString("");
    }

    public String toIndentedString(String indent) {
        String result = "MusicBox: \n";
        for (int i = 0; i < 16; ++i) {
            result = result + indent + instrumentNames[this.program[i]] + "\n";
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof MusicBox)) {
            return false;
        }
        MusicBox that = (MusicBox)o;
        if (this.synth == null) {
            if (that.synth == null) {
                return this.comparePrograms(that);
            }
            return false;
        }
        if (that.synth == null) {
            return false;
        }
        if (SYNTH_READY) {
            for (int i = 0; i < 16; ++i) {
                if (this.channels[i] != null) {
                    if (that.channels[i] == null) {
                        return false;
                    }
                    if (this.channels[i].getProgram() == that.channels[i].getProgram()) continue;
                    return false;
                }
                if (that.channels[i] != null) {
                    return false;
                }
                if (this.program[i] == that.program[i]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                if (this.program[i] == that.program[i]) continue;
                return false;
            }
        }
        return true;
    }

    private boolean comparePrograms(MusicBox that) {
        for (int i = 0; i < 16; ++i) {
            if (this.program[i] == that.program[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.synth.hashCode();
        for (int i = 0; i < 16; ++i) {
            hash += this.program[i];
        }
        return hash;
    }

    public static void main(String[] argv) {
        MusicBox mb = new MusicBox();
        ArrayList<Note> mytune = new Chord((int[])new int[]{0, 0, 0, 0, 60, 0, 0, 0, 62, 0, 0, 0, 64, 0, 0, 0, 60, 0, 0, 0, 60, 0, 0, 0, 62, 0, 0, 0, 64, 0, 0, 0, 60, 0, 0, 0, 64, 0, 0, 0, 65, 0, 0, 0, 67, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 65, 0, 0, 0, 67, 0, 0, 0, 0, 0, 0, 0, 67, 0, 69, 0, 67, 0, 65, 0, 64, 0, 0, 0, 60, 0, 0, 0, 67, 0, 69, 0, 67, 0, 65, 0, 64, 0, 0, 0, 60, 0, 0, 0, 60, 0, 0, 0, 55, 0, 0, 0, 60, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, 55, 0, 0, 0, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}).notes;
        Melody frereMelody = new Melody();
        frereMelody.initMelody(mytune);
        for (int i = 0; i < 300; ++i) {
            Tune t = new Tune(0, frereMelody.next());
            mb.playTune(t);
            mb.sleepSome(80);
            mb.stopTune(t);
        }
    }
}

