/*
 * Decompiled with CFR 0.152.
 */
package javalib.tunes;

import java.util.ArrayList;
import javalib.tunes.Note;

public class Chord {
    public ArrayList<Note> notes = new ArrayList();
    public static Chord noplay = new Chord();

    public Chord() {
    }

    public Chord(String ... snotes) {
        for (String s : snotes) {
            this.addNote(s);
        }
    }

    public Chord(int ... pitches) {
        for (int pitch : pitches) {
            if (pitch == 0) {
                this.addNote(pitch, 0);
                continue;
            }
            this.addNote(pitch, 1);
        }
    }

    public Chord(Note ... notes) {
        for (Note n : notes) {
            this.addNote(n);
        }
    }

    public Chord copy() {
        Chord replica = new Chord();
        for (Note n : this.notes) {
            replica.notes.add(new Note(n.snote));
        }
        return replica;
    }

    public void addNote(Note n) {
        this.notes.add(n);
    }

    public void addNote(String snote) {
        this.notes.add(new Note(snote));
    }

    public void addNote(int pitch, int duration) {
        this.notes.add(new Note(pitch, duration));
    }

    public Chord nextBeat() {
        Chord ch = new Chord();
        for (Note n : this.notes) {
            n.nextBeat();
            if (n.duration > 0) continue;
            ch.addNote(n);
        }
        this.removeSilent();
        return ch;
    }

    public Chord skipBeat() {
        for (Note n : this.notes) {
            n.skipBeat();
        }
        return this;
    }

    public boolean isSilent() {
        for (Note n : this.notes) {
            if (n.duration <= 0) continue;
            return false;
        }
        return true;
    }

    public void removeSilent() {
        ArrayList<Note> currentNotes = new ArrayList<Note>();
        for (Note n : this.notes) {
            if (n.isSilent()) continue;
            currentNotes.add(n);
        }
        this.notes = currentNotes;
    }

    public Chord copyChord() {
        Chord result = new Chord();
        result.notes.clear();
        for (Note n : this.notes) {
            result.addNote(new Note(n.snote));
        }
        return result;
    }

    public int size() {
        return this.notes.size();
    }

    public boolean containsNote(Note n) {
        for (Note note : this.notes) {
            if (!note.sameNote(n)) continue;
            return true;
        }
        return false;
    }

    public boolean containsNote(int pitch) {
        for (Note note : this.notes) {
            if (note.pitch != pitch) continue;
            return true;
        }
        return false;
    }

    public boolean sameChord(Chord that) {
        if (this.notes.size() != that.notes.size()) {
            return false;
        }
        for (Note n : this.notes) {
            if (that.notes.contains(n)) continue;
            return false;
        }
        for (Note n : that.notes) {
            if (this.notes.contains(n)) continue;
            return false;
        }
        return true;
    }

    public String toIndentedString(String indent) {
        String result = "new Chord(";
        for (Note n : this.notes) {
            result = result + "\n" + indent + n.toIndentedString(indent + "  ") + ",";
        }
        result = result.substring(0, result.length() - 2);
        return result + ")";
    }

    public String toString() {
        return this.toIndentedString("");
    }

    public String toSimpleString() {
        String result = "new Chord(";
        for (Note n : this.notes) {
            result = result + n.snote + ", ";
        }
        result = result.substring(0, result.length() - 2);
        return result + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Chord)) {
            return false;
        }
        Chord that = (Chord)o;
        if (this.notes.size() != that.notes.size()) {
            return false;
        }
        ArrayList notesClone = (ArrayList)this.notes.clone();
        for (Note thatNote : that.notes) {
            if (!this.notes.contains(thatNote)) {
                return false;
            }
            if (notesClone.remove(thatNote)) continue;
            return false;
        }
        return notesClone.size() == 0;
    }

    public int hashCode() {
        int hash = 42;
        for (Note thisNote : this.notes) {
            hash += thisNote.hashCode();
        }
        return hash;
    }
}

