/*
 * Decompiled with CFR 0.152.
 */
package javalib.soundworld;

import java.awt.Color;
import java.awt.event.WindowListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import javalib.soundworld.MyKeyAdapter;
import javalib.soundworld.MyMouseAdapter;
import javalib.soundworld.MyTimer;
import javalib.soundworld.MyWindowClosingListener;
import javalib.soundworld.Versions;
import javalib.tunes.MusicBox;
import javalib.tunes.Note;
import javalib.tunes.SoundConstants;
import javalib.tunes.TuneBucket;
import javalib.worldcanvas.WorldCanvas;
import javalib.worldimages.AImage;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldEnd;
import javalib.worldimages.WorldImage;

public abstract class World
implements SoundConstants,
Versions {
    public WorldCanvas theCanvas;
    private volatile boolean worldExists = false;
    protected volatile MyTimer mytime;
    protected volatile boolean stopTimer = false;
    private volatile MyKeyAdapter ka;
    private volatile ArrayList<String> pressedKeys = new ArrayList();
    private volatile MyMouseAdapter ma;
    private volatile WindowListener windowClosing;
    private transient WorldImage blankImage = AImage.makeCircle(1, Color.white);
    public WorldEnd lastWorld = new WorldEnd(false, this.blankImage);
    private volatile MusicBox myMusicBox;
    private transient int[] instruments = new int[16];
    public TuneBucket tickTunes = new TuneBucket();
    protected volatile TuneBucket currentTickTunes = new TuneBucket();
    public TuneBucket keyTunes = new TuneBucket();
    protected volatile TuneBucket currentKeyTunes = new TuneBucket();
    protected volatile HashMap<String, TuneBucket> keyReleasedTunes;

    public World() {
        this.initMusic();
    }

    void initMusic() {
        this.myMusicBox = new MusicBox();
        if (MusicBox.SYNTH_READY) {
            this.tickTunes = new TuneBucket(this.myMusicBox);
            this.currentTickTunes = new TuneBucket(this.myMusicBox);
            this.keyTunes = new TuneBucket(this.myMusicBox);
            this.keyReleasedTunes = new HashMap();
        } else {
            System.out.println("MIDI synthesizer or the soundbank not available.");
            System.out.println("Tunes will not be played.");
            this.tickTunes = new TuneBucket();
            this.currentTickTunes = new TuneBucket();
            this.keyTunes = new TuneBucket();
            this.keyReleasedTunes = new HashMap();
        }
        this.initInstruments();
    }

    public void initInstruments() {
        for (int i = 0; i < 16; ++i) {
            this.instruments[i] = SoundConstants.instruments[i];
        }
    }

    public void programChange(ArrayList<Integer> myInstruments) {
        int i;
        if (myInstruments.size() < 16) {
            for (i = myInstruments.size(); i < 16; ++i) {
                myInstruments.add(1);
            }
        }
        for (i = 0; i < 16; ++i) {
            this.instruments[i] = myInstruments.get(i);
        }
        if (MusicBox.SYNTH_READY) {
            this.myMusicBox.initChannels(this.instruments);
        }
        this.recordProgramChange();
    }

    private void recordProgramChange() {
        this.tickTunes.recordProgramChange(this.instruments);
        this.currentTickTunes.recordProgramChange(this.instruments);
        this.keyTunes.recordProgramChange(this.instruments);
        for (String key : this.keyReleasedTunes.keySet()) {
            this.keyReleasedTunes.get(key).recordProgramChange(this.instruments);
        }
    }

    public void programChange(int[] myInstruments) {
        if (MusicBox.SYNTH_READY) {
            int i;
            int[] okInstruments = new int[16];
            for (i = 0; i < Math.min(16, Array.getLength(myInstruments)); ++i) {
                okInstruments[i] = myInstruments[i];
            }
            if (Array.getLength(myInstruments) < 16) {
                for (i = Array.getLength(myInstruments); i < 16; ++i) {
                    okInstruments[i] = 1;
                }
            }
            this.myMusicBox.initChannels(okInstruments);
        }
    }

    void sleepSome(int miliseconds) {
        long start = System.currentTimeMillis();
        long tmp = System.currentTimeMillis();
        while (tmp - start < (long)miliseconds) {
            tmp = System.currentTimeMillis();
        }
    }

    public void bigBang(int w, int h, double speed) {
        if (this.worldExists) {
            System.out.println("Only one world can run at a time");
            return;
        }
        this.theCanvas = new WorldCanvas(w, h);
        this.worldExists = true;
        this.theCanvas.f.setDefaultCloseOperation(2);
        this.windowClosing = new MyWindowClosingListener(this);
        this.theCanvas.f.addWindowListener(this.windowClosing);
        this.initMusic();
        this.pressedKeys = new ArrayList();
        this.sleepSome(100);
        this.ka = new MyKeyAdapter(this);
        this.theCanvas.f.addKeyListener(this.ka);
        this.ma = new MyMouseAdapter(this);
        this.theCanvas.f.addMouseListener(this.ma);
        this.theCanvas.f.setFocusable(true);
        this.theCanvas.show();
        this.sleepSome(100);
        this.mytime = new MyTimer(this, speed);
        this.drawWorld("");
        if (speed > 0.0) {
            this.mytime.timer.start();
        }
        System.out.println("soundworld version 1.02 --- 21 August 2012\n-----------------------------------------\n");
    }

    protected void stopWorld() {
        if (this.worldExists) {
            this.mytime.timer.stop();
            this.worldExists = false;
            this.mytime.stopTimer();
            this.theCanvas.f.removeKeyListener(this.ka);
            this.theCanvas.f.removeMouseListener(this.ma);
            this.theCanvas.clear();
            this.theCanvas.drawImage(this.lastWorld.lastImage);
        }
        if (MusicBox.SYNTH_READY) {
            this.currentTickTunes.add(this.tickTunes);
            this.tickTunes.playTunes();
            this.sleepSome(1000);
        }
        this.tickTunes.clearBucket();
        this.currentTickTunes.clearBucket();
        this.keyTunes.clearBucket();
        for (String ke : this.keyReleasedTunes.keySet()) {
            this.keyReleasedTunes.get(ke).clearBucket();
        }
        System.out.println("The world stopped.");
    }

    public WorldEnd worldEnds() {
        return this.lastWorld;
    }

    public void endOfWorld(String s) {
        this.lastWorld = new WorldEnd(true, this.lastImage(s));
        this.stopWorld();
    }

    public void testOnTick() {
        this.lastWorld = this.worldEnds();
        if (this.lastWorld.worldEnds) {
            this.stopWorld();
        }
        this.processTick();
    }

    protected void processTick() {
        try {
            if (this.worldExists && !this.stopTimer) {
                this.lastWorld = this.worldEnds();
                if (this.lastWorld.worldEnds) {
                    this.stopWorld();
                }
            }
            this.currentTickTunes.nextBeat();
            this.onTick();
            this.currentTickTunes.add(this.tickTunes);
            this.tickTunes.playTunes();
            this.tickTunes.clearTunes();
            if (this.worldExists) {
                this.drawWorld("");
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.lastWorld.lastImage = this.lastWorld.lastImage.place(AImage.makeText(re.getMessage(), Color.red), 40, 40);
            this.stopWorld();
            Runtime.getRuntime().halt(1);
        }
    }

    public abstract void onTick();

    public TuneBucket nowPlaying() {
        return this.currentTickTunes;
    }

    public int[] getProgram() {
        return this.instruments;
    }

    ArrayList<Integer> getCurrentProgram() {
        ArrayList<Integer> program = new ArrayList<Integer>();
        for (int i = 0; i < 16; ++i) {
            program.add(this.instruments[i]);
        }
        return program;
    }

    protected void processKeyEvent(String ke) {
        try {
            if (this.worldExists && !this.pressedKeys.contains(ke)) {
                this.pressedKeys.add(ke);
                this.keyTunes.clearTunes();
                if (this.worldExists) {
                    this.onKeyEvent(ke);
                    this.keyReleasedTunes.put(ke, this.keyTunes.copy());
                    this.keyTunes.playTunes();
                    if (!this.lastWorld.worldEnds) {
                        this.drawWorld("");
                    } else {
                        this.stopWorld();
                    }
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.lastWorld.lastImage = this.lastWorld.lastImage.place(AImage.makeText(re.getMessage(), Color.red), 40, 40);
            this.stopWorld();
            Runtime.getRuntime().halt(1);
        }
    }

    void processKeyReleasedEvent(String ke) {
        TuneBucket tmp = this.keyReleasedTunes.remove(ke);
        this.pressedKeys.remove(ke);
        if (tmp != null && !this.isPlaying(tmp)) {
            tmp.clearBucket();
        }
        this.onKeyReleased(ke);
    }

    public boolean isPlaying(TuneBucket tuneBucket) {
        return this.keyReleasedTunes.containsValue(tuneBucket);
    }

    public void onKeyReleased(String ke) {
    }

    public abstract void onKeyEvent(String var1);

    public void testOnKey(String ke) {
        if (!this.pressedKeys.contains(ke)) {
            this.lastWorld = this.worldEnds();
            if (this.lastWorld.worldEnds) {
                this.stopWorld();
            }
            this.pressedKeys.add(ke);
            this.keyTunes.clearTunes();
            this.onKeyEvent(ke);
            if (this.keyTunes.bucketSize() > 0) {
                this.keyReleasedTunes.put(ke, this.keyTunes.copy());
                this.currentKeyTunes.add(this.keyTunes);
                this.keyTunes.playTunes();
            }
            if (this.worldExists) {
                this.drawWorld("");
            }
        }
    }

    public void testOffKey(String ke) {
        TuneBucket tmp = this.keyReleasedTunes.remove(ke);
        this.pressedKeys.remove(ke);
        if (tmp != null) {
            for (int i = 0; i < 16; ++i) {
                ArrayList<Note> notes = tmp.tunes.get((int)i).getChord().notes;
                for (Note n : notes) {
                    this.currentKeyTunes.tunes.get((int)i).getChord().notes.remove(n);
                }
            }
            tmp.clearBucket();
        }
        this.onKeyReleased(ke);
    }

    public TuneBucket nowPlayingOnKeyPress() {
        return this.currentKeyTunes;
    }

    protected void processMouseClicked(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMouseClicked(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.lastWorld.lastImage = this.lastWorld.lastImage.place(AImage.makeText(re.getMessage(), Color.red), 40, 40);
            this.stopWorld();
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMouseClicked(Posn mouse) {
    }

    protected void processMouseEntered(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMouseEntered(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.lastWorld.lastImage = this.lastWorld.lastImage.place(AImage.makeText(re.getMessage(), Color.red), 40, 40);
            this.stopWorld();
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMouseEntered(Posn mouse) {
    }

    protected void processMouseExited(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMouseExited(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.lastWorld.lastImage = this.lastWorld.lastImage.place(AImage.makeText(re.getMessage(), Color.red), 40, 40);
            this.stopWorld();
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMouseExited(Posn mouse) {
    }

    protected void processMousePressed(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMousePressed(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.lastWorld.lastImage = this.lastWorld.lastImage.place(AImage.makeText(re.getMessage(), Color.red), 40, 40);
            this.stopWorld();
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMousePressed(Posn mouse) {
    }

    protected void processMouseReleased(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMouseReleased(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.lastWorld.lastImage = this.lastWorld.lastImage.place(AImage.makeText(re.getMessage(), Color.red), 40, 40);
            this.stopWorld();
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMouseReleased(Posn mouse) {
    }

    protected synchronized void drawWorld(String s) {
        if (this.worldExists) {
            this.theCanvas.clear();
            this.theCanvas.drawImage(this.makeImage());
        } else {
            this.theCanvas.clear();
            this.theCanvas.drawImage(this.lastImage(s));
        }
    }

    public abstract WorldImage makeImage();

    public WorldImage lastImage(String s) {
        return this.makeImage();
    }
}

