/*
 * Decompiled with CFR 0.152.
 */
package javalib.funworld;

import java.awt.Color;
import java.awt.event.WindowListener;
import javalib.funworld.MyKeyAdapter;
import javalib.funworld.MyMouseAdapter;
import javalib.funworld.MyTimer;
import javalib.funworld.MyWindowClosingListener;
import javalib.funworld.UserWorld;
import javalib.worldcanvas.WorldCanvas;
import javalib.worldimages.AImage;
import javalib.worldimages.Drawable;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldEnd;
import javalib.worldimages.WorldImage;

public abstract class World
implements UserWorld,
Drawable {
    public WorldCanvas theCanvas;
    private transient boolean worldExists = false;
    private transient int tickCount = 0;
    private transient long startTime;
    protected transient MyTimer mytime;
    protected transient boolean stopTimer = false;
    private transient MyKeyAdapter ka;
    private transient MyMouseAdapter ma;
    private transient WindowListener windowClosing;
    private transient WorldImage blankImage = AImage.makeCircle(1, Color.white);
    public WorldEnd lastWorld = new WorldEnd(false, this.blankImage);

    public boolean bigBang(int w, int h, double speed) {
        if (this.worldExists) {
            System.out.println("Only one world can run at a time");
            return true;
        }
        this.theCanvas = new WorldCanvas(w, h);
        this.theCanvas.f.setDefaultCloseOperation(2);
        this.windowClosing = new MyWindowClosingListener(this);
        this.theCanvas.f.addWindowListener(this.windowClosing);
        long start = System.currentTimeMillis();
        long tmp = System.currentTimeMillis();
        while (tmp - start < 1000L) {
            tmp = System.currentTimeMillis();
        }
        this.ka = new MyKeyAdapter(this);
        this.theCanvas.f.addKeyListener(this.ka);
        this.ma = new MyMouseAdapter(this);
        this.theCanvas.f.addMouseListener(this.ma);
        this.theCanvas.f.addMouseMotionListener(this.ma);
        this.theCanvas.f.setFocusable(true);
        this.theCanvas.show();
        this.drawWorld(" ");
        start = System.currentTimeMillis();
        tmp = System.currentTimeMillis();
        while (tmp - start < 1000L) {
            tmp = System.currentTimeMillis();
        }
        this.startTime = System.currentTimeMillis();
        this.mytime = new MyTimer(this, speed);
        if (speed > 0.0) {
            this.mytime.timer.start();
        }
        this.worldExists = true;
        System.out.println("funworld version 1.0 --- 26 June  2012\n-----------------------------------------\n");
        return this.drawWorld("");
    }

    public boolean bigBang(int w, int h) {
        return this.bigBang(w, h, 0.0);
    }

    public boolean bigBang(double speed) {
        WorldImage firstImage = this.makeImage();
        return this.bigBang(firstImage.getWidth(), firstImage.getHeight(), speed);
    }

    public boolean bigBang() {
        return this.bigBang(0.0);
    }

    protected void stopWorld() {
        if (this.worldExists) {
            this.mytime.timer.stop();
            this.worldExists = false;
            this.mytime.stopTimer();
            this.theCanvas.f.removeKeyListener(this.ka);
            this.theCanvas.f.removeMouseListener(this.ma);
            System.out.println("The world stopped.");
            this.theCanvas.clear();
            this.theCanvas.drawImage(this.lastWorld.lastImage);
        }
    }

    public WorldEnd worldEnds() {
        return new WorldEnd(false, this.makeImage());
    }

    public World endOfWorld(String s) {
        this.lastWorld = new WorldEnd(true, this.lastImage(s));
        this.stopWorld();
        return this;
    }

    public World testOnTick() {
        this.lastWorld = this.worldEnds();
        if (this.lastWorld.worldEnds) {
            this.stopWorld();
        }
        return this.processTick();
    }

    protected synchronized World processTick() {
        ++this.tickCount;
        try {
            if (this.worldExists && !this.stopTimer) {
                this.lastWorld = this.worldEnds();
                if (!this.lastWorld.worldEnds) {
                    World bw = this.onTick();
                    return this.resetWorld(bw);
                }
            } else {
                return this;
            }
            this.stopWorld();
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
        return this;
    }

    @Override
    public World onTick() {
        return this;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public double getElapsedTime() {
        long ms = System.currentTimeMillis() - this.startTime;
        return (double)ms / 1000.0;
    }

    protected synchronized World processKeyEvent(String ke) {
        try {
            if (this.worldExists) {
                World bw = this.onKeyEvent(ke);
                if (!this.lastWorld.worldEnds) {
                    return this.resetWorld(bw);
                }
                return this;
            }
            return this;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
            return this;
        }
    }

    @Override
    public World onKeyEvent(String s) {
        return this;
    }

    protected World processMouseClicked(Posn mouse) {
        try {
            if (this.worldExists) {
                World bw = this.onMouseClicked(mouse);
                if (!this.lastWorld.worldEnds) {
                    return this.resetWorld(bw);
                }
                return this;
            }
            return this;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
            return this;
        }
    }

    protected World processMouseMoved(Posn mouse) {
        try {
            if (this.worldExists) {
                World bw = this.onMouseMoved(mouse);
                if (!this.lastWorld.worldEnds) {
                    return this.resetWorld(bw);
                }
                return this;
            }
            return this;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
            return this;
        }
    }

    protected World processMouseDragged(Posn mouse) {
        try {
            if (this.worldExists) {
                World bw = this.onMouseDragged(mouse);
                if (!this.lastWorld.worldEnds) {
                    return this.resetWorld(bw);
                }
                return this;
            }
            return this;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
            return this;
        }
    }

    @Override
    public World onMouseClicked(Posn mouse) {
        return this;
    }

    @Override
    public World onMouseMoved(Posn mouse) {
        return this;
    }

    @Override
    public World onMouseDragged(Posn mouse) {
        return this;
    }

    protected World processMouseEntered(Posn mouse) {
        try {
            if (this.worldExists) {
                World bw = this.onMouseEntered(mouse);
                if (!this.lastWorld.worldEnds) {
                    return this.resetWorld(bw);
                }
                return this;
            }
            return this;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
            return this;
        }
    }

    @Override
    public World onMouseEntered(Posn mouse) {
        return this;
    }

    protected World processMouseExited(Posn mouse) {
        try {
            if (this.worldExists) {
                World bw = this.onMouseExited(mouse);
                if (!this.lastWorld.worldEnds) {
                    return this.resetWorld(bw);
                }
                return this;
            }
            return this;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
            return this;
        }
    }

    @Override
    public World onMouseExited(Posn mouse) {
        return this;
    }

    protected World processMousePressed(Posn mouse) {
        try {
            if (this.worldExists) {
                World bw = this.onMousePressed(mouse);
                if (!this.lastWorld.worldEnds) {
                    return this.resetWorld(bw);
                }
                return this;
            }
            return this;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
            return this;
        }
    }

    @Override
    public World onMousePressed(Posn mouse) {
        return this;
    }

    protected World processMouseReleased(Posn mouse) {
        try {
            if (this.worldExists) {
                World bw = this.onMouseReleased(mouse);
                if (!this.lastWorld.worldEnds) {
                    return this.resetWorld(bw);
                }
                return this;
            }
            return this;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
            return this;
        }
    }

    @Override
    public World onMouseReleased(Posn mouse) {
        return this;
    }

    private synchronized World resetWorld(World bw) {
        if (this.worldExists) {
            bw.theCanvas = this.theCanvas;
            bw.worldExists = true;
            bw.ka = this.ka;
            bw.ma = this.ma;
            bw.windowClosing = this.windowClosing;
            bw.ka.currentWorld = bw;
            bw.ma.currentWorld = bw;
            bw.mytime = this.mytime;
            bw.mytime.setSpeed();
            bw.mytime.currentWorld = bw;
            bw.drawWorld("");
            return bw;
        }
        this.theCanvas.clear();
        this.drawWorld("");
        return this;
    }

    protected synchronized boolean drawWorld(String s) {
        if (this.worldExists) {
            this.theCanvas.clear();
            this.theCanvas.drawImage(this.makeImage());
            return true;
        }
        this.theCanvas.clear();
        this.theCanvas.drawImage(this.lastImage(s));
        return true;
    }

    public int getWidth() {
        return this.theCanvas.getWidth();
    }

    public int getHeight() {
        return this.theCanvas.getHeight();
    }

    public int getCurrentWidth() {
        return this.theCanvas.getCurrentWidth();
    }

    public int getCurrentHeight() {
        return this.theCanvas.getCurrentHeight();
    }

    @Override
    public abstract WorldImage makeImage();

    @Override
    public WorldImage lastImage(String s) {
        return this.makeImage();
    }
}

