/*
 * Decompiled with CFR 0.152.
 */
package javalib.funworld;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javalib.funworld.World;

class MyKeyAdapter
extends KeyAdapter {
    protected World currentWorld;

    protected MyKeyAdapter(World currentWorld) {
        this.currentWorld = currentWorld;
    }

    protected void keyEventCallback(String keyString) {
        this.currentWorld.processKeyEvent(keyString);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.displayInfo(e, "KEY TYPED: ");
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.displayInfo(e, "KEY PRESSED: ");
    }

    protected void displayInfo(KeyEvent e, String s) {
        String keyString = "ignore";
        int id = e.getID();
        if (id == 400) {
            char c = e.getKeyChar();
            char code = c;
            keyString = code == '\b' ? "backspace" : (code == '\t' ? "tab" : (code == '\n' ? "newline" : (code == '\u007f' ? "delete" : "" + c)));
            System.err.println("Got KEY_TYPED event with char " + c);
        } else if (id == 401) {
            int keyCode = e.getKeyCode();
            System.err.println("Got KEY_PRESSED event with code " + keyCode);
            keyString = keyCode == 27 ? "escape" : (keyCode == 33 ? "page up" : (keyCode == 34 ? "page down" : (keyCode == 35 ? "end" : (keyCode == 36 ? "home" : (keyCode == 37 ? "left" : (keyCode == 38 ? "up" : (keyCode == 39 ? "right" : (keyCode == 40 ? "down" : (keyCode >= 112 && keyCode <= 123 ? "f" + (keyCode - 111) : "ignore")))))))));
        } else if (id == 402) {
            keyString = "released";
            System.err.println("Got key-released event");
        }
        System.err.println("keyString is \"" + keyString + "\"");
        if (!keyString.equals("ignore") && !keyString.equals("released")) {
            this.keyEventCallback(keyString);
        }
    }
}

