/*
 * Decompiled with CFR 0.152.
 */
package javalib.appletsoundworld;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javalib.appletsoundworld.World;
import javalib.worldcanvas.AppletCanvas;
import javalib.worldimages.AImage;
import javalib.worldimages.Mode;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;

public abstract class WorldApplet
extends JApplet {
    protected JSlider speedSlider = new JSlider();
    protected JPanel appletPanel = new JPanel();
    protected static String CLEAR = "CLEAR";
    protected static String RUNNING = "STOP ";
    protected static String READY = "START";
    protected String currentState = READY;
    protected static double SPEED_FACTOR = 1.0;
    protected JButton bigButton = new JButton(READY);
    protected ActionListener bba = new BigBangAction();
    protected JPanel controls = new JPanel();
    protected int WIDTH = 200;
    protected int HEIGHT = 200;
    protected double SPEED = 0.1;
    protected AppletCanvas theCanvas;
    protected AppletCanvas.Painter painter;
    protected boolean setApplet = this.isApplet();
    protected World currentworld = this.getNewWorld();
    protected boolean stopped = false;

    protected boolean isApplet() {
        AImage.isApplet(true);
        return true;
    }

    public abstract World getNewWorld();

    public abstract void setWorldSize();

    public double setSpeedFactor() {
        return 1.0;
    }

    protected void initWH() {
        this.setWorldSize();
        if (this.WIDTH < 200) {
            this.WIDTH = 200;
        }
        if (this.HEIGHT < 200) {
            this.HEIGHT = 200;
        }
    }

    protected void initSpeed() {
        SPEED_FACTOR = this.setSpeedFactor();
    }

    protected double getSpeed() {
        int n = this.speedSlider.getValue();
        return Double.valueOf("" + (101 - n)) / 100.0 / SPEED_FACTOR;
    }

    protected void setSpeed(double d) {
        int n = Long.valueOf(Math.round(101.0 - d * SPEED_FACTOR * 100.0)).intValue();
        this.speedSlider.setValue(n);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void init() {
        if (this.isApplet()) {
            this.initWH();
        }
        this.setLayout(new BorderLayout(1, 2));
        this.setBackground(Color.white);
        this.setSize(this.WIDTH, this.HEIGHT + 30);
        this.initSpeed();
        this.speedSlider.setPreferredSize(new Dimension(100, 30));
        this.bigButton.setPreferredSize(new Dimension(this.WIDTH - 100, 30));
        this.controls.setLayout(new BorderLayout());
        this.controls.setBackground(Color.darkGray);
        this.controls.add("West", this.bigButton);
        this.controls.add("East", this.speedSlider);
        this.controls.validate();
        this.appletPanel.setLayout(new BorderLayout());
        this.appletPanel.setBackground(Color.lightGray);
        this.theCanvas = new AppletCanvas(this.WIDTH, this.HEIGHT);
        this.theCanvas.painter.setSize(this.WIDTH, this.HEIGHT);
        this.theCanvas.painter.setMaximumSize(new Dimension(this.WIDTH, this.HEIGHT));
        this.theCanvas.clearPanel();
        this.theCanvas.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        this.appletPanel.add("Center", this.theCanvas);
        this.appletPanel.add("South", this.controls);
        this.appletPanel.setSize(this.WIDTH, this.HEIGHT + 30);
        this.appletPanel.addNotify();
        this.add(this.appletPanel);
        this.bigButton.addActionListener(this.bba);
        this.stopped = false;
        this.currentworld = this.getNewWorld();
        this.currentworld.initWorld(this.theCanvas, this.bigButton);
        this.redraw();
    }

    protected void signalEnd() {
        this.currentState = CLEAR;
        this.bigButton.setText(CLEAR);
    }

    protected void bbstart() {
        this.SPEED = this.getSpeed();
        this.bigButton.setText(this.currentState);
        this.currentworld.initWorld(this.theCanvas, this.bigButton);
        this.currentworld.bigBang(this.WIDTH, this.HEIGHT, this.SPEED);
        this.theCanvas.addNotify();
        this.theCanvas.requestFocusInWindow();
    }

    @Override
    public void start() {
        this.stopped = false;
        this.currentworld.worldStopped = false;
    }

    @Override
    public void stop() {
        if (this.currentworld.worldExists) {
            this.theCanvas.drawImage(AImage.makeText("World stopped when not visible", Color.black));
            this.currentworld.endOfWorld("Stop button stopped the world");
            this.currentState = CLEAR;
            this.bigButton.setText(CLEAR);
        }
        this.stopped = true;
    }

    protected void redraw() {
        Color back = Color.darkGray;
        this.theCanvas.drawImage(AImage.makeRectangle(this.WIDTH, this.HEIGHT, back, Mode.FILLED));
    }

    public void paint() {
    }

    public class BigBangAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            WorldApplet.this.currentState = WorldApplet.this.bigButton.getText();
            if (!WorldApplet.this.stopped) {
                if (WorldApplet.this.currentState.equals(READY)) {
                    WorldApplet.this.currentworld = WorldApplet.this.getNewWorld();
                    WorldApplet.this.currentworld.initWorld(WorldApplet.this.theCanvas, WorldApplet.this.bigButton);
                    WorldApplet.this.currentState = RUNNING;
                    WorldApplet.this.bigButton.setText(RUNNING);
                    WorldApplet.this.bbstart();
                } else if (WorldApplet.this.currentState.equals(RUNNING)) {
                    if (WorldApplet.this.currentworld.worldExists) {
                        WorldApplet.this.currentworld.endOfWorld("STOP button ended the world");
                    }
                    WorldApplet.this.currentState = CLEAR;
                    WorldApplet.this.bigButton.setText(CLEAR);
                } else if (WorldApplet.this.currentState.equals(CLEAR)) {
                    WorldApplet.this.redraw();
                    WorldApplet.this.currentState = READY;
                    WorldApplet.this.bigButton.setText(READY);
                }
            }
        }
    }
}

