/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tester.Equivalence;
import tester.ErrorReport;
import tester.IExamples;
import tester.Inspector;
import tester.Printer;
import tester.Reflector;
import tester.TestMethod;
import tester.Traversal;

public class Tester {
    private static String version;
    protected StringBuilder failedResults = new StringBuilder("Failed test results: \n--------------\n");
    protected StringBuilder fullTestResults = new StringBuilder("Full test results: \n-------------------\n");
    protected int numberOfTests;
    protected int errors;
    protected int warnings;
    protected String testname;
    protected Inspector inspector = new Inspector();

    public Tester() {
        Inspector.TOLERANCE = 0.001;
        this.numberOfTests = 0;
        this.errors = 0;
        this.warnings = 0;
        this.testname = "";
    }

    protected void runAnyTests(Object f) {
        this.runAnyTests(f, false);
    }

    protected void runAnyTests(Object f, boolean full) {
        this.runAnyTests(f, full, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAnyTests(Object f, boolean full, boolean printall) {
        this.numberOfTests = 0;
        boolean failed = false;
        System.out.println(version);
        System.out.println("Tests defined in the class: " + f.getClass().getName() + ":\n---------------------------");
        if (printall) {
            System.out.println(f.getClass().getName() + ":\n---------------");
            System.out.println(Printer.produceString(f) + "\n---------------");
        }
        Class<?>[] interfaces = f.getClass().getInterfaces();
        boolean foundInterface = false;
        for (Class<?> c : interfaces) {
            if (!c.getName().equals("tester.IExamples")) continue;
            this.runTests((IExamples)f, full, printall);
            foundInterface = true;
        }
        if (!foundInterface) {
            ArrayList<Method> testMethods = this.findTestMethods(f, "Your class does not define any method with the header\n boolean test...(Tester t)");
            if (testMethods != null) {
                Object[] args = new Object[]{this};
                try {
                    for (Method testMethod : testMethods) {
                        if (testMethod == null) continue;
                        testMethod.invoke(f, args);
                    }
                }
                catch (Throwable e) {
                    ++this.errors;
                    ++this.numberOfTests;
                    System.out.println("Threw exception during test " + this.numberOfTests);
                    e.printStackTrace();
                    failed = true;
                }
                finally {
                    if (full) {
                        this.fullTestReport();
                    } else {
                        this.testReport();
                    }
                    this.done(failed);
                }
            } else {
                System.out.println("No test methods found.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTests(IExamples f, boolean full, boolean printall) {
        this.numberOfTests = 0;
        boolean failed = false;
        if (printall) {
            System.out.println("Examples class:\n---------------");
            System.out.println(Printer.produceString(f) + "\n---------------");
        }
        try {
            f.tests(this);
        }
        catch (Throwable e) {
            ++this.errors;
            ++this.numberOfTests;
            System.out.println("Threw exception during test " + this.numberOfTests);
            e.printStackTrace();
            failed = true;
        }
        finally {
            if (full) {
                this.fullTestReport();
            } else {
                this.testReport();
            }
            this.done(failed);
        }
    }

    protected void done(boolean failed) {
        if (failed) {
            this.reportErrors(this.testname, "caused RuntimeException");
            System.runFinalization();
        }
    }

    protected boolean setTolerance(double epsilon) {
        Inspector.TOLERANCE = epsilon;
        return epsilon > 0.0;
    }

    public boolean same(Object obj1, Object obj2) {
        return this.inspector.isSame(obj1, obj2);
    }

    public boolean success() {
        return this.success("");
    }

    public boolean success(String testname) {
        return this.checkExpect(true, testname);
    }

    public boolean fail() {
        return this.fail("");
    }

    public boolean fail(String testname) {
        return this.checkExpect(false, testname);
    }

    public boolean checkExpect(boolean result) {
        return this.checkExpect(result, "");
    }

    public boolean checkExpect(boolean result, String testname) {
        this.testname = testname;
        if (!result) {
            return this.reportErrors(testname, ": error -- no blame -- \n");
        }
        return this.reportSuccess(testname, ": success \n");
    }

    public boolean checkFail(boolean result) {
        return this.checkFail(result, "");
    }

    public boolean checkFail(boolean result, String testname) {
        return this.checkExpect(!result, "Failure expected: \n" + testname);
    }

    public <T> boolean checkExpect(T actual, T expected) {
        return this.checkExpect(actual, expected, "");
    }

    public <T> boolean checkExpect(T actual, T expected, String testname) {
        this.testname = testname;
        return this.report(this.inspector.exactTest() && this.inspector.isSame(actual, expected) && !this.inspector.inexactViolation(), testname, "actual:                                 expected:\n" + Printer.combineActualExpected(Printer.produceString(actual), Printer.produceString(expected)) + "\n");
    }

    public <T> boolean checkInexact(T actual, T expected, double tolerance) {
        return this.checkInexact(actual, expected, tolerance, "");
    }

    public <T> boolean checkInexact(T actual, T expected, double tolerance, String testname) {
        String result = "actual:                                 expected:\n" + Printer.combineActualExpected(Printer.produceString(actual), Printer.produceString(expected)) + "\n";
        if (this.inspector.inexactTest(tolerance)) {
            return this.report(false, testname + "\nProvided tolerance value was < 0", result);
        }
        if (this.isExactType(actual.getClass().getName()) || this.isExactType(expected.getClass().getName())) {
            return this.report(false, testname + "\nAttempt to make inexact comparison of " + "" + "exact primitive or wrapper data", result);
        }
        return this.report(this.inspector.isSame(actual, expected), testname, result);
    }

    public <T> boolean checkSet(Set<T> actual, Set<T> expected) {
        return this.checkSet(actual, expected, "");
    }

    public <T> boolean checkSet(Set<T> actual, Set<T> expected, String testname) {
        this.testname = testname;
        return this.report(this.inspector.exactTest() && this.inspector.isSameSet(actual, expected) && !this.inspector.inexactViolation(), testname, this.combineIterable(actual, expected));
    }

    public <T> boolean checkIterable(Iterable<T> actual, Iterable<T> expected) {
        return this.checkIterable(actual, expected, "");
    }

    public <T> boolean checkIterable(Iterable<T> actual, Iterable<T> expected, String testname) {
        this.testname = testname;
        return this.report(this.inspector.exactTest() && this.inspector.isSameIterable(actual, expected) && !this.inspector.inexactViolation(), testname, this.combineIterable(actual, expected));
    }

    public <T> boolean checkInexactIterable(Iterable<T> actual, Iterable<T> expected, double tolerance) {
        return this.checkInexactIterable(actual, expected, tolerance, "");
    }

    public <T> boolean checkInexactIterable(Iterable<T> actual, Iterable<T> expected, double tolerance, String testname) {
        if (this.inspector.inexactTest(tolerance)) {
            return this.report(false, testname + "\nProvided tolerance value was < 0", this.combineIterable(actual, expected));
        }
        this.testname = testname;
        return this.report(this.inspector.isSameIterable(actual, expected), testname, this.combineIterable(actual, expected));
    }

    public <T> boolean checkTraversal(Traversal<T> actual, Traversal<T> expected) {
        return this.checkTraversal(actual, expected, "");
    }

    public <T> boolean checkTraversal(Traversal<T> actual, Traversal<T> expected, String testname) {
        this.testname = testname;
        return this.report(this.inspector.exactTest() && this.inspector.isSameTraversal(actual, expected) && !this.inspector.inexactViolation(), testname, this.combineTraversal(actual, expected));
    }

    public <T> boolean checkInexactTraversal(Traversal<T> actual, Traversal<T> expected, double tolerance) {
        return this.checkInexactTraversal(actual, expected, tolerance, "");
    }

    public <T> boolean checkInexactTraversal(Traversal<T> actual, Traversal<T> expected, double tolerance, String testname) {
        if (this.inspector.inexactTest(tolerance)) {
            return this.report(false, testname + "\nProvided tolerance value was < 0", this.combineTraversal(actual, expected));
        }
        this.testname = testname;
        return this.report(this.inspector.isSameTraversal(actual, expected), testname, this.combineTraversal(actual, expected));
    }

    public <T> boolean checkFail(T actual, T expected) {
        return this.checkFail(actual, expected, "");
    }

    public <T> boolean checkFail(T actual, T expected, String testname) {
        this.testname = testname;
        return this.report(this.inspector.exactTest() && (!this.inspector.isSame(actual, expected) || this.inspector.inexactViolation()), "Failure expected: \n" + testname, "actual:                                 expected:\n" + Printer.combineActualExpected(Printer.produceString(actual), Printer.produceString(expected)) + "\n");
    }

    public <T> boolean checkInexactFail(T actual, T expected, double tolerance) {
        return this.checkInexactFail(actual, expected, tolerance, "");
    }

    public <T> boolean checkInexactFail(T actual, T expected, double tolerance, String testname) {
        String result = "actual:                                 expected:\n" + Printer.combineActualExpected(Printer.produceString(actual), Printer.produceString(expected)) + "\n";
        if (tolerance < 0.0) {
            return this.report(true, testname + " Failure expected: \n" + "\n Test failed because the provided tolerance is < 0", result);
        }
        if (this.isExactType(actual.getClass().getName()) || this.isExactType(expected.getClass().getName())) {
            return this.report(true, testname + " Failure expected: \n" + "\nTest failed because we cannot make inexact comparison of " + "exact primitive or wrapper data", result);
        }
        this.setTolerance(tolerance);
        this.testname = testname;
        return this.report(!this.inspector.isSame(actual, expected), "Failure expected: \n" + testname, result);
    }

    public <T> boolean checkException(Exception e, T object, String method, Object ... args) {
        return this.checkException("", e, object, method, args);
    }

    public <T> boolean checkException(String testname, Exception e, T object, String method, Object ... args) {
        return this.checkPrivateException(testname, e, object, method, args);
    }

    private <T> boolean checkPrivateException(String testname, Exception e, T object, String method, Object ... args) {
        this.testname = testname;
        int length = args != null ? args.length : 0;
        Class[] parameters = new Class[length];
        for (int i = 0; i < length; ++i) {
            parameters[i] = args[i].getClass();
        }
        Class<?> exceptClass = e.getClass();
        String exceptName = exceptClass.getName();
        String exceptMessage = e.getMessage();
        String trace = this.getStackTrace();
        try {
            Method meth = this.findMethod(object, method, parameters);
            if (meth == null) {
                throw new NoSuchMethodException("Method " + method + " not found");
            }
            Reflector.ensureIsAccessible(meth);
            Object result = meth.invoke(object, args);
            if (result == null) {
                return this.report(false, testname, "\n invocation did not throw any exception \n  method name: " + meth.getName() + "\n  object class: " + object.getClass().getName() + "\n  result: void" + ": " + "\n  expected exception was: \n    class: " + exceptName + "\n    message: " + exceptMessage);
            }
            return this.report(false, testname, "\n invocation did not throw any exception \n  method name: " + meth.getName() + "\n  object class: " + object.getClass().getName() + "\n  result: " + result.getClass().getName() + ": " + Printer.produceString(result) + "\n  expected exception was: \n    class: " + exceptName + "\n    message: " + exceptMessage);
        }
        catch (Throwable exception) {
            String excMessage;
            String excName;
            if (exception.getCause() != null) {
                excName = exception.getCause().getClass().getName();
                excMessage = exception.getCause().getMessage();
            } else {
                excName = exception.getClass().getName();
                excMessage = exception.getMessage();
            }
            if (excName.equals(exceptName)) {
                if (exceptMessage == null && excMessage == null || excMessage != null && excMessage.equals(exceptMessage)) {
                    return this.reportSuccess(testname, "\n correct exception: \n class: " + exceptName + "\n correct message: " + exceptMessage + "\n    after invoking the method " + method + "\n    by an object in the class: " + object.getClass().getName() + "\n    object value was: \n" + Printer.produceString(object));
                }
                return this.reportErrors(testname, "\n correct exception: \n class: " + exceptName + "\n incorrect message: \n" + "\n message produced: " + excMessage + "\n message expected: " + exceptMessage + "\n    after invoking the method " + method + "\n    by an object in the class: " + object.getClass().getName() + "\n    object value was: \n" + Printer.produceString(object) + "\n\n" + trace + "\n");
            }
            return this.reportErrors(testname, "\n incorrect exception was thrown: \n exception thrown:   " + excName + "\n exception expected: " + exceptName + "\n    with the message: " + exceptMessage + "\n    after invoking the method " + method + "\n    by an object in the class: " + object.getClass().getName() + "\n    object value was: \n" + Printer.produceString(object) + "\n\n" + trace + "\n");
        }
    }

    public <T> boolean checkConstructorException(Exception e, String className, Object ... args) {
        return this.checkConstructorException("", e, className, args);
    }

    public <T> boolean checkConstructorException(String testname, Exception e, String className, Object ... args) {
        return this.checkPrivateConstructorException(testname, e, className, args);
    }

    private <T> boolean checkPrivateConstructorException(String testname, Exception e, String className, Object ... args) {
        this.testname = testname;
        int length = args != null ? args.length : 0;
        Class[] parameters = new Class[length];
        for (int i = 0; i < length; ++i) {
            parameters[i] = args[i].getClass();
        }
        Class<?> exceptClass = e.getClass();
        String exceptName = exceptClass.getName();
        String exceptMessage = e.getMessage();
        String trace = this.getStackTrace();
        try {
            Class<?> objectClass = Reflector.classForName(className);
            Constructor<?> constr = null;
            Constructor<?>[] constructors = objectClass.getDeclaredConstructors();
            for (int i = 0; i < Array.getLength(constructors); ++i) {
                if (!this.matchParams(parameters, constructors[i].getParameterTypes())) continue;
                constr = constructors[i];
                break;
            }
            if (constr == null) {
                throw new NoSuchMethodException("Constructor for the class " + className + " with the given arguments not found");
            }
            Reflector.ensureIsAccessible(constr);
            Object result = constr.newInstance(args);
            if (result == null) {
                return this.report(false, testname, "\n constructor invocation for the class " + className + " did not throw any exception " + "\n  result: void" + ": " + "\n  expected exception was: \n    class: " + exceptName + "\n    message: " + exceptMessage);
            }
            return this.report(false, testname, "\n constructor invocation for the class " + className + " did not throw any exception " + "\n  result: " + result.getClass().getName() + ": " + Printer.produceString(result) + "\n  expected exception was: \n    class: " + exceptName + "\n    message: " + exceptMessage);
        }
        catch (Throwable exception) {
            String excMessage;
            String excName;
            if (exception.getCause() != null) {
                excName = exception.getCause().getClass().getName();
                excMessage = exception.getCause().getMessage();
            } else {
                excName = exception.getClass().getName();
                excMessage = exception.getMessage();
            }
            if (excName.equals(exceptName)) {
                if (exceptMessage == null && excMessage == null || excMessage != null && excMessage.equals(exceptMessage)) {
                    return this.reportSuccess(testname, "\n correct exception: \n class: " + exceptName + "\n correct message: " + exceptMessage + "\n" + "\n after invoking the constructor for the class " + className);
                }
                return this.reportErrors(testname, "\n correct exception: \n class: " + exceptName + "\n incorrect message: \n" + "\n message produced: " + excMessage + "\n message expected: " + exceptMessage + "\n after invoking the constructor for the class " + className + "\n\n" + trace + "\n");
            }
            return this.reportErrors(testname, "\n incorrect exception was thrown: \n exception thrown:   " + excName + "\n message produced: " + excMessage + "\n exception expected: " + exceptName + "\n    with the message: " + exceptMessage + "\n after invoking the constructor for the class " + className + "\n\n" + trace + "\n");
        }
    }

    public <T> boolean checkMethod(Object expected, T object, String method, Object ... args) {
        return this.checkMethod("", expected, object, method, args);
    }

    public <T> boolean checkMethod(String testname, Object expected, T object, String method, Object ... args) {
        return this.inspector.exactTest() && this.checkPrivateMethod(testname, expected, object, method, args, false);
    }

    public <T> boolean checkInexactMethod(Object expected, double tolerance, T object, String method, Object ... args) {
        return this.checkInexactMethod("", expected, tolerance, object, method, args);
    }

    public <T> boolean checkInexactMethod(String testname, Object expected, double tolerance, T object, String method, Object ... args) {
        if (this.inspector.inexactTest(tolerance)) {
            return this.reportErrors(testname + "\nProvided tolerance value was < 0", "\n Inexact method invocation test ");
        }
        return this.checkPrivateMethod(testname, expected, object, method, args, true);
    }

    private <T> boolean checkPrivateMethod(String testname, Object expected, T object, String method, Object[] args, boolean inexact) {
        this.testname = testname;
        int length = Array.getLength(args);
        Class[] parameters = new Class[length];
        for (int i = 0; i < length; ++i) {
            parameters[i] = args[i].getClass();
        }
        String parlist = "(";
        for (Class parameter : parameters) {
            parlist = parlist + parameter.getName() + ",";
        }
        parlist = parlist.substring(0, parlist.length() - 1) + ")";
        try {
            Method meth = this.findMethod(object, method, parameters);
            if (meth == null) {
                return this.report(false, testname + "\nNo method with the name " + method + " found\n", "Failed to invoke the method " + object.getClass().getName() + "." + method + parlist + Printer.produceString(expected));
            }
            Reflector.ensureIsAccessible(meth);
            String testmessage = testname + "\n" + Printer.produceString(object) + "\n invoked method " + method + " in the class " + object.getClass().getName() + "\n with arguments " + this.makeArglist(args) + ")\n";
            if (inexact) {
                return this.checkInexact(meth.invoke(object, args), expected, Inspector.TOLERANCE, testmessage);
            }
            return this.checkExpect(meth.invoke(object, args), expected, testmessage);
        }
        catch (Throwable exception) {
            String testmessage = testname + "\n" + Printer.produceString(object) + "\n invoked method " + method + " in the class " + object.getClass().getName() + "\n with arguments " + this.makeArglist(args) + ")\n";
            boolean result = this.report(false, testmessage + "\nthrew an excception ", Printer.produceString(object) + Printer.produceString(args));
            exception.printStackTrace();
            return result;
        }
    }

    private String makeArglist(Object ... args) {
        String arglist = "(";
        for (Object o : args) {
            arglist = arglist.concat(Printer.produceString(o) + ",\n");
        }
        if (arglist.length() > 1) {
            arglist = arglist.substring(0, arglist.length() - 2);
        }
        return arglist;
    }

    public <T> boolean checkOneOf(T actual, T ... expected) {
        return this.checkOneOf("", actual, expected);
    }

    public <T> boolean checkOneOf(String testname, T actual, T ... expected) {
        for (int i = 0; i < Array.getLength(expected); ++i) {
            if (!this.inspector.isSame(actual, expected[i]) || this.inspector.inexactViolation()) continue;
            return this.report(true, testname, this.combine(actual, expected[i]));
        }
        return this.report(false, testname + "\nNo matching value found " + "among the list of expected values", this.combineOneOf(actual, expected));
    }

    public <T> boolean checkInexactOneOf(double tolerance, T actual, T ... expected) {
        return this.checkInexactOneOf("", tolerance, actual, expected);
    }

    public <T> boolean checkInexactOneOf(String testname, double tolerance, T actual, T ... expected) {
        if (this.inspector.inexactTest(tolerance)) {
            return this.report(false, testname + "\nProvided tolerance value was < 0", this.combineOneOf(actual, expected));
        }
        this.testname = testname;
        for (int i = 0; i < Array.getLength(expected); ++i) {
            if (!this.inspector.isSame(actual, expected[i])) continue;
            return this.report(true, testname, this.combine(actual, expected[i]));
        }
        return this.report(false, testname + "\nNo matching value found " + "among the list of expected values", this.combineOneOf(actual, expected));
    }

    public <T> boolean checkNoneOf(T actual, T ... expected) {
        return this.checkNoneOf(actual, expected, "");
    }

    public <T> boolean checkNoneOf(String testname, T actual, T ... expected) {
        for (int i = 0; i < Array.getLength(expected); ++i) {
            if (!this.inspector.isSame(actual, expected[i]) || this.inspector.inexactViolation()) continue;
            return this.report(false, "Matching value found in none-of test\n" + testname, this.combine(actual, expected[i]));
        }
        return this.report(true, testname + "\nNo matching value found among the list of excluded values", this.combineOneOf(actual, expected));
    }

    public <T> boolean checkInexactNoneOf(double tolerance, T actual, T ... expected) {
        return this.checkInexactNoneOf(tolerance, actual, expected, "");
    }

    public <T> boolean checkInexactNoneOf(String testname, double tolerance, T actual, T ... expected) {
        if (this.inspector.inexactTest(tolerance)) {
            return this.report(false, testname + "\nProvided tolerance value was < 0", this.combineOneOf(actual, expected));
        }
        this.testname = testname;
        for (int i = 0; i < Array.getLength(expected); ++i) {
            if (!this.inspector.isSame(actual, expected[i])) continue;
            return this.report(false, "Matching value found in none-of test\n" + testname, this.combine(actual, expected[i]));
        }
        return this.report(true, testname + "\nNo matching value found among the list of excluded values", this.combineOneOf(actual, expected));
    }

    public <T> boolean checkNumRange(Number actual, Number low, Number high) {
        return this.checkNumRange(actual, low, high, "");
    }

    public <T> boolean checkNumRange(Number actual, Number low, Number high, String testname) {
        return this.checkNumRange(actual, low, high, true, false, testname);
    }

    public <T> boolean checkNumRange(Number actual, Number low, Number high, boolean lowIncl, boolean highIncl) {
        return this.checkNumRange(actual, low, high, lowIncl, highIncl, "");
    }

    public <T> boolean checkNumRange(Number actual, Number low, Number high, boolean lowIncl, boolean highIncl, String testname) {
        boolean belowHigh;
        Inspector.INEXACT_COMPARED = false;
        this.testname = testname;
        boolean within = true;
        boolean aboveLow = Double.valueOf(actual.doubleValue()).compareTo(low.doubleValue()) > 0;
        boolean bl = belowHigh = Double.valueOf(actual.doubleValue()).compareTo(high.doubleValue()) < 0;
        if (lowIncl) {
            boolean bl2 = aboveLow = aboveLow || Double.valueOf(actual.doubleValue()).compareTo(low.doubleValue()) == 0;
        }
        if (highIncl) {
            belowHigh = belowHigh || Double.valueOf(actual.doubleValue()).compareTo(high.doubleValue()) == 0;
        }
        boolean bl3 = within = aboveLow && belowHigh;
        if (within) {
            return this.report(within, testname, actual, low, high);
        }
        return this.report(within, testname + "\nActual value is not within the [low high) range.", actual, low, high);
    }

    public <T> boolean checkRange(Comparable<T> actual, T low, T high) {
        return this.checkRange(actual, low, high, "");
    }

    public <T> boolean checkRange(Comparable<T> actual, T low, T high, String testname) {
        return this.checkRange(actual, low, high, true, false, testname);
    }

    public <T> boolean checkRange(Comparable<T> actual, T low, T high, boolean lowIncl, boolean highIncl) {
        return this.checkRange(actual, low, high, lowIncl, highIncl, "");
    }

    public <T> boolean checkRange(Comparable<T> actual, T low, T high, boolean lowIncl, boolean highIncl, String testname) {
        Inspector.INEXACT_COMPARED = false;
        this.testname = testname;
        boolean within = true;
        boolean aboveLow = true;
        boolean belowHigh = true;
        String ls = "(";
        String hs = ")";
        if (lowIncl) {
            aboveLow = actual.compareTo(low) >= 0;
            ls = "[";
        } else {
            boolean bl = aboveLow = actual.compareTo(low) > 0;
        }
        if (highIncl) {
            belowHigh = actual.compareTo(high) <= 0;
            hs = "]";
        } else {
            belowHigh = actual.compareTo(high) < 0;
        }
        boolean bl = within = aboveLow && belowHigh;
        if (within) {
            return this.report(within, testname, actual, low, high);
        }
        return this.report(within, testname + "\nActual value is not within the " + ls + "low high" + hs + " range.", actual, low, high);
    }

    public <T> boolean checkRange(T actual, T low, T high, Comparator<T> comp, String testname) {
        return this.checkRange(actual, low, high, true, false, comp, testname);
    }

    public <T> boolean checkRange(T actual, T low, T high, Comparator<T> comp) {
        return this.checkRange(actual, low, high, true, false, comp, "");
    }

    public <T> boolean checkRange(T actual, T low, T high, boolean lowIncl, boolean highIncl, Comparator<T> comp) {
        return this.checkRange(actual, low, high, lowIncl, highIncl, comp, "");
    }

    public <T> boolean checkRange(T actual, T low, T high, boolean lowIncl, boolean highIncl, Comparator<T> comp, String testname) {
        Inspector.INEXACT_COMPARED = false;
        this.testname = testname;
        boolean within = true;
        boolean aboveLow = true;
        boolean belowHigh = true;
        String ls = "(";
        String hs = ")";
        if (lowIncl) {
            aboveLow = comp.compare(actual, low) >= 0;
            ls = "[";
        } else {
            boolean bl = aboveLow = comp.compare(actual, low) > 0;
        }
        if (highIncl) {
            belowHigh = comp.compare(actual, high) <= 0;
            hs = "]";
        } else {
            belowHigh = comp.compare(actual, high) < 0;
        }
        boolean bl = within = aboveLow && belowHigh;
        if (within) {
            return this.report(within, testname, actual, low, high);
        }
        return this.report(within, testname + "\nActual value is not within the " + ls + "low high" + hs + " range.", actual, low, high);
    }

    public <T> boolean checkEquivalent(T obj1, T obj2, Equivalence<T> equiv) {
        return this.checkEquivalent(obj1, obj2, equiv, "");
    }

    public <T> boolean checkInequivalent(T obj1, T obj2, Equivalence<T> equiv) {
        return this.checkInequivalent(obj1, obj2, equiv, "");
    }

    public <T> boolean checkEquivalent(T obj1, T obj2, Equivalence<T> equiv, String testname) {
        this.testname = "Equivalence test: \n" + testname;
        return this.report(equiv.equivalent(obj1, obj2), testname, this.combine(obj1, obj2));
    }

    public <T> boolean checkInequivalent(T obj1, T obj2, Equivalence<T> equiv, String testname) {
        this.testname = "Equivalence test: \n" + testname;
        return this.checkExpect(!equiv.equivalent(obj1, obj2), "Should be inequivalent: \n" + testname);
    }

    private <T> Method findMethod(T object, String method, Class<?>[] parameters) {
        Method[] allMethods = this.findAllMethods(object.getClass());
        ArrayList<Method> allNamed = new ArrayList<Method>();
        for (Method elt : allMethods) {
            if (!elt.getName().equals(method)) continue;
            allNamed.add(elt);
        }
        if (allNamed.size() > 0) {
            for (Method m : allNamed) {
                if (!this.matchParams(parameters, m.getParameterTypes())) continue;
                return m;
            }
            this.testname = this.testname + "\nNo method with the name " + method + " had a matching argument list\n";
            System.out.println(this.testname);
            return null;
        }
        this.testname = this.testname + "\nNo method with the name " + method + " found\n";
        System.out.println(this.testname);
        return null;
    }

    private <T> ArrayList<Method> findTestMethods(T object, String testname) {
        Method[] allMethods = this.findAllMethods(object.getClass());
        ArrayList<Method> allNamed = new ArrayList<Method>();
        Class[] testerParam = new Class[]{this.getClass()};
        for (Method method : allMethods) {
            if (method.getName().startsWith("test") && this.matchParams(method.getParameterTypes(), testerParam)) {
                allNamed.add(method);
                Reflector.ensureIsAccessible(method);
                continue;
            }
            if (method.getAnnotation(TestMethod.class) == null) continue;
            allNamed.add(method);
            Reflector.ensureIsAccessible(method);
        }
        if (allNamed.size() > 0) {
            testname = testname + "Found " + allNamed.size() + " test methods";
            return allNamed;
        }
        testname = testname + "\nNo method with the name test..." + " found in the class " + object.getClass().getName() + "\n";
        return null;
    }

    private Method[] findAllMethods(Class<?> c) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Class<?> classToSurvey = c; classToSurvey != null && classToSurvey != Object.class; classToSurvey = classToSurvey.getSuperclass()) {
            Method[] allMethods;
            for (Method m : allMethods = classToSurvey.getDeclaredMethods()) {
                Reflector.ensureIsAccessible(m);
                list.add(m);
            }
        }
        return list.toArray(new Method[0]);
    }

    private boolean matchParams(Class<?>[] parInput, Class<?>[] parDefined) {
        if (Array.getLength(parInput) != Array.getLength(parDefined)) {
            return false;
        }
        if (Array.getLength(parInput) == 0) {
            return true;
        }
        for (int i = 0; i < Array.getLength(parInput); ++i) {
            if (this.matchPair(parInput[i], parDefined[i])) continue;
            return false;
        }
        return true;
    }

    private boolean matchPair(Class<?> parInput, Class<?> parDefined) {
        String def;
        String in = parInput.getName();
        if (in.equals(def = parDefined.getName())) {
            return true;
        }
        if (def.equals("java.lang.Object")) {
            return true;
        }
        if (in.equals("java.lang.String") || def.equals("java.lang.String")) {
            return false;
        }
        return !(Inspector.isWrapperClass(def) || Inspector.isWrapperClass(in) ? !this.isWrapperMatch(in, def) : !parDefined.isAssignableFrom(parInput));
    }

    private boolean isWrapperMatch(String in, String def) {
        if (def.equals("java.lang.Integer") && in.equals("int")) {
            return true;
        }
        if (def.equals("java.lang.Short") && in.equals("short")) {
            return true;
        }
        if (def.equals("java.lang.Long") && in.equals("long")) {
            return true;
        }
        if (def.equals("java.lang.Byte") && in.equals("byte")) {
            return true;
        }
        if (def.equals("java.lang.Character") && in.equals("char")) {
            return true;
        }
        if (def.equals("java.lang.Double") && in.equals("double")) {
            return true;
        }
        if (def.equals("java.lang.Float") && in.equals("float")) {
            return true;
        }
        if (def.equals("java.lang.Boolean") && in.equals("boolean")) {
            return true;
        }
        if (def.equals("int") && in.equals("java.lang.Integer")) {
            return true;
        }
        if (def.equals("short") && in.equals("java.lang.Short")) {
            return true;
        }
        if (def.equals("long") && in.equals("java.lang.Long")) {
            return true;
        }
        if (def.equals("byte") && in.equals("java.lang.Byte")) {
            return true;
        }
        if (def.equals("char") && in.equals("java.lang.Character")) {
            return true;
        }
        if (def.equals("double") && in.equals("java.lang.Double")) {
            return true;
        }
        if (def.equals("float") && in.equals("java.lang.Float")) {
            return true;
        }
        if (def.equals("boolean") && in.equals("java.lang.Boolean")) {
            return true;
        }
        if (def.equals("java.lang.Integer") && in.equals("java.lang.Integer")) {
            return true;
        }
        if (def.equals("java.lang.Short") && in.equals("java.lang.Short")) {
            return true;
        }
        if (def.equals("java.lang.Long") && in.equals("java.lang.Long")) {
            return true;
        }
        if (def.equals("java.lang.Byte") && in.equals("java.lang.Byte")) {
            return true;
        }
        if (def.equals("java.lang.Character") && in.equals("java.lang.Character")) {
            return true;
        }
        if (def.equals("java.lang.Double") && in.equals("java.lang.Double")) {
            return true;
        }
        if (def.equals("java.lang.Float") && in.equals("java.lang.Float")) {
            return true;
        }
        return def.equals("java.lang.Boolean") && in.equals("java.lang.Boolean");
    }

    private boolean isExactType(String in) {
        return in.equals("java.lang.Integer") || in.equals("int") || in.equals("java.lang.Short") || in.equals("short") || in.equals("java.lang.Long") || in.equals("long") || in.equals("java.lang.Byte") || in.equals("byte") || in.equals("java.lang.Character") || in.equals("char") || in.equals("java.lang.Boolean") || in.equals("boolean");
    }

    private <T> String combine(T actual, T expected) {
        return "actual:                                 expected:\n" + Printer.combineActualExpected(Printer.produceString(actual), Printer.produceString(expected)) + "\n";
    }

    private <T> String combineOneOf(T actual, T ... expected) {
        return "actual:   " + Printer.produceString(actual) + "\nexpected: \n" + Printer.produceString(expected) + "\n";
    }

    private <T> String combineIterable(Iterable<T> actual, Iterable<T> expected) {
        return "actual:                                 expected:\n" + Printer.combineActualExpected(Printer.produceIterableStrings(actual), Printer.produceIterableStrings(expected)) + "\n";
    }

    private <T> String combineTraversal(Traversal<T> actual, Traversal<T> expected) {
        return "actual:                                 expected:\n" + Printer.combineActualExpected(Printer.produceTraversalStrings(actual), Printer.produceTraversalStrings(expected)) + "\n";
    }

    private boolean report(boolean success, String testname, String result) {
        if (success) {
            return this.reportSuccess(testname, result);
        }
        String trace = this.getStackTrace();
        return this.reportErrors(testname + "\n" + trace, result);
    }

    private boolean report(boolean success, String testname, Object actual, Object low, Object high) {
        if (success) {
            return this.reportSuccess(testname, actual, low, high);
        }
        String trace = this.getStackTrace();
        return this.reportErrors(testname + "\n" + trace, actual, low, high);
    }

    private boolean reportErrors(String testname, String result) {
        return this.addError("Error in test number " + (this.numberOfTests + 1) + "\n" + testname + this.insertWarning() + result + "\n");
    }

    private boolean reportErrors(String testname, Object actual, Object low, Object high) {
        return this.addError("Error in range test number " + (this.numberOfTests + 1) + "\n" + testname + "\n" + this.insertWarning() + "actual:    " + Printer.produceString(actual) + "\n" + "low:       " + Printer.produceString(low) + "\n" + "high:      " + Printer.produceString(high) + "\n");
    }

    private String getStackTrace() {
        try {
            throw new ErrorReport("Error trace:");
        }
        catch (ErrorReport e) {
            StackTraceElement[] ste = e.getStackTrace();
            int length = Array.getLength(ste);
            StackTraceElement[] tmpSTE = new StackTraceElement[length];
            int ui = 0;
            for (int i = 3; i < length; ++i) {
                String cname = ste[i].getClassName();
                if (cname.startsWith("tester.") || cname.startsWith("sun.reflect") || cname.startsWith("java.lang") || cname.startsWith("bluej") || cname.startsWith("__SHELL")) continue;
                tmpSTE[ui] = ste[i];
                ++ui;
            }
            StackTraceElement[] userSTE = new StackTraceElement[ui];
            for (int i = 0; i < ui; ++i) {
                userSTE[i] = tmpSTE[i];
            }
            e.setStackTrace(userSTE);
            StringWriter writer = new StringWriter();
            PrintWriter printwriter = new PrintWriter(writer);
            e.printStackTrace(printwriter);
            return writer.toString();
        }
    }

    private boolean reportSuccess(String testname, String result) {
        return this.addSuccess("Success in the test number " + (this.numberOfTests + 1) + "\n" + testname + "\n" + this.insertWarning() + result + "\n");
    }

    private boolean reportSuccess(String testname, Object actual, Object low, Object high) {
        return this.addSuccess("Success in the range test number " + (this.numberOfTests + 1) + "\n" + testname + "\n" + this.insertWarning() + "actual:   " + Printer.produceString(actual) + "\n" + "low:      " + Printer.produceString(low) + "\n" + "high:     " + Printer.produceString(high) + "\n");
    }

    private String insertWarning() {
        if (Inspector.INEXACT_COMPARED) {
            ++this.warnings;
            return "The comparison involved inexact numbers with relative tolerance " + Inspector.TOLERANCE + "\n";
        }
        return "";
    }

    private boolean addSuccess(String testResult) {
        ++this.numberOfTests;
        this.fullTestResults = this.fullTestResults.append("\n" + testResult);
        return true;
    }

    private boolean addError(String testResult) {
        ++this.numberOfTests;
        ++this.errors;
        this.failedResults = this.failedResults.append("\n" + testResult);
        this.fullTestResults = this.fullTestResults.append("\n" + testResult);
        return false;
    }

    private String testCount() {
        String tCount = "";
        if (this.numberOfTests == 1) {
            tCount = "\nRan 1 test.\n";
        } else if (this.numberOfTests > 1) {
            tCount = "\nRan " + this.numberOfTests + " tests.\n";
        }
        if (this.errors == 0) {
            tCount = tCount + "All tests passed.\n";
        }
        if (this.errors == 1) {
            tCount = tCount + "1 test failed.\n";
        } else if (this.errors > 1) {
            tCount = tCount + this.errors + " tests failed.\n";
        }
        if (this.warnings == 0) {
            tCount = tCount + "\n";
        }
        if (this.warnings == 1) {
            tCount = tCount + "Issued 1 warning of inexact comparison.\n\n";
        } else if (this.warnings > 1) {
            tCount = tCount + "Issued " + this.warnings + " warnings of inexact comparison.\n\n";
        }
        return tCount;
    }

    protected void testReport() {
        System.out.print(this.testCount());
        if (this.errors > 0) {
            System.out.println(this.failedResults);
        }
        System.out.println("--- END OF TEST RESULTS ---");
    }

    protected void fullTestReport() {
        System.out.println(this.testCount() + this.fullTestResults + "\n--- END OF FULL TEST RESULTS ---");
    }

    public static boolean run(Object obj) {
        Tester t = new Tester();
        t.runAnyTests(obj, false, true);
        return t.errors == 0;
    }

    public static boolean runFullReport(Object ... objs) {
        Tester t = new Tester();
        if (objs != null) {
            for (Object obj : objs) {
                t.runAnyTests(obj, true, true);
            }
        }
        return t.errors == 0;
    }

    public static boolean runReport(Object obj, boolean full, boolean printall) {
        Tester t = new Tester();
        t.runAnyTests(obj, full, printall);
        return t.errors == 0;
    }

    public static boolean runReports(boolean full, boolean printall, Object ... objs) {
        Tester t = new Tester();
        if (objs != null) {
            for (Object obj : objs) {
                t.runAnyTests(obj, full, printall);
            }
        }
        return t.errors == 0;
    }

    static {
        try {
            String line;
            InputStream inputStream = Tester.class.getClassLoader().getResourceAsStream("META-INF/maven/ccs.neu.edu/tester/pom.xml");
            BufferedReader br = inputStream == null ? new BufferedReader(new FileReader(new File("pom.xml"))) : new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line.trim());
            }
            Pattern p = Pattern.compile("<version>(.*?)</version>");
            Matcher m = p.matcher(sb);
            m.find();
            version = "Tester Prima v." + m.group(1) + "\n-----------------------------------";
        }
        catch (Exception e) {
            System.out.println("** Failed to read tester version. **");
            version = "Tester Prima v.\n-----------------------------------";
        }
    }
}

