/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import tester.Inspector;
import tester.Printer;

public class Reflector {
    protected Object sample;
    protected Class<?> sampleClass;
    protected Field[] sampleDeclaredFields;
    private static CallerResolver RESOLVER;
    private static final String[] STACK_FILTERS;

    protected Reflector(Object sample) {
        if (sample != null) {
            this.sample = sample;
            this.sampleClass = this.sample.getClass();
            this.sampleDeclaredFields = this.getFields(sample);
        }
    }

    protected ArrayList<Class<?>> getClasses(Object obj) {
        ArrayList classTower = new ArrayList();
        if (obj == null) {
            return classTower;
        }
        Class<?> c = obj.getClass();
        String cPackageName = this.getPackageName(c);
        classTower.add(c);
        Class<?> sc = c.getSuperclass();
        if (!(cPackageName.equals("Object Type") || cPackageName.equals("Wrapper Class") || cPackageName.equals("Libraries"))) {
            while (!sc.getName().equals("java.lang.Object")) {
                classTower.add(0, sc);
                sc = sc.getSuperclass();
            }
        }
        return classTower;
    }

    protected String getPackageName(Class<?> c) {
        String name = c.getName();
        if (name.equals("java.lang.Object")) {
            return "Object Type";
        }
        if (Inspector.isWrapperClass(name)) {
            return "Wrapper Class";
        }
        if (name.startsWith("java") || name.startsWith("sun") || name.startsWith("apple") || name.startsWith("javax")) {
            return "Java Library";
        }
        if (name.startsWith("draw") || name.startsWith("idraw") || name.startsWith("adraw") || name.startsWith("geometry") || name.startsWith("colors")) {
            return "Libraries";
        }
        Package p = c.getPackage();
        if (p == null) {
            return "Default Package";
        }
        return p.getName();
    }

    protected Field[] getFields(Object obj) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        ArrayList<Class<?>> classTower = this.getClasses(obj);
        for (Class<?> cl : classTower) {
            Field[] fields;
            for (Field f : fields = cl.getDeclaredFields()) {
                Reflector.ensureIsAccessible(f);
                int modif = f.getModifiers();
                if (Modifier.isStatic(modif) || Modifier.isVolatile(modif) || Modifier.isTransient(modif) || !f.getDeclaringClass().equals(cl)) continue;
                allFields.add(f);
            }
        }
        Field[] allFieldsArray = new Field[allFields.size()];
        return allFields.toArray(allFieldsArray);
    }

    protected void printInfo() {
        System.out.println("sample: " + this.sample);
        System.out.println("sampleClass: " + this.sampleClass);
        System.out.println("sampleDeclaredFields: \n");
        this.printSampleFields(this.sampleDeclaredFields);
    }

    protected void printSampleFields(Field[] fieldArray) {
        System.out.println("number of fields: " + Array.getLength(fieldArray) + "\n");
        for (Field f : fieldArray) {
            Class<?> t = f.getType();
            System.out.println("field name = " + f.getName() + "\nfield  type = " + t.getName());
            try {
                System.out.println("field value = " + f.get(this.sample) + "\n");
            }
            catch (IllegalAccessException e) {
                System.out.println("printSampleFields cannot access the field  message: " + e.getMessage());
            }
        }
    }

    protected Field findField(String fieldName) {
        for (Field f : this.sampleDeclaredFields) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        return null;
    }

    protected void show(String fieldName) {
        Field f = this.findField(fieldName);
        if (f == null) {
            System.out.println("Object " + fieldName + " is not declared in this class.");
        } else {
            try {
                System.out.println("this." + fieldName + " = " + Printer.produceString(f.get(this.sample)));
            }
            catch (IllegalAccessException e) {
                System.out.println("the field " + f.getName() + " cannot be shown \n" + " message: " + e.getMessage());
            }
        }
    }

    protected Field findFieldWithValue(Object fieldValue) {
        for (Field f : this.sampleDeclaredFields) {
            try {
                if (!f.get(this.sample).equals(fieldValue)) continue;
                return f;
            }
            catch (IllegalAccessException e) {
                System.out.println("findFieldWithValue cannot access the field " + f.getName() + " of the class " + this.sampleClass.getName() + "\n   message: " + e.getMessage());
            }
        }
        return null;
    }

    protected void showFieldWithValue(Object fieldValue) {
        Field f = this.findFieldWithValue(fieldValue);
        if (f == null) {
            System.out.println("Object " + fieldValue + " is not declared in this class.");
        } else {
            try {
                System.out.println("this." + f.getName() + " = " + Printer.produceString(f.get(this.sample)));
            }
            catch (IllegalAccessException e) {
                System.out.println("the field " + f.getName() + "cannot be shown \n" + " message: " + e.getMessage());
            }
        }
    }

    static void ensureIsAccessible(final AccessibleObject object) {
        if (!object.isAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    object.setAccessible(true);
                    return null;
                }
            });
        }
    }

    public static Class<?> classForName(String name) throws ClassNotFoundException {
        ClassNotFoundException exception = null;
        for (ClassLoader loader : Reflector.getCandidateLoaders()) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                exception = e;
            }
        }
        if (exception == null) {
            exception = new ClassNotFoundException(name);
        }
        throw exception;
    }

    private static ClassLoader[] getCandidateLoaders() {
        ClassLoader temp;
        ClassLoader[] result = new ClassLoader[]{RESOLVER.getNonlibraryCallerClass().getClassLoader(), Thread.currentThread().getContextClassLoader(), Reflector.class.getClassLoader()};
        boolean moved = false;
        if (Reflector.hasAsChild(result[1], result[2])) {
            temp = result[2];
            result[2] = result[1];
            result[1] = temp;
            moved = true;
        }
        if (Reflector.hasAsChild(result[0], result[1])) {
            temp = result[1];
            result[1] = result[0];
            result[0] = temp;
            moved = true;
        }
        if (moved) {
            if (Reflector.hasAsChild(result[1], result[2])) {
                temp = result[2];
                result[2] = result[1];
                result[1] = temp;
            }
        } else if (Reflector.hasAsChild(result[0], result[2])) {
            temp = result[2];
            result[2] = result[0];
            result[0] = temp;
        }
        return result;
    }

    private static boolean hasAsChild(ClassLoader loader1, ClassLoader loader2) {
        if (loader1 == loader2) {
            return true;
        }
        if (loader2 == null) {
            return false;
        }
        if (loader1 == null) {
            return true;
        }
        while (loader2 != null) {
            if (loader2 == loader1) {
                return true;
            }
            loader2 = loader2.getParent();
        }
        return false;
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    RESOLVER = new SecurityManagerCallerResolver();
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            System.out.println("Warning: " + Reflector.class + " could not create CallerResolver:");
            e.printStackTrace();
            RESOLVER = new CallerResolver(){

                @Override
                public Class<?> getNonlibraryCallerClass() {
                    return Reflector.class;
                }
            };
        }
        STACK_FILTERS = new String[]{"tester.", "org.junit.", "junit.", "java.", "sun.", "org.apache.tools.ant."};
    }

    private static class SecurityManagerCallerResolver
    extends SecurityManager
    implements CallerResolver {
        private SecurityManagerCallerResolver() {
        }

        @Override
        public Class<?> getNonlibraryCallerClass() {
            Class<?>[] stack = this.getClassContext();
            for (Class<?> c : this.getClassContext()) {
                String prefix;
                boolean isClientClass = true;
                String name = c.getName();
                int i$ = 0;
                String[] arr$ = STACK_FILTERS;
                int len$ = arr$.length;
                if (i$ < len$ && name.startsWith(prefix = arr$[i$])) {
                    isClientClass = false;
                }
                if (!isClientClass) continue;
                return c;
            }
            if (stack.length > 0) {
                return stack[stack.length - 1];
            }
            return Reflector.class;
        }
    }

    private static interface CallerResolver {
        public Class<?> getNonlibraryCallerClass();
    }
}

