/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.awt.Color;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import tester.Inspector;
import tester.Reflector;
import tester.Traversal;

public class Printer {
    private static String INDENT = "";
    private static Class<?> stringClass = INDENT.getClass();
    private static int counter;
    private static HashMap<Integer, Integer> hashmap;

    public static void print(Object obj) {
        hashmap.clear();
        counter = 0;
        System.out.println(Printer.makeString(obj));
    }

    public static String produceString(Object obj) {
        hashmap.clear();
        counter = 0;
        return Printer.makeString(obj);
    }

    public static <T> String produceIterableStrings(Iterable<T> it) {
        hashmap.clear();
        counter = 0;
        return Printer.makeIterableStrings(it.iterator());
    }

    public static <T> String produceTraversalStrings(Traversal<T> tr) {
        hashmap.clear();
        counter = 0;
        return Printer.makeTraversalStrings(tr);
    }

    private static String makeString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return " \"" + obj.toString() + "\"";
        }
        if (obj instanceof Random) {
            return " new Random() ";
        }
        if (obj instanceof Color) {
            return " \"" + obj.toString() + "\"";
        }
        if (obj instanceof Enum) {
            Enum e = (Enum)obj;
            return e.getDeclaringClass().getName().replace('$', '.') + "." + e.name();
        }
        Method tism = Printer.toIndentedStringMethod(obj);
        if (tism != null) {
            return Printer.getIndentedString(obj, tism);
        }
        Class<?> objClass = obj.getClass();
        if (objClass.isPrimitive() || Inspector.isWrapperClass(objClass.getName())) {
            return Printer.makePrimitiveStrings(objClass.getName(), obj);
        }
        if (Inspector.isWorldImage(obj.getClass().getName())) {
            return obj.toString();
        }
        String s = Printer.hasDefinedToString(obj);
        s = s != null ? s + "\n" : "\n";
        Integer i1 = System.identityHashCode(obj);
        Integer i1match = hashmap.get(i1);
        if (i1match != null) {
            return obj.getClass().getName() + ":" + i1match;
        }
        i1match = ++counter;
        hashmap.put(i1, counter);
        if (Inspector.isOurCanvas(obj.getClass().getName())) {
            return obj.toString();
        }
        if (obj instanceof Object[]) {
            int length = Array.getLength(obj);
            StringBuilder tmp = new StringBuilder("\n" + INDENT + " new Object[" + length + "](){");
            INDENT = INDENT + "  ";
            int n = 0;
            for (int i = 0; i < length; ++i) {
                tmp = tmp.append("\n" + INDENT + "[" + n + "] " + Printer.makeString(((Object[])obj)[i]) + ",");
                ++n;
            }
            if (Array.getLength(obj) > 0) {
                tmp.deleteCharAt(tmp.length() - 1);
            }
            INDENT = INDENT.substring(0, INDENT.length() - 2);
            tmp = tmp.append("}");
            return tmp + "";
        }
        String result = s + INDENT + " new " + objClass.getName() + ":" + i1match + "(";
        INDENT = INDENT + "  ";
        if (obj instanceof Iterable && obj.getClass().getName().startsWith("java.util")) {
            result = result + "){" + Printer.makeIterableStrings(((Iterable)obj).iterator()) + "}";
        } else if (obj instanceof Map) {
            result = result + "){" + Printer.makeMapStrings((Map)obj) + "}";
        } else {
            Reflector r = new Reflector(obj);
            for (Field f : r.sampleDeclaredFields) {
                try {
                    Reflector.ensureIsAccessible(f);
                    String field = f.get(obj) == null ? "this." + f.getName() + " = null" : "this." + f.getName() + " = " + Printer.makeString(f.get(obj));
                    result = result + "\n" + INDENT + field;
                }
                catch (IllegalAccessException e) {
                    System.out.println("makeString cannot access the field " + f.getName() + " of the class " + r.sampleClass.getName() + "\n   message: " + e.getMessage());
                }
            }
            result = result + ")";
        }
        INDENT = INDENT.substring(0, INDENT.length() - 2);
        return result;
    }

    private static <T> String makePrimitiveStrings(String className, T value) {
        StringBuilder result = new StringBuilder();
        if (className.equals("java.lang.Short")) {
            return result + value.toString() + "S";
        }
        if (className.equals("java.lang.Long")) {
            return result + value.toString() + "L";
        }
        if (className.equals("java.lang.Float")) {
            return result + value.toString() + "F";
        }
        if (className.equals("java.math.BigInteger")) {
            return result + value.toString() + "BigInteger";
        }
        if (className.equals("java.math.BigDecimal")) {
            return result + value.toString() + "BigDecimal";
        }
        return result + value.toString();
    }

    private static <T> String makeIterableStrings(Iterator<T> it) {
        StringBuilder result = new StringBuilder();
        int n = 0;
        while (it.hasNext()) {
            result = result.append("\n" + INDENT + "Iterable[" + n + "] " + Printer.makeString(it.next()) + ",");
            ++n;
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result + "";
    }

    private static <T> String makeTraversalStrings(Traversal<T> tr) {
        StringBuilder result = new StringBuilder();
        int n = 0;
        while (!tr.isEmpty()) {
            result = result.append("\n" + INDENT + "Traversal[" + n + "] " + Printer.makeString(tr.getFirst()) + ",");
            ++n;
            tr = tr.getRest();
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result + "";
    }

    private static <K, V> String makeMapStrings(Map<K, V> hm) {
        StringBuilder result = new StringBuilder();
        HashSet<Map.Entry<K, V>> data = new HashSet<Map.Entry<K, V>>(hm.entrySet());
        for (Map.Entry entry : data) {
            result = result.append("\n" + INDENT + "(key: " + Printer.makeString(entry.getKey()) + "\n" + INDENT + " value: " + Printer.makeString(entry.getValue()) + "),");
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result + "";
    }

    private static String hasDefinedToString(Object o) {
        Method tsm = null;
        Class<?> c = o.getClass();
        Class<?> cs = c.getSuperclass();
        while (c != null) {
            try {
                tsm = c.getDeclaredMethod("toString", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (tsm != null) {
                try {
                    Class<?> defclass = tsm.getDeclaringClass();
                    if (defclass.getName().equals("java.lang.Object") || defclass.getName().equals("java.util.AbstractCollection")) {
                        return "";
                    }
                    Reflector.ensureIsAccessible(tsm);
                    return (String)tsm.invoke(o, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    System.out.println("IllegalAccessException:" + e.getMessage());
                    System.out.println("Incorrectly invoked toString method in the class:" + o.getClass().getName() + "\n");
                    continue;
                }
                catch (InvocationTargetException e) {
                    System.out.println("InvocationTargetException:" + e.getMessage());
                    System.out.println("Incorrectly invoked toString method in the class:" + o.getClass().getName() + "\n");
                    continue;
                }
            }
            c = cs;
            cs = c.getSuperclass();
        }
        return "";
    }

    private static Method toIndentedStringMethod(Object o) {
        Method tsm = null;
        Class<?> c = o.getClass();
        if (c != null) {
            try {
                tsm = c.getDeclaredMethod("toIndentedString", stringClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return tsm;
        }
        return null;
    }

    private static String getIndentedString(Object o, Method tism) {
        try {
            Reflector.ensureIsAccessible(tism);
            return (String)tism.invoke(o, INDENT);
        }
        catch (IllegalAccessException e) {
            System.out.println("IllegalAccessException:" + e.getMessage());
            System.out.println("Incorrectly invoked toIndentedString method in the class:" + o.getClass().getName() + "\n");
        }
        catch (InvocationTargetException e) {
            System.out.println("InvocationTargetException:" + e.getMessage());
            System.out.println("Incorrectly invoked toIndentedString method in the class:" + o.getClass().getName() + "\n");
        }
        return "";
    }

    protected static String combineActualExpected(String actual, String expected) {
        String space = "                                                  ";
        String fill = "..................................................";
        StringBuilder combined = new StringBuilder("");
        StringTokenizer actLine = new StringTokenizer(actual, "\n");
        StringTokenizer expLine = new StringTokenizer(expected, "\n");
        String actString = actLine.nextToken();
        String expString = expLine.nextToken();
        while (expString.equals(actString)) {
            combined.append(Printer.combineSpaceFill(actString, expString, space));
            if (!expLine.hasMoreTokens()) {
                return Printer.finishActual(combined, actLine);
            }
            if (!actLine.hasMoreTokens()) {
                return Printer.finishExpected(combined, expLine);
            }
            actString = actLine.nextToken();
            expString = expLine.nextToken();
        }
        combined.append(Printer.combineSpaceFill(actString, expString, fill));
        while (expLine.hasMoreTokens() && actLine.hasMoreTokens()) {
            actString = actLine.nextToken();
            expString = expLine.nextToken();
            combined.append(Printer.combineSpaceFill(actString, expString, space));
        }
        if (!expLine.hasMoreTokens()) {
            return Printer.finishActual(combined, actLine);
        }
        if (!actLine.hasMoreTokens()) {
            return Printer.finishExpected(combined, expLine);
        }
        return combined.toString();
    }

    private static String combineSpaceFill(String act, String exp, String spfill) {
        if (act.length() > 48) {
            return "\n--  actual  : " + act + spfill.substring(0, 10) + "\n" + "\n--  expected: " + exp + "\n\n";
        }
        return act + spfill.substring(0, 50 - act.length()) + exp + "\n";
    }

    private static String finishActual(StringBuilder combined, StringTokenizer actLine) {
        while (actLine.hasMoreTokens()) {
            combined.append(actLine.nextToken() + "\n");
        }
        return combined.toString();
    }

    private static String finishExpected(StringBuilder combined, StringTokenizer expLine) {
        String space40 = "                                        ";
        while (expLine.hasMoreTokens()) {
            combined.append(space40 + expLine.nextToken() + "\n");
        }
        return combined.toString();
    }

    public static void main(String[] argv) {
        String act = "hello\ngoodbye\nadieau\n";
        String expTrue = "hello\ngoodbye\nadieau\n";
        String expFalse1 = "hello\ngoodbyes\nadieau\n";
        String expFalse2 = "hello\ngoodbye\n";
        String expFalse3 = "hello\ngoodbyes\nadieau\nahoy\n";
        String longact = "abcdefghijklmnopqrtsuvwxyzabcdefghijklmnopqrtsuvwxyz";
        String longexp = "abcdefghijklmnopqrtsuvwxyzabcdefghijklmnopqrtsuvwxyz";
        String longexpbad = "abcdefghijklmnopqrtsuvwxyzabcdefghijklmnopqrtsuvwxyz1";
        System.out.println(Printer.combineActualExpected(act, expTrue));
        System.out.println(Printer.combineActualExpected(act, expFalse1));
        System.out.println(Printer.combineActualExpected(act, expFalse2));
        System.out.println(Printer.combineActualExpected(act, expFalse3));
        System.out.println(Printer.combineActualExpected(longact, longexp));
        System.out.println(Printer.combineActualExpected(longact, longexpbad));
    }

    static {
        hashmap = new HashMap();
    }
}

