/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import tester.ISame;
import tester.Reflector;
import tester.Traversal;

public class Inspector {
    protected static double TOLERANCE = 0.001;
    protected static String INDENT = "  ";
    private HashMap<Integer, Integer> hashmap = new HashMap();
    protected static boolean INEXACT_COMPARED = false;
    protected static boolean INEXACT_ALLOWED = false;

    protected boolean inexactViolation() {
        return INEXACT_COMPARED && !INEXACT_ALLOWED;
    }

    public <T> boolean isSame(T obj1, T obj2) {
        this.hashmap.clear();
        INEXACT_COMPARED = false;
        return this.isSamePrivate(obj1, obj2);
    }

    protected boolean inexactTest(double tolerance) {
        INEXACT_COMPARED = false;
        INEXACT_ALLOWED = true;
        TOLERANCE = tolerance;
        return tolerance < 0.0;
    }

    protected boolean exactTest() {
        INEXACT_COMPARED = false;
        INEXACT_ALLOWED = false;
        return true;
    }

    public <T> boolean isSameIterable(Iterable<T> obj1, Iterable<T> obj2) {
        this.hashmap.clear();
        INEXACT_ALLOWED = false;
        INEXACT_COMPARED = false;
        return this.isSameIterablePrivate(obj1, obj2);
    }

    public <T> boolean isSameSet(Set<T> obj1, Set<T> obj2) {
        this.hashmap.clear();
        INEXACT_ALLOWED = false;
        INEXACT_COMPARED = false;
        return this.isSameSetPrivate(obj1, obj2);
    }

    public <T> boolean isSameTraversal(Traversal<T> obj1, Traversal<T> obj2) {
        this.hashmap.clear();
        INEXACT_ALLOWED = false;
        INEXACT_COMPARED = false;
        return this.isSameTraversalPrivate(obj1, obj2);
    }

    private <T> boolean isSamePrivate(T obj1, T obj2) {
        int i;
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        if (obj1 == obj2) {
            return true;
        }
        if (this.checkIColors(obj1, obj2)) {
            return true;
        }
        Reflector r1 = new Reflector(obj1);
        Reflector r2 = new Reflector(obj2);
        boolean sameClass = r1.sampleClass.equals(r2.sampleClass);
        String r1Name = r1.sampleClass.getName();
        String r2Name = r2.sampleClass.getName();
        if (r1Name.equals("java.lang.String")) {
            return obj1.equals(obj2);
        }
        if (r1.sampleClass.isPrimitive()) {
            if (!sameClass) {
                return false;
            }
            if (this.isDouble(r1Name)) {
                return this.isSameDouble((Double)obj1, (Double)obj2);
            }
            if (this.isFloat(r1Name)) {
                return this.isSameFloat(((Float)obj1).floatValue(), ((Float)obj2).floatValue());
            }
            return obj1.equals(obj2);
        }
        if (Inspector.isWrapperClass(r1Name)) {
            if (!sameClass) {
                return false;
            }
            if (this.isDouble(r1Name)) {
                return this.isSameDouble((Double)obj1, (Double)obj2);
            }
            if (this.isFloat(r1Name)) {
                return this.isSameFloat(((Float)obj1).floatValue(), ((Float)obj2).floatValue());
            }
            return obj1.equals(obj2);
        }
        Integer i1 = System.identityHashCode(obj1);
        Integer i2 = System.identityHashCode(obj2);
        Integer i2match = this.hashmap.get(i1 * i1 + i2 * i2);
        if (i2match != null && i2match.equals(i1 + i2)) {
            return true;
        }
        this.hashmap.put(i1 * i1 + i2 * i2, i1 + i2);
        if (obj1.getClass().isArray() && obj2.getClass().isArray() && obj1.getClass() == obj2.getClass()) {
            int length = Array.getLength(obj1);
            if (Array.getLength(obj2) == length) {
                for (int i3 = 0; i3 < length; ++i3) {
                    if (this.isSame(Array.get(obj1, i3), Array.get(obj2, i3))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (obj1 instanceof ISame && obj2 instanceof ISame) {
            return ((ISame)obj1).same((ISame)obj2);
        }
        if (obj1 instanceof Set && obj2 instanceof Set && obj1.getClass().getName().startsWith("java.util")) {
            return this.isSameSet((Set)obj1, (Set)obj2);
        }
        if (obj1 instanceof Iterable && obj2 instanceof Iterable && obj1.getClass().getName().startsWith("java.util")) {
            return this.isSameIterablePrivate((Iterable)obj1, (Iterable)obj2);
        }
        if (obj1 instanceof Map && obj2 instanceof Map && obj1.getClass().getName().startsWith("java.util")) {
            return this.isSameMap((Map)obj1, (Map)obj2);
        }
        boolean sameValues = true;
        try {
            for (i = 0; i < Array.getLength(r1.sampleDeclaredFields); ++i) {
                sameValues = sameValues && this.isSamePrivate(r1.sampleDeclaredFields[i].get(obj1), r2.sampleDeclaredFields[i].get(obj2));
            }
        }
        catch (IllegalAccessException e) {
            System.out.println("same comparing " + r1.sampleDeclaredFields[i].getType().getName() + " and " + r2.sampleDeclaredFields[i].getType().getName() + "cannot access the field " + i + " message: " + e.getMessage());
            System.out.println("class 1: " + r1.sampleClass.getName());
            System.out.println("class 2: " + r2.sampleClass.getName());
        }
        return sameValues;
    }

    protected boolean isSameDouble(double d1, double d2) {
        if (d1 - d2 == 0.0) {
            return true;
        }
        INEXACT_COMPARED = true;
        if (d1 == 0.0) {
            return Math.abs(d2) < TOLERANCE;
        }
        if (d2 == 0.0) {
            return Math.abs(d1) < TOLERANCE;
        }
        return Math.abs(d1 - d2) / Math.abs((d1 + d2) / 2.0) < TOLERANCE;
    }

    protected boolean isSameFloat(float f1, float f2) {
        if ((double)(f1 - f2) == 0.0) {
            return true;
        }
        INEXACT_COMPARED = true;
        Double d1 = Float.valueOf(f1).doubleValue();
        Double d2 = Float.valueOf(f2).doubleValue();
        if ((double)f1 == 0.0) {
            return Math.abs(d2) < TOLERANCE;
        }
        if ((double)f2 == 0.0) {
            return Math.abs(d1) < TOLERANCE;
        }
        return Math.abs(d1 - d2) / Math.max(Math.abs(d1), Math.abs(d2)) < TOLERANCE;
    }

    private <T> boolean isSameIterablePrivate(Iterable<T> obj1, Iterable<T> obj2) {
        Iterator<T> it1 = obj1.iterator();
        Iterator<T> it2 = obj2.iterator();
        return this.isSameData(it1, it2);
    }

    private <T> boolean isSameTraversalPrivate(Traversal<T> obj1, Traversal<T> obj2) {
        Traversal<T> it1 = obj1;
        Traversal<T> it2 = obj2;
        return this.isSameTraversalData(it1, it2);
    }

    protected <T> boolean isSameData(Iterator<T> it1, Iterator<T> it2) {
        if (!it1.hasNext()) {
            return !it2.hasNext();
        }
        if (!it2.hasNext()) {
            return false;
        }
        return this.isSamePrivate(it1.next(), it2.next()) && this.isSameData(it1, it2);
    }

    protected <T> boolean isSameTraversalData(Traversal<T> tr1, Traversal<T> tr2) {
        if (tr1.isEmpty()) {
            return tr2.isEmpty();
        }
        if (tr2.isEmpty()) {
            return false;
        }
        return this.isSamePrivate(tr1.getFirst(), tr2.getFirst()) && this.isSameTraversalData(tr1.getRest(), tr2.getRest());
    }

    protected <K, V> boolean isSameMap(Map<K, V> obj1, Map<K, V> obj2) {
        if (obj1.size() != obj2.size()) {
            return false;
        }
        Set<K> set1 = obj1.keySet();
        for (K key : set1) {
            if (!obj2.containsKey(key)) {
                return false;
            }
            if (this.isSamePrivate(obj1.get(key), obj2.get(key))) continue;
            return false;
        }
        return true;
    }

    protected <T> boolean isSameSetPrivate(Set<T> obj1, Set<T> obj2) {
        if (obj1.size() != obj2.size()) {
            return false;
        }
        for (T item1 : obj1) {
            boolean match = false;
            for (T item2 : obj2) {
                if (!item1.equals(item2)) continue;
                match = true;
            }
            if (match) continue;
            System.out.println("Mismatch for " + obj1 + " and " + obj2);
            return false;
        }
        return true;
    }

    protected boolean isDouble(String name) {
        return name.equals("double") || name.equals("java.lang.Double");
    }

    protected boolean isFloat(String name) {
        return name.equals("float") || name.equals("java.lang.Float");
    }

    protected static boolean isWrapperClass(String name) {
        return name.equals("java.lang.Integer") || name.equals("java.lang.Long") || name.equals("java.lang.Short") || name.equals("java.math.BigInteger") || name.equals("java.math.BigDecimal") || name.equals("java.lang.Float") || name.equals("java.lang.Double") || name.equals("java.lang.Byte") || name.equals("java.lang.Boolean") || name.equals("java.lang.Character");
    }

    protected static boolean isOurCanvas(String name) {
        return name.equals("draw.Canvas") || name.equals("idraw.Canvas") || name.equals("adraw.Canvas") || name.equals("funworld.Canvas") || name.equals("impworld.Canvas") || name.equals("appletworld.Canvas") || name.equals("javalib.worldcanvas.WorldCanvas") || name.equals("javalib.worldcanvas.AppletCanvas") || name.equals("impsoundworld.Canvas") || name.equals("appletsoundworld.Canvas");
    }

    protected static boolean isTunesPackage(String name) {
        return name.startsWith("javalib.tunes.");
    }

    protected <T> boolean checkIColors(T obj1, T obj2) {
        if (obj1.getClass().getName().equals("colors.Red")) {
            return obj2.getClass().getName().equals("colors.Red");
        }
        if (obj1.getClass().getName().equals("colors.White")) {
            return obj2.getClass().getName().equals("colors.White");
        }
        if (obj1.getClass().getName().equals("colors.Blue")) {
            return obj2.getClass().getName().equals("colors.Blue");
        }
        if (obj1.getClass().getName().equals("colors.Black")) {
            return obj2.getClass().getName().equals("colors.Black");
        }
        if (obj1.getClass().getName().equals("colors.Green")) {
            return obj2.getClass().getName().equals("colors.Green");
        }
        if (obj1.getClass().getName().equals("colors.Yellow")) {
            return obj2.getClass().getName().equals("colors.Yellow");
        }
        return false;
    }

    protected static <T> boolean isWorldImage(String name) {
        ArrayList<String> worldPackageNames = new ArrayList<String>(Arrays.asList("funworld", "impworld", "appletworld", "impsoundworld", "appletsoundworld"));
        ArrayList<String> worldImageClassNames = new ArrayList<String>(Arrays.asList("CircleImage", "Crop", "EllipseImage", "FreezeImage", "FromFileImage", "FromURLImage", "LinearImage", "OverlayImage", "PolygonImage", "RasterImage", "RectangleImage", "TextImage"));
        for (String packagename : worldPackageNames) {
            if (!name.startsWith(packagename)) continue;
            for (String classname : worldImageClassNames) {
                if (!name.endsWith(classname)) continue;
                return true;
            }
        }
        return false;
    }
}

