/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.test;

import com.sun.jna.Pointer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.cocoa.foundation.NSAutoreleasePool;
import org.rococoa.cocoa.foundation.NSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RococoaTestCase {
    public static boolean gcAfterTest = true;
    protected static final Logger logging;
    protected NSAutoreleasePool pool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeLogging() {
        try {
            InputStream is = null;
            try {
                is = RococoaTestCase.class.getResourceAsStream("/test-logging.properties");
                if (is == null) {
                    throw new FileNotFoundException("Cannot find test-logging.properties");
                }
                LogManager.getLogManager().readConfiguration(is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException x) {
            throw new RuntimeException("Could not initialize logging", x);
        }
    }

    private static void logVersions() {
        logging.info("Running with JAVA_HOME = {}, java.version = {}, sizeof(Pointer) = {}", new Object[]{System.getenv("JAVA_HOME"), System.getProperty("java.version"), Pointer.SIZE});
    }

    @Before
    public void preSetup() {
        this.pool = NSAutoreleasePool.new_();
        Assert.assertNotNull((Object)this.pool);
    }

    @After
    public void postTeardown() {
        if (gcAfterTest) {
            RococoaTestCase.gc();
        }
        this.pool.drain();
    }

    public static void assertRetainCount(int expected, NSObject object) {
        RococoaTestCase.assertRetainCount(expected, object.id());
    }

    public static void assertRetainCount(int expected, ID id) {
        Assert.assertEquals((long)expected, (long)Foundation.cfGetRetainCount(id));
    }

    public static void gc() {
        System.gc();
        System.gc();
        System.runFinalization();
    }

    static {
        RococoaTestCase.initializeLogging();
        logging = LoggerFactory.getLogger("org.rococoa.RococoaTestCase");
        RococoaTestCase.logVersions();
    }
}

