/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.internal;

import com.sun.jna.FromNativeContext;
import com.sun.jna.NativeMapped;
import com.sun.jna.ToNativeContext;
import com.sun.jna.TypeConverter;
import org.rococoa.Foundation;
import org.rococoa.ID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringTypeConverter
implements TypeConverter {
    private static final NativeMapped nativeLongConverter = new ID();

    StringTypeConverter() {
    }

    @Override
    public Class<?> nativeType() {
        return nativeLongConverter.nativeType();
    }

    @Override
    public String fromNative(Object nativeValue, FromNativeContext context) {
        Number nativeValueAsNumber = (Number)nativeValue;
        if (nativeValueAsNumber == null) {
            return null;
        }
        ID id = ID.fromLong(nativeValueAsNumber.longValue());
        if (id.isNull()) {
            return null;
        }
        return Foundation.toString(id);
    }

    @Override
    public Object toNative(Object value, ToNativeContext context) {
        if (value == null) {
            return null;
        }
        String valueAsString = (String)value;
        ID valueAsID = Foundation.cfString(valueAsString);
        Foundation.sendReturnsID(valueAsID, "autorelease", new Object[0]);
        return valueAsID.toNative();
    }
}

