/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.internal;

import org.rococoa.cocoa.foundation.NSAutoreleasePool;
import org.rococoa.internal.OperationBatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoreleaseBatcher
extends OperationBatcher {
    private static Logger logging = LoggerFactory.getLogger("org.rococoa");
    private static final ThreadLocal<AutoreleaseBatcher> threadLocal = new ThreadLocal();
    private NSAutoreleasePool pool;

    public static AutoreleaseBatcher forThread(int batchSize) {
        if (threadLocal.get() == null) {
            threadLocal.set(new AutoreleaseBatcher(batchSize));
        }
        return threadLocal.get();
    }

    public AutoreleaseBatcher(int batchSize) {
        super(batchSize);
    }

    protected void operation() {
        if (logging.isDebugEnabled()) {
            logging.debug("Draining autorelease pool");
        }
        this.pool.drain();
    }

    protected void reset() {
        this.pool = NSAutoreleasePool.new_();
    }
}

