/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Enhancer;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.ObjCClass;
import org.rococoa.ObjCObject;
import org.rococoa.internal.OCInvocationCallbacks;
import org.rococoa.internal.ObjCObjectInvocationHandler;
import org.rococoa.internal.VarArgsUnpacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Rococoa {
    private static Logger logging = LoggerFactory.getLogger("org.rococoa.proxy");

    public static <T extends ObjCClass> T createClass(String ocClassName, Class<T> type) {
        return (T)((ObjCClass)Rococoa.wrap(Foundation.getClass(ocClassName), type, false));
    }

    public static <T extends ObjCObject> T create(String ocClassName, Class<T> javaClass, String ocMethodName, Object ... args) {
        boolean weOwnObject = Foundation.selectorNameMeansWeOwnReturnedObject(ocMethodName);
        boolean retain = !weOwnObject;
        return Rococoa.create(ocClassName, javaClass, ocMethodName, retain, args);
    }

    public static <T extends ObjCObject> T create(String ocClassName, Class<T> javaClass) {
        return Rococoa.create(ocClassName, javaClass, "new", new Object[0]);
    }

    private static <T extends ObjCObject> T create(String ocClassName, Class<T> javaClass, String ocFactoryName, boolean retain, Object ... args) {
        if (logging.isTraceEnabled()) {
            logging.trace("creating [{} ({})].{}({})", new Object[]{ocClassName, javaClass.getName(), ocFactoryName, new VarArgsUnpacker(args)});
        }
        ID ocClass = Foundation.getClass(ocClassName);
        ID ocInstance = Foundation.send(ocClass, ocFactoryName, ID.class, args);
        Rococoa.checkRetainCount(ocInstance, 1);
        T result = Rococoa.wrap(ocInstance, javaClass, retain);
        Rococoa.checkRetainCount(ocInstance, retain ? 2 : 1);
        return result;
    }

    public static <T extends ObjCObject> T wrap(ID id, Class<T> javaClass) {
        return Rococoa.wrap(id, javaClass, true);
    }

    public static <T extends ObjCObject> T cast(ObjCObject object, Class<T> desiredType) {
        if (object == null) {
            return null;
        }
        return Rococoa.wrap(object.id(), desiredType, true);
    }

    public static <T extends ObjCObject> T wrap(ID id, Class<T> javaClass, boolean retain) {
        if (id == null || id.isNull()) {
            return null;
        }
        ObjCObjectInvocationHandler invocationHandler = new ObjCObjectInvocationHandler(id, javaClass, retain);
        return (T)((ObjCObject)Rococoa.createProxy(javaClass, invocationHandler));
    }

    @Deprecated
    public static ID wrap(Object javaObject) {
        OCInvocationCallbacks callbacks = new OCInvocationCallbacks(javaObject);
        ID idOfOCProxy = Foundation.newOCProxy(callbacks);
        return new ProxyID(idOfOCProxy, callbacks);
    }

    public static ObjCObject proxy(Object javaObject) {
        return Rococoa.proxy(javaObject, ObjCObject.class);
    }

    public static <T extends ObjCObject> T proxy(Object javaObject, Class<T> javaType) {
        ID proxyID = Rococoa.wrap(javaObject);
        return Rococoa.wrap(proxyID, javaType, false);
    }

    private static <T> T createProxy(final Class<T> type, ObjCObjectInvocationHandler invocationHandler) {
        if (type.isInterface()) {
            return (T)Proxy.newProxyInstance(invocationHandler.getClass().getClassLoader(), new Class[]{type}, (InvocationHandler)invocationHandler);
        }
        Enhancer e = new Enhancer();
        e.setUseCache(true);
        e.setNamingPolicy(new DefaultNamingPolicy(){

            public String getClassName(String prefix, String source, Object key, Predicate names) {
                if (source.equals(Enhancer.class.getName())) {
                    return type.getName() + "$$ByRococoa";
                }
                return super.getClassName(prefix, source, key, names);
            }
        });
        e.setSuperclass(type);
        e.setCallback(invocationHandler);
        return (T)e.create();
    }

    private static void checkRetainCount(ID ocInstance, int expected) {
        int retainCount = Foundation.cfGetRetainCount(ocInstance);
        if (retainCount != expected) {
            throw new IllegalStateException("Created an object which had a retain count of " + retainCount + " not " + expected);
        }
    }

    private Rococoa() {
    }

    public static class ProxyID
    extends ID {
        private OCInvocationCallbacks callbacks;

        public ProxyID() {
        }

        public ProxyID(ID anotherID, OCInvocationCallbacks callbacks) {
            super(anotherID);
            this.callbacks = callbacks;
        }
    }
}

