/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa;

import com.sun.jna.Native;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.rococoa.ID;
import org.rococoa.RococoaException;
import org.rococoa.Selector;
import org.rococoa.StringEncoding;
import org.rococoa.internal.FoundationLibrary;
import org.rococoa.internal.MainThreadUtils;
import org.rococoa.internal.MsgSendInvocationMapper;
import org.rococoa.internal.MsgSendLibrary;
import org.rococoa.internal.OCInvocationCallbacks;
import org.rococoa.internal.RococoaLibrary;
import org.rococoa.internal.VarArgsUnpacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Foundation {
    private static Logger logging = LoggerFactory.getLogger("org.rococoa.foundation");
    private static final FoundationLibrary foundationLibrary;
    private static final MsgSendLibrary messageSendLibrary;
    private static final RococoaLibrary rococoaLibrary;
    private static final Map<String, Selector> selectorCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nsLog(String format, Object thing) {
        ID formatAsCFString = Foundation.cfString(format);
        try {
            foundationLibrary.NSLog(formatAsCFString, thing);
        }
        finally {
            Foundation.cfRelease(formatAsCFString);
        }
    }

    public static ID cfString(String s) {
        try {
            byte[] utf16Bytes = s.getBytes("UTF-16LE");
            return foundationLibrary.CFStringCreateWithBytes(null, utf16Bytes, utf16Bytes.length, StringEncoding.kCFStringEncodingUTF16LE.value, (byte)0);
        }
        catch (UnsupportedEncodingException x) {
            throw new RococoaException(x);
        }
    }

    public static ID cfRetain(ID id) {
        if (logging.isTraceEnabled()) {
            logging.trace("calling cfRetain({})", id);
        }
        return foundationLibrary.CFRetain(id);
    }

    public static void cfRelease(ID id) {
        if (logging.isTraceEnabled()) {
            logging.trace("calling cfRelease({})", id);
        }
        foundationLibrary.CFRelease(id);
    }

    public static int cfGetRetainCount(ID cfTypeRef) {
        return foundationLibrary.CFGetRetainCount(cfTypeRef);
    }

    public static String toString(ID cfString) {
        return Foundation.toStringViaUTF8(cfString);
    }

    static String toStringViaUTF16(ID cfString) {
        try {
            int lengthInChars = foundationLibrary.CFStringGetLength(cfString);
            int potentialLengthInBytes = 3 * lengthInChars + 1;
            byte[] buffer = new byte[potentialLengthInBytes];
            byte ok = foundationLibrary.CFStringGetCString(cfString, buffer, buffer.length, StringEncoding.kCFStringEncodingUTF16LE.value);
            if (ok == 0) {
                throw new RococoaException("Could not convert string");
            }
            return new String(buffer, "UTF-16LE").substring(0, lengthInChars);
        }
        catch (UnsupportedEncodingException e) {
            throw new RococoaException(e);
        }
    }

    static String toStringViaUTF8(ID cfString) {
        int lengthInChars = foundationLibrary.CFStringGetLength(cfString);
        int potentialLengthInBytes = 3 * lengthInChars + 1;
        byte[] buffer = new byte[potentialLengthInBytes];
        byte ok = foundationLibrary.CFStringGetCString(cfString, buffer, buffer.length, StringEncoding.kCFStringEncodingUTF8.value);
        if (ok == 0) {
            throw new RococoaException("Could not convert string");
        }
        return Native.toString(buffer);
    }

    public static ID getClass(String className) {
        if (logging.isTraceEnabled()) {
            logging.trace("calling objc_getClass({})", (Object)className);
        }
        return foundationLibrary.objc_getClass(className);
    }

    public static Selector selector(String selectorName) {
        Selector cached = selectorCache.get(selectorName);
        if (cached != null) {
            return cached;
        }
        Selector result = foundationLibrary.sel_registerName(selectorName).initName(selectorName);
        selectorCache.put(selectorName, result);
        return result;
    }

    public static <T> T send(ID receiver, String selectorName, Class<T> returnType, Object ... args) {
        return Foundation.send(receiver, Foundation.selector(selectorName), returnType, args);
    }

    public static <T> T send(ID receiver, Selector selector, Class<T> returnType, Object ... args) {
        if (logging.isTraceEnabled()) {
            logging.trace("sending ({}) {}.{}({})", new Object[]{returnType.getSimpleName(), receiver, selector.getName(), new VarArgsUnpacker(args)});
        }
        return (T)messageSendLibrary.syntheticSendMessage(returnType, receiver, selector, args);
    }

    public static ID sendReturnsID(ID receiver, String selectorName, Object ... args) {
        return Foundation.send(receiver, Foundation.selector(selectorName), ID.class, args);
    }

    public static void sendReturnsVoid(ID receiver, String selectorName, Object ... args) {
        Foundation.send(receiver, Foundation.selector(selectorName), Void.TYPE, args);
    }

    public static boolean isMainThread() {
        return MainThreadUtils.isMainThread();
    }

    public static <T> T callOnMainThread(Callable<T> callable) {
        return MainThreadUtils.callOnMainThread(rococoaLibrary, callable);
    }

    public static void runOnMainThread(Runnable runnable) {
        MainThreadUtils.runOnMainThread(rococoaLibrary, runnable, true);
    }

    public static void runOnMainThread(Runnable runnable, boolean waitUntilDone) {
        MainThreadUtils.runOnMainThread(rococoaLibrary, runnable, waitUntilDone);
    }

    public static ID newOCProxy(OCInvocationCallbacks callbacks) {
        return rococoaLibrary.proxyForJavaObject(callbacks.selectorInvokedCallback, callbacks.methodSignatureCallback);
    }

    public static boolean selectorNameMeansWeOwnReturnedObject(String selectorName) {
        return selectorName.startsWith("alloc") || selectorName.startsWith("new") || selectorName.toLowerCase().contains("copy");
    }

    static {
        selectorCache = new HashMap<String, Selector>();
        logging.trace("Initializing Foundation");
        System.setProperty("jna.encoding", "UTF8");
        HashMap<String, MsgSendInvocationMapper> messageSendLibraryOptions = new HashMap<String, MsgSendInvocationMapper>(1);
        messageSendLibraryOptions.put("invocation-mapper", new MsgSendInvocationMapper());
        messageSendLibrary = (MsgSendLibrary)Native.loadLibrary("Foundation", MsgSendLibrary.class, messageSendLibraryOptions);
        foundationLibrary = (FoundationLibrary)Native.loadLibrary("Foundation", FoundationLibrary.class);
        rococoaLibrary = (RococoaLibrary)Native.loadLibrary("rococoa", RococoaLibrary.class);
        logging.trace("exit initializing Foundation");
    }
}

