/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;

public class AutoHashMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 1693618702345072811L;
    Constructor<V> valueConstructor;

    public AutoHashMap(Class<V> valueClass) {
        try {
            this.valueConstructor = valueClass.getConstructor(new Class[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("No accessible default constructor in class " + (valueClass == null ? "null" : valueClass.getName()), ex);
        }
    }

    protected V newInstance(K key) {
        try {
            return this.valueConstructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to call constructor " + this.valueConstructor, ex);
        }
    }

    @Override
    public V get(Object key) {
        Object v = super.get(key);
        if (v == null) {
            v = this.newInstance(key);
            this.put(key, v);
        }
        return v;
    }
}

