/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.objc;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.bridj.BridJ;
import org.bridj.BridJRuntime;
import org.bridj.CRuntime;
import org.bridj.JNI;
import org.bridj.MethodCallInfo;
import org.bridj.NativeEntities;
import org.bridj.NativeLibrary;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.TypedPointer;
import org.bridj.Utils;
import org.bridj.ann.Library;
import org.bridj.ann.Ptr;
import org.bridj.ann.Runtime;
import org.bridj.objc.ObjCClass;
import org.bridj.objc.ObjCObject;
import org.bridj.objc.Selector;

@Library(value="/usr/lib/libobjc.A.dylib")
@Runtime(value=CRuntime.class)
public class ObjectiveCRuntime
extends CRuntime {
    Map<String, Id> nativeClassesByObjCName = new HashMap<String, Id>();
    Map<String, Class<? extends ObjCObject>> bridjClassesByObjCName = new HashMap<String, Class<? extends ObjCObject>>();

    @Override
    public boolean isAvailable() {
        return JNI.isMacOSX();
    }

    public ObjectiveCRuntime() {
        BridJ.register();
    }

    <T extends ObjCObject> T realCast(Id id) {
        if (id == null) {
            return null;
        }
        Pointer<Byte> cn = ObjectiveCRuntime.object_getClassName(id);
        if (cn == null) {
            throw new RuntimeException("Null class name for this ObjectiveC object pointer !");
        }
        String n = cn.getCString();
        Class<? extends ObjCObject> c = this.bridjClassesByObjCName.get(n);
        if (c == null) {
            throw new RuntimeException("Class " + n + " was not registered yet in the BridJ runtime ! (TODO : auto create by scanning path, then reflection !)");
        }
        return (T)id.getNativeObject(c);
    }

    protected static native Id object_getClass(Id var0);

    protected static native Id objc_getClass(Pointer<Byte> var0);

    protected static native Id objc_getMetaClass(Pointer<Byte> var0);

    protected static native Pointer<Byte> object_getClassName(Id var0);

    protected static native Id class_createInstance(Id var0, @Ptr long var1);

    synchronized Id getClass(String name) {
        Id c = this.nativeClassesByObjCName.get(name);
        if (c == null && (c = ObjectiveCRuntime.objc_getClass(Pointer.pointerToCString(name))) != null) {
            assert (ObjectiveCRuntime.object_getClassName(c).getCString().equals(name));
            this.nativeClassesByObjCName.put(name, c);
        }
        return c;
    }

    @Override
    protected NativeLibrary getNativeLibrary(Class<?> type) throws FileNotFoundException {
        Library libAnn = type.getAnnotation(Library.class);
        if (libAnn != null) {
            try {
                String name = libAnn.value();
                return BridJ.getNativeLibrary(name, new File("/System/Library/Frameworks/" + name + ".framework/" + name));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return super.getNativeLibrary(type);
    }

    @Override
    public void register(Type type) {
        Class typeClass = Utils.getClass(type);
        typeClass.getAnnotation(Library.class);
        Library libAnn = typeClass.getAnnotation(Library.class);
        if (libAnn != null) {
            String name = libAnn.value();
            File libraryFile = BridJ.getNativeLibraryFile(name);
            if (libraryFile != null) {
                System.load(libraryFile.toString());
            }
            if (ObjCObject.class.isAssignableFrom(typeClass)) {
                this.bridjClassesByObjCName.put(typeClass.getSimpleName(), typeClass);
            }
        }
        super.register(type);
    }

    @Override
    protected void registerNativeMethod(Class<?> type, NativeLibrary typeLibrary, Method method, NativeLibrary methodLibrary, NativeEntities.Builder builder) throws FileNotFoundException {
        MethodCallInfo mci = new MethodCallInfo(method);
        Selector sel = method.getAnnotation(Selector.class);
        if (Modifier.isStatic(method.getModifiers())) {
            mci.setNativeClass(this.getClass(type).getPeer());
        }
        if (sel != null) {
            mci.setSymbolName(sel.value());
        } else {
            mci.setSymbolName(method.getName() + ":");
        }
        builder.addObjCMethod(mci);
    }

    @Override
    public <T extends NativeObject> BridJRuntime.TypeInfo<T> getTypeInfo(Type type) {
        return new CRuntime.CTypeInfo<T>(type){

            @Override
            public void initialize(T instance, int constructorId, Object ... args) {
                Id c = ObjectiveCRuntime.this.getClass(this.typeClass);
                if (c == null) {
                    throw new RuntimeException("Failed to get Objective-C class for type " + this.typeClass.getName());
                }
                Pointer<ObjCClass> pc = c.as(ObjCClass.class);
                Pointer p = pc.get().new$();
                if (constructorId != -1) {
                    throw new UnsupportedOperationException("TODO handle constructors !");
                }
                p = ((ObjCObject)p.get()).create();
                ObjectiveCRuntime.this.setNativeObjectPeer(instance, p);
            }
        };
    }

    private Id getClass(Class<? extends NativeObject> class1) {
        return this.getClass(class1.getSimpleName());
    }

    public static class Id
    extends TypedPointer {
        public Id(long peer) {
            super(peer);
        }

        public Id(Pointer<?> ptr) {
            super(ptr);
        }

        public ObjCObject get() {
            return BridJ.getRuntimeByRuntimeClass(ObjectiveCRuntime.class).realCast(this);
        }

        public ObjCObject get(long index) {
            if (index == 0L) {
                return this.get();
            }
            throw new UnsupportedOperationException("Cannot read from an Objective-C object pointer with an index");
        }

        public Object set(long index, Object value) {
            if (index == 0L) {
                return this.set(value);
            }
            throw new UnsupportedOperationException("Cannot write to an Objective-C object pointer");
        }
    }
}

