/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.jawt;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.File;
import org.bridj.BridJ;
import org.bridj.JNI;
import org.bridj.NativeLibrary;
import org.bridj.Pointer;
import org.bridj.jawt.JAWT;
import org.bridj.jawt.JAWT_DrawingSurface;
import org.bridj.jawt.JAWT_DrawingSurfaceInfo;
import org.bridj.jawt.JawtLibrary;

public class JAWTUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static long getNativePeerHandle(Component component) {
        try {
            JAWT awt;
            Pointer<JAWT> pAwt;
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException("No native peers in headless mode.");
            }
            if (component.isLightweight()) {
                throw new IllegalArgumentException("Lightweight components do not have native peers.");
            }
            if (!component.isDisplayable()) {
                throw new IllegalArgumentException("Component that are not displayable do not have native peers.");
            }
            JawtLibrary.JNIEnv env = new JawtLibrary.JNIEnv(JNI.getEnv());
            if (!JawtLibrary.JAWT_GetAWT(env, pAwt = Pointer.pointerTo(awt = new JAWT().version(65540)))) {
                throw new RuntimeException("Failed to get JAWT pointer !");
            }
            Pointer<?> componentPointer = Pointer.pointerToAddress(JNI.newGlobalRef(component));
            Pointer<JAWT_DrawingSurface> pSurface = awt.GetDrawingSurface().as(JAWT.GetDrawingSurface_callback.class).get().invoke(env, componentPointer).as(JAWT_DrawingSurface.class);
            if (pSurface == null) {
                throw new RuntimeException("Cannot get drawing surface from " + component);
            }
            JAWT_DrawingSurface surface = pSurface.get();
            try {
                int lock = surface.Lock().get().invoke(pSurface);
                if ((lock & 1) != 0) {
                    throw new RuntimeException("Cannot lock drawing surface of " + component);
                }
                try {
                    Pointer<JAWT_DrawingSurface.GetDrawingSurfaceInfo_callback> cb = surface.GetDrawingSurfaceInfo().as(JAWT_DrawingSurface.GetDrawingSurfaceInfo_callback.class);
                    Pointer<JAWT_DrawingSurfaceInfo> pInfo = cb.get().invoke(pSurface);
                    if (pInfo != null) {
                        pInfo = pInfo.as(JAWT_DrawingSurfaceInfo.class);
                    }
                    Pointer platformInfo = pInfo.get().platformInfo();
                    long l = platformInfo.getSizeT();
                    surface.Unlock().get().invoke(pSurface);
                    return l;
                }
                catch (Throwable throwable) {
                    surface.Unlock().get().invoke(pSurface);
                    throw throwable;
                }
            }
            finally {
                awt.FreeDrawingSurface().get().invoke(pSurface);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    static {
        try {
            File jawtDll = null;
            if (JNI.isWindows()) {
                jawtDll = new File(new File(System.getProperty("java.home")), "bin\\jawt.dll");
            }
            if (jawtDll != null && jawtDll.exists()) {
                jawtDll = jawtDll.getCanonicalFile();
                NativeLibrary lib = BridJ.getNativeLibrary("jawt", jawtDll);
                System.out.println("Found library " + lib);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

