/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.demos;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bridj.JNI;
import org.bridj.Pointer;
import org.bridj.cpp.com.COMRuntime;
import org.bridj.cpp.com.shell.ITaskbarList3;
import org.bridj.jawt.JAWTUtils;

public class TaskbarListDemo
extends JFrame
implements ActionListener,
ChangeListener {
    ITaskbarList3 list;
    int min = 0;
    int max = 300;
    int val = this.min + this.max / 2;
    JSlider slider;
    Pointer<?> hwnd;

    public TaskbarListDemo() throws ClassNotFoundException {
        super("TaskbarList Demo (" + (JNI.is64Bits() != false ? "64 bits" : "32 bits") + ")");
        this.list = COMRuntime.newInstance(ITaskbarList3.class);
        this.getContentPane().add("Center", new JLabel("Hello Native Windows 7 World !"));
        Box box = Box.createVerticalBox();
        this.slider = new JSlider(this.min, this.max, this.val);
        this.slider.addChangeListener(this);
        box.add(this.slider);
        ButtonGroup group = new ButtonGroup();
        for (ITaskbarList3.TbpFlag state : ITaskbarList3.TbpFlag.values()) {
            JRadioButton cb = new JRadioButton(state.name());
            group.add(cb);
            cb.putClientProperty(ITaskbarList3.TbpFlag.class, state);
            cb.setSelected(state == ITaskbarList3.TbpFlag.TBPF_NORMAL);
            cb.addActionListener(this);
            box.add(cb);
        }
        this.getContentPane().add("South", box);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.list.Release();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        long hwndVal = JAWTUtils.getNativePeerHandle(this);
        this.hwnd = Pointer.pointerToAddress(hwndVal);
        this.list.SetProgressValue(this.hwnd, this.slider.getValue(), this.slider.getMaximum());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.list.SetProgressValue(this.hwnd, this.slider.getValue(), this.slider.getMaximum());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JRadioButton button = (JRadioButton)e.getSource();
        if (button.isSelected()) {
            ITaskbarList3.TbpFlag flag = (ITaskbarList3.TbpFlag)button.getClientProperty(ITaskbarList3.TbpFlag.class);
            this.list.SetProgressValue(this.hwnd, this.slider.getValue(), this.slider.getMaximum());
            this.list.SetProgressState(this.hwnd, flag);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            TaskbarListDemo f = new TaskbarListDemo();
            f.setDefaultCloseOperation(3);
            f.pack();
            f.setVisible(true);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

