/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.cpp.mfc;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridj.Callback;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.Utils;
import org.bridj.cpp.CPPRuntime;
import org.bridj.cpp.mfc.CObject;
import org.bridj.cpp.mfc.CRuntimeClass;
import org.bridj.cpp.mfc.MessageMapBuilder;
import org.bridj.cpp.mfc.OnCommand;
import org.bridj.cpp.mfc.OnCommandEx;
import org.bridj.cpp.mfc.OnMessage;
import org.bridj.cpp.mfc.OnRegisteredMessage;
import org.bridj.cpp.mfc.OnUpdateCommand;

public class MFCRuntime
extends CPPRuntime {
    Method mfcGetMessageMap;
    String mfcGetMessageMapMangling;
    Callback mfcGetMessageMapCallback;
    Set<Class<?>> hasMessageMap = new HashSet();

    @Override
    public <T extends NativeObject> Class<? extends T> getActualInstanceClass(Pointer<T> pInstance, Type officialType) {
        Pointer<CRuntimeClass> pClass;
        Class officialTypeClass = Utils.getClass(officialType);
        if (CObject.class.isAssignableFrom(officialTypeClass) && (pClass = new CObject(pInstance, this).GetRuntimeClass()) != null) {
            CRuntimeClass rtc = pClass.get();
            try {
                Class<?> type = this.getMFCClass(rtc.m_lpszClassName());
                if (officialTypeClass == null || officialTypeClass.isAssignableFrom(type)) {
                    return type;
                }
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            return officialTypeClass;
        }
        return super.getActualInstanceClass(pInstance, officialType);
    }

    private Class<?> getMFCClass(Pointer<Byte> mLpszClassName) throws ClassNotFoundException {
        throw new ClassNotFoundException(mLpszClassName.getCString(0L));
    }

    public void getExtraFieldsOfNewClass(Class<?> type, Map<String, Type> out) {
        if (!this.hasMessageMap.contains(type)) {
            return;
        }
        out.put("messageMap", (Type)((Object)Pointer.class));
    }

    public void getOverriddenVirtualMethods(Map<String, Pointer<?>> out) {
        out.put("mfcGetMessageMap", Pointer.pointerTo(this.mfcGetMessageMapCallback));
    }

    @Override
    public void register(Type type) {
        super.register(type);
        Class typeClass = Utils.getClass(type);
        MessageMapBuilder map = new MessageMapBuilder();
        for (Method method : typeClass.getMethods()) {
            OnMessage onMessage;
            OnRegisteredMessage onRegisteredMessage;
            OnUpdateCommand onUpdateCommand;
            OnCommandEx onCommandEx;
            OnCommand onCommand = method.getAnnotation(OnCommand.class);
            if (onCommand != null) {
                map.add(method, onCommand);
            }
            if ((onCommandEx = method.getAnnotation(OnCommandEx.class)) != null) {
                map.add(method, onCommandEx);
            }
            if ((onUpdateCommand = method.getAnnotation(OnUpdateCommand.class)) != null) {
                map.add(method, onUpdateCommand);
            }
            if ((onRegisteredMessage = method.getAnnotation(OnRegisteredMessage.class)) != null) {
                map.add(method, onRegisteredMessage);
            }
            if ((onMessage = method.getAnnotation(OnMessage.class)) == null) continue;
            map.add(method, onMessage);
        }
        if (!map.isEmpty()) {
            map.register(this, typeClass);
        }
    }
}

