/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.cpp.com;

import org.bridj.BridJ;
import org.bridj.CRuntime;
import org.bridj.Pointer;
import org.bridj.ann.Convention;
import org.bridj.ann.Library;
import org.bridj.ann.Ptr;
import org.bridj.ann.Runtime;
import org.bridj.cpp.CPPRuntime;
import org.bridj.cpp.com.CLSID;
import org.bridj.cpp.com.GUID;
import org.bridj.cpp.com.IID;
import org.bridj.cpp.com.IUnknown;

@Library(value="Ole32")
@Runtime(value=CRuntime.class)
@Convention(value=Convention.Style.StdCall)
public class COMRuntime
extends CPPRuntime {
    public static final int CLSCTX_INPROC_SERVER = 1;
    public static final int CLSCTX_INPROC_HANDLER = 2;
    public static final int CLSCTX_LOCAL_SERVER = 4;
    public static final int CLSCTX_INPROC_SERVER16 = 8;
    public static final int CLSCTX_REMOTE_SERVER = 16;
    public static final int CLSCTX_INPROC_HANDLER16 = 32;
    public static final int CLSCTX_RESERVED1 = 64;
    public static final int CLSCTX_RESERVED2 = 128;
    public static final int CLSCTX_RESERVED3 = 256;
    public static final int CLSCTX_RESERVED4 = 512;
    public static final int CLSCTX_NO_CODE_DOWNLOAD = 1024;
    public static final int CLSCTX_RESERVED5 = 2048;
    public static final int CLSCTX_NO_CUSTOM_MARSHAL = 4096;
    public static final int CLSCTX_ENABLE_CODE_DOWNLOAD = 8192;
    public static final int CLSCTX_NO_FAILURE_LOG = 16384;
    public static final int CLSCTX_DISABLE_AAA = 32768;
    public static final int CLSCTX_ENABLE_AAA = 65536;
    public static final int CLSCTX_FROM_DEFAULT_CONTEXT = 131072;
    public static final int CLSCTX_ACTIVATE_32_BIT_SERVER = 262144;
    public static final int CLSCTX_ACTIVATE_64_BIT_SERVER = 524288;
    public static final int CLSCTX_ENABLE_CLOAKING = 0x100000;
    public static final int CLSCTX_PS_DLL = Integer.MIN_VALUE;
    public static final int CLSCTX_INPROC = 3;
    public static final int CLSCTX_ALL = 23;
    public static final int CLSCTX_SERVER = 21;
    public static final int S_OK = 0;
    public static final int REGDB_E_CLASSNOTREG = -2147221164;
    public static final int CLASS_E_NOAGGREGATION = -2147221232;
    public static final int CO_E_NOTINITIALIZED = -2147221008;
    public static final int E_UNEXPECTED = -2147418113;
    public static final int E_NOTIMPL = -2147467263;
    public static final int E_OUTOFMEMORY = -2147024882;
    public static final int E_INVALIDARG = -2147024809;
    public static final int E_NOINTERFACE = -2147467262;
    public static final int E_POINTER = -2147467261;
    public static final int E_HANDLE = -2147024890;
    public static final int E_ABORT = -2147467260;
    public static final int E_FAIL = -2147467259;
    public static final int E_ACCESSDENIED = -2147024891;
    static ThreadLocal<Object> comInitializer;

    @Deprecated
    public static native int CoCreateInstance(Pointer<Byte> var0, Pointer<IUnknown> var1, int var2, Pointer<Byte> var3, Pointer<Pointer<?>> var4);

    static native int CoInitializeEx(@Ptr long var0, int var2);

    static native int CoInitialize(@Ptr long var0);

    static native void CoUninitialize();

    static void error(int err) {
        switch (err) {
            case -2147418113: 
            case -2147024882: 
            case -2147024809: {
                throw new RuntimeException("Error " + Integer.toHexString(err));
            }
            case 0: {
                return;
            }
            case -2147221008: {
                throw new RuntimeException("CoInitialized wasn't called !!");
            }
            case -2147467262: {
                throw new RuntimeException("Interface does not inherit from class");
            }
            case -2147467261: {
                throw new RuntimeException("Allocated pointer pointer is null !!");
            }
        }
        throw new RuntimeException("Unexpected COM error code : " + err);
    }

    public static <I extends IUnknown> Pointer<Byte> getIID(Class<I> type) {
        IID id = type.getAnnotation(IID.class);
        if (id == null) {
            throw new RuntimeException("No " + IID.class.getName() + " annotation set on type " + type.getName() + " !");
        }
        return GUID.parseGUID128Bits(id.value());
    }

    public static <I extends IUnknown> Pointer<Byte> getCLSID(Class<I> type) {
        CLSID id = type.getAnnotation(CLSID.class);
        if (id == null) {
            throw new RuntimeException("No " + CLSID.class.getName() + " annotation set on type " + type.getName() + " !");
        }
        return GUID.parseGUID128Bits(id.value());
    }

    public static void initialize() {
        comInitializer.get();
    }

    public static <I extends IUnknown> I newInstance(Class<I> type) throws ClassNotFoundException {
        return COMRuntime.newInstance(type, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends IUnknown, I extends IUnknown> I newInstance(Class<T> instanceClass, Class<I> instanceInterface) throws ClassNotFoundException {
        IUnknown iUnknown;
        COMRuntime.initialize();
        Pointer<Pointer<?>> p = Pointer.allocatePointer();
        Pointer<Byte> clsid = COMRuntime.getCLSID(instanceClass);
        Pointer<Byte> uuid = COMRuntime.getIID(instanceInterface);
        try {
            IUnknown instance;
            int ret = COMRuntime.CoCreateInstance(clsid, null, 23, uuid, p);
            if (ret == -2147221164) {
                throw new ClassNotFoundException("COM class is not registered : " + instanceClass.getSimpleName() + " (clsid = " + clsid.getCString() + ")");
            }
            COMRuntime.error(ret);
            Pointer<?> inst = p.getPointer(0L);
            if (inst == null) {
                throw new RuntimeException("Serious low-level issue : CoCreateInstance executed fine but we only retrieved a null pointer !");
            }
            iUnknown = instance = (IUnknown)inst.getNativeObject(instanceInterface);
        }
        catch (Throwable throwable) {
            Pointer.release(p, clsid, uuid);
            throw throwable;
        }
        Pointer.release(p, clsid, uuid);
        return (I)iUnknown;
    }

    static {
        BridJ.register();
        comInitializer = new ThreadLocal<Object>(){

            @Override
            protected Object initialValue() {
                COMRuntime.error(COMRuntime.CoInitializeEx(0L, 0));
                return new Object(){

                    protected void finalize() throws Throwable {
                        COMRuntime.CoUninitialize();
                    }
                };
            }
        };
    }

    public static interface COINIT {
        public static final int COINIT_APARTMENTTHREADED = 2;
        public static final int COINIT_MULTITHREADED = 0;
        public static final int COINIT_DISABLE_OLE1DDE = 4;
        public static final int COINIT_SPEED_OVER_MEMORY = 8;
    }
}

