/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.cpp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bridj.Demangler;
import org.bridj.JNI;
import org.bridj.NativeLibrary;

public class GCC4Demangler
extends Demangler {
    private Map<String, Demangler.TypeRef> shortcuts = new HashMap<String, Demangler.TypeRef>();
    int nextShortcutId = -1;

    public GCC4Demangler(NativeLibrary library, String symbol) {
        super(library, symbol);
    }

    private String nextShortcutId() {
        int n;
        return (n = this.nextShortcutId++) == -1 ? "_" : Integer.toString(n, 36).toUpperCase() + "_";
    }

    private Demangler.TypeRef parseShortcutType() {
        if (this.peekChar() == '_') {
            return this.shortcuts.get(Character.toString(this.consumeChar()));
        }
        String id = "";
        while (this.peekChar() != '_') {
            id = id + this.consumeChar();
        }
        id = id + this.consumeChar();
        Demangler.TypeRef res = this.shortcuts.get(id);
        return res;
    }

    private Demangler.TypeRef parsePointerType() throws Demangler.DemanglingException {
        Demangler.TypeRef pointed = this.parseType();
        Demangler.TypeRef res = GCC4Demangler.pointerType(pointed);
        String id = this.nextShortcutId();
        this.shortcuts.put(id, res);
        return res;
    }

    public Demangler.TypeRef parseType() throws Demangler.DemanglingException {
        if (Character.isDigit(this.peekChar())) {
            String name = this.parseName();
            String id = this.nextShortcutId();
            Demangler.TypeRef res = GCC4Demangler.simpleType(name);
            this.shortcuts.put(id, res);
            return res;
        }
        switch (this.consumeChar()) {
            case 'S': {
                return this.parseShortcutType();
            }
            case 'P': {
                return this.parsePointerType();
            }
            case 'F': {
                while (this.consumeChar() != 'E') {
                }
                return null;
            }
            case 'K': {
                return this.parseType();
            }
            case 'v': {
                return GCC4Demangler.classType(Void.TYPE, new Class[0]);
            }
            case 'a': 
            case 'c': 
            case 'h': {
                return GCC4Demangler.classType(Byte.TYPE, new Class[0]);
            }
            case 'b': {
                return GCC4Demangler.classType(Boolean.TYPE, new Class[0]);
            }
            case 'l': 
            case 'm': {
                return GCC4Demangler.classType(JNI.is64Bits() != false ? Long.TYPE : Integer.TYPE, new Class[0]);
            }
            case 'x': 
            case 'y': {
                return GCC4Demangler.classType(Long.TYPE, new Class[0]);
            }
            case 'i': 
            case 'j': {
                return GCC4Demangler.classType(Integer.TYPE, new Class[0]);
            }
            case 's': 
            case 't': {
                return GCC4Demangler.classType(Short.TYPE, new Class[0]);
            }
            case 'f': {
                return GCC4Demangler.classType(Float.TYPE, new Class[0]);
            }
            case 'd': {
                return GCC4Demangler.classType(Double.TYPE, new Class[0]);
            }
        }
        throw this.error(-1);
    }

    String parseName() throws Demangler.DemanglingException {
        int len;
        char c;
        StringBuilder b = new StringBuilder();
        while (Character.isDigit(c = this.peekChar())) {
            this.consumeChar();
            b.append(c);
        }
        try {
            len = Integer.parseInt(b.toString());
        }
        catch (NumberFormatException ex) {
            throw this.error("Expected a number", 0);
        }
        b.setLength(0);
        for (int i = 0; i < len; ++i) {
            b.append(this.consumeChar());
        }
        return b.toString();
    }

    @Override
    public Demangler.MemberRef parseSymbol() throws Demangler.DemanglingException {
        Demangler.MemberRef mr = new Demangler.MemberRef();
        if (!this.consumeCharIf('_')) {
            mr.setMemberName(this.str);
            return mr;
        }
        this.consumeCharIf('_');
        this.expectChars('Z');
        if (this.consumeCharIf('T')) {
            if (this.consumeCharIf('V')) {
                mr.setEnclosingType(new Demangler.ClassRef(this.parseName()));
                mr.setMemberName((Object)Demangler.SpecialName.VFTable);
                return mr;
            }
            return null;
        }
        ArrayList<String> ns = new ArrayList<String>();
        if (this.consumeCharIf('N')) {
            do {
                ++this.nextShortcutId;
                ns.add(this.parseName());
            } while (Character.isDigit(this.peekChar()));
            --this.nextShortcutId;
            mr.setMemberName(ns.remove(ns.size() - 1));
            if (!ns.isEmpty()) {
                Demangler.ClassRef parent = new Demangler.ClassRef();
                parent.setSimpleName(ns.remove(ns.size() - 1));
                if (!ns.isEmpty()) {
                    parent.setEnclosingType(new Demangler.NamespaceRef(ns.toArray(new String[ns.size()])));
                }
                mr.setEnclosingType(parent);
            } else {
                switch (this.peekChar()) {
                    case 'C': {
                        this.consumeChar();
                        mr.setEnclosingType(new Demangler.ClassRef((String)mr.getMemberName()));
                        if (this.consumeCharIf('1')) {
                            mr.setMemberName((Object)Demangler.SpecialName.Constructor);
                            break;
                        }
                        if (this.consumeCharIf('2')) {
                            mr.setMemberName((Object)Demangler.SpecialName.SpecialConstructor);
                            break;
                        }
                        this.error("Unknown constructor type");
                        break;
                    }
                    case 'D': {
                        this.consumeChar();
                        mr.setEnclosingType(new Demangler.ClassRef((String)mr.getMemberName()));
                        if (this.consumeCharIf('0')) {
                            mr.setMemberName((Object)Demangler.SpecialName.DeletingDestructor);
                            break;
                        }
                        if (this.consumeCharIf('1')) {
                            mr.setMemberName((Object)Demangler.SpecialName.Destructor);
                            break;
                        }
                        if (this.consumeCharIf('2')) {
                            mr.setMemberName((Object)Demangler.SpecialName.SelfishDestructor);
                            break;
                        }
                        this.error("Unknown destructor type");
                    }
                }
            }
        } else {
            mr.setMemberName(this.parseName());
        }
        boolean isMethod = this.consumeCharIf('E');
        if (this.consumeCharIf('v')) {
            if (this.position < this.length) {
                this.error("Expected end of symbol", 0);
            }
            mr.paramTypes = new Demangler.TypeRef[0];
        } else {
            ArrayList<Demangler.TypeRef> paramTypes = new ArrayList<Demangler.TypeRef>();
            while (this.position < this.length) {
                paramTypes.add(this.parseType());
            }
            mr.paramTypes = paramTypes.toArray(new Demangler.TypeRef[paramTypes.size()]);
        }
        return mr;
    }
}

