/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.cpp;

import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bridj.BridJ;
import org.bridj.BridJRuntime;
import org.bridj.CRuntime;
import org.bridj.Demangler;
import org.bridj.JNI;
import org.bridj.MethodCallInfo;
import org.bridj.NativeEntities;
import org.bridj.NativeLibrary;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.Utils;
import org.bridj.ann.Virtual;
import org.bridj.cpp.CPPObject;

public class CPPRuntime
extends CRuntime {
    Map<Class<?>, Integer> virtualMethodsCounts = new HashMap();
    Map<Type, Long> defaultConstructors = new HashMap<Type, Long>();
    Map<Type, Long> destructors = new HashMap<Type, Long>();
    static Boolean enableDestructors;
    Map<Type, Long> vtables = new HashMap<Type, Long>();

    @Override
    public <T extends NativeObject> Class<? extends T> getActualInstanceClass(Pointer<T> pInstance, Type officialType) {
        return Utils.getClass(officialType);
    }

    public int getVirtualMethodsCount(Class<?> type) {
        Integer count = this.virtualMethodsCounts.get(type);
        if (count == null) {
            ArrayList<Method> mets = new ArrayList<Method>();
            this.listVirtualMethods(type, mets);
            count = mets.size();
            this.virtualMethodsCounts.put(type, count);
        }
        return count;
    }

    public void listVirtualMethods(Class<?> type, List<Method> out) {
        if (!CPPObject.class.isAssignableFrom(type)) {
            return;
        }
        for (Method m : type.getDeclaredMethods()) {
            if (m.getAnnotation(Virtual.class) == null) continue;
            out.add(m);
        }
        if ((type = type.getSuperclass()) != CPPObject.class) {
            this.listVirtualMethods(type, out);
        }
    }

    @Override
    protected void registerNativeMethod(Class<?> type, NativeLibrary typeLibrary, Method method, NativeLibrary methodLibrary, NativeEntities.Builder builder) throws FileNotFoundException {
        int modifiers = method.getModifiers();
        boolean isCPPClass = CPPObject.class.isAssignableFrom(method.getDeclaringClass());
        if (!isCPPClass) {
            super.registerNativeMethod(type, typeLibrary, method, methodLibrary, builder);
            return;
        }
        MethodCallInfo mci = new MethodCallInfo(method);
        Virtual va = method.getAnnotation(Virtual.class);
        if (va == null) {
            methodLibrary.getSymbol(method);
            Demangler.Symbol symbol = methodLibrary.getSymbol(method);
            mci.setForwardedPointer(symbol == null ? 0L : symbol.getAddress());
            if (mci.getForwardedPointer() == 0L) {
                assert (this.log(Level.SEVERE, "Method " + method.toGenericString() + " is not virtual but its address could not be resolved in the library."));
                return;
            }
            if (Modifier.isStatic(modifiers)) {
                builder.addFunction(mci);
                assert (this.log(Level.INFO, "Registering " + method + " as function or static C++ method " + symbol.getName()));
            } else {
                builder.addFunction(mci);
                this.log(Level.INFO, "Registering " + method + " as C++ method " + symbol.getName());
            }
        } else {
            int virtualIndex = va.value();
            if (Modifier.isStatic(modifiers)) {
                this.log(Level.WARNING, "Method " + method.toGenericString() + " is native and maps to a function, but is not static.");
            }
            if (virtualIndex < 0) {
                Pointer<Pointer<?>> pVirtualTable;
                Pointer<Pointer<?>> pointer = pVirtualTable = isCPPClass && typeLibrary != null ? Pointer.pointerToAddress(this.getVirtualTable(type, typeLibrary), Pointer.class) : null;
                if (pVirtualTable == null) {
                    this.log(Level.SEVERE, "Method " + method.toGenericString() + " is virtual but the virtual table of class " + type.getName() + " was not found.");
                    return;
                }
                virtualIndex = this.getPositionInVirtualTable(pVirtualTable, method, typeLibrary);
                if (virtualIndex < 0) {
                    this.log(Level.SEVERE, "Method " + method.toGenericString() + " is virtual but its position could not be found in the virtual table.");
                    return;
                }
            }
            Class<?> superclass = type.getSuperclass();
            int virtualOffset = this.getVirtualMethodsCount(superclass);
            boolean isNewVirtual = true;
            if (superclass != null) {
                try {
                    superclass.getMethod(method.getName(), method.getParameterTypes());
                    isNewVirtual = false;
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
            }
            int absoluteVirtualIndex = isNewVirtual ? virtualOffset + virtualIndex : virtualIndex;
            mci.setVirtualIndex(absoluteVirtualIndex);
            this.log(Level.INFO, "Registering " + method.toGenericString() + " as virtual C++ method with relative virtual index = " + virtualIndex + ", absolute index = " + absoluteVirtualIndex);
            builder.addVirtualMethod(mci);
        }
    }

    int getPositionInVirtualTable(Method method, NativeLibrary library) {
        Class<?> type = method.getDeclaringClass();
        Pointer<Pointer<?>> pVirtualTable = Pointer.pointerToAddress(this.getVirtualTable(type, library), Pointer.class);
        return this.getPositionInVirtualTable(pVirtualTable, method, library);
    }

    String getCPPClassName(Class<?> declaringClass) {
        return declaringClass.getSimpleName();
    }

    public int getPositionInVirtualTable(Pointer<Pointer<?>> pVirtualTable, Method method, NativeLibrary library) {
        String methodName = method.getName();
        int methodsOffset = library.isMSVC() ? 0 : -2;
        String className = this.getCPPClassName(method.getDeclaringClass());
        int iVirtual = 0;
        while (true) {
            Pointer<?> pMethod;
            String virtualMethodName;
            String string = virtualMethodName = (pMethod = pVirtualTable.get(methodsOffset + iVirtual)) == null ? null : library.getSymbolName(pMethod.getPeer());
            if (virtualMethodName == null) {
                return -1;
            }
            if (virtualMethodName != null && virtualMethodName.contains(methodName)) {
                return iVirtual;
            }
            if (library.isMSVC() && !virtualMethodName.contains(className)) break;
            ++iVirtual;
        }
        return -1;
    }

    static int getDefaultDyncallCppConvention() {
        int convention = 0;
        if (!JNI.is64Bits().booleanValue() && JNI.isWindows()) {
            convention = 5;
        }
        return convention;
    }

    static boolean enableDestructors() {
        if (enableDestructors == null) {
            String prop = System.getProperty("bridj.destructors");
            String env = System.getenv("BRIDJ_DESTRUCTORS");
            boolean forceTrue = "true".equals(prop) || "1".equals(env);
            boolean forceFalse = "false".equals(prop) || "0".equals(env);
            boolean shouldBeStable = true;
            enableDestructors = forceTrue || shouldBeStable && !forceFalse;
        }
        return enableDestructors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends CPPObject> Pointer<T> newCPPInstance(Type type, int constructorId, Object ... args) {
        Pointer peer = null;
        try {
            final Class typeClass = Utils.getClass(type);
            NativeLibrary lib = BridJ.getNativeLibrary(typeClass);
            Pointer.Releaser releaser = null;
            if (CPPRuntime.enableDestructors()) {
                long destructorAddr;
                Long destructor = this.destructors.get(type);
                if (destructor == null) {
                    Demangler.Symbol symbol = lib.getFirstMatchingSymbol(new NativeLibrary.SymbolAccepter(){

                        @Override
                        public boolean accept(Demangler.Symbol symbol) {
                            return symbol.matchesDestructor(typeClass);
                        }
                    });
                    if (symbol != null) {
                        this.log(Level.INFO, "Registering destructor of " + typeClass.getName() + " as " + symbol.getName());
                    }
                    destructor = symbol == null ? 0L : symbol.getAddress();
                    this.destructors.put(type, destructor);
                }
                if ((destructorAddr = destructor.longValue()) != 0L) {
                    releaser = new Pointer.Releaser(){

                        @Override
                        public void release(Pointer<?> p) {
                            JNI.callSinglePointerArgVoidFunction(destructorAddr, p.getPeer(), CPPRuntime.getDefaultDyncallCppConvention());
                        }
                    };
                }
            }
            peer = Pointer.allocateBytes(PointerIO.getInstance(type), (long)this.sizeOf(type, null), releaser);
            if (constructorId < 0) {
                Long defaultConstructor = this.defaultConstructors.get(type);
                if (defaultConstructor == null) {
                    Demangler.Symbol symbol = lib.getFirstMatchingSymbol(new NativeLibrary.SymbolAccepter(){

                        @Override
                        public boolean accept(Demangler.Symbol symbol) {
                            return symbol.matchesConstructor(typeClass);
                        }
                    });
                    if (symbol != null) {
                        this.log(Level.INFO, "Registering default constructor of " + typeClass.getName() + " as " + symbol.getName());
                    }
                    defaultConstructor = symbol == null ? 0L : symbol.getAddress();
                    this.defaultConstructors.put(type, defaultConstructor);
                    if (defaultConstructor == 0L) {
                        throw new RuntimeException("Cannot find the default constructor for type " + typeClass.getName());
                    }
                }
                this.installVTablePtr(type, lib, peer);
                JNI.callSinglePointerArgVoidFunction(defaultConstructor, peer.getPeer(), CPPRuntime.getDefaultDyncallCppConvention());
                return peer;
            }
            Method meth = this.getConstructor(typeClass, constructorId, args);
            Object[] consArgs = new Object[args.length + 1];
            if (CPPObject.class.isAssignableFrom(typeClass)) {
                if (meth.getReturnType() != Void.TYPE) {
                    throw new RuntimeException("Constructor-mapped methods must return void, but " + meth.getName() + " returns " + meth.getReturnType().getName());
                }
                if (!Modifier.isStatic(meth.getModifiers())) {
                    throw new RuntimeException("Constructor-mapped methods must be static, but " + meth.getName() + " is not.");
                }
                if (!meth.getName().equals(typeClass.getSimpleName())) {
                    throw new RuntimeException("Constructor methods must have the same name as their class : " + meth.getName() + " is not " + typeClass.getSimpleName());
                }
                this.installVTablePtr(type, lib, peer);
            }
            consArgs[0] = peer.getPeer();
            System.arraycopy(args, 0, consArgs, 1, args.length);
            boolean acc = meth.isAccessible();
            try {
                meth.setAccessible(true);
                meth.invoke(null, consArgs);
            }
            finally {
                try {
                    meth.setAccessible(acc);
                }
                catch (Exception ex) {}
            }
            return peer;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (peer != null) {
                peer.release();
            }
            throw new RuntimeException("Failed to allocate new instance of type " + type, ex);
        }
    }

    long getVirtualTable(Type type, NativeLibrary library) {
        Long vtable = this.vtables.get(type);
        if (vtable == null) {
            final Class typeClass = Utils.getClass(type);
            Demangler.Symbol symbol = library.getFirstMatchingSymbol(new NativeLibrary.SymbolAccepter(){

                @Override
                public boolean accept(Demangler.Symbol symbol) {
                    return symbol.matchesVirtualTable(typeClass);
                }
            });
            if (symbol != null) {
                this.log(Level.INFO, "Registering vtable of " + typeClass.getName() + " as " + symbol.getName());
            }
            vtable = symbol == null ? 0L : symbol.getAddress();
            this.vtables.put(type, vtable);
        }
        return vtable;
    }

    boolean installVTablePtr(Type type, NativeLibrary lib, Pointer<?> peer) {
        long vtable = this.getVirtualTable(type, lib);
        if (vtable != 0L) {
            peer.setSizeT(0L, vtable);
        }
        return vtable != 0L;
    }

    @Override
    public <T extends NativeObject> BridJRuntime.TypeInfo<T> getTypeInfo(Type type) {
        return new CRuntime.CTypeInfo<T>(type){

            @Override
            public long sizeOf(T instance) {
                return super.sizeOf(instance);
            }

            @Override
            public void initialize(T instance, int constructorId, Object ... args) {
                if (instance instanceof CPPObject) {
                    CPPRuntime.this.setNativeObjectPeer(instance, CPPRuntime.this.newCPPInstance(this.typeClass, constructorId, args));
                } else {
                    super.initialize(instance, constructorId, args);
                }
            }

            @Override
            public T clone(T instance) throws CloneNotSupportedException {
                if (instance instanceof CPPObject) {
                    // empty if block
                }
                return super.clone(instance);
            }

            @Override
            public void destroy(T instance) {
            }
        };
    }
}

